/*
 Copyright (c) 2014 Shinji Tsuneyuki
 This file is distributed under the terms of the GNU General Public License version 3.
 */

/*!
 \file qtctrl.h
 \brief QTRg[̓NX
*/

#ifndef __QTCTRL_H_INCLUDED
#define __QTCTRL_H_INCLUDED

#include <QtGui/QtGui>

class DTModel;
class GLView;
class QTLattice;
class QTXTapp;
class QTGraphics;
class QTAtoms;

class QTCtrl : public QWidget
{
  Q_OBJECT

private:
  DTModel&    model;
  GLView&     view;

public:
  QTLattice*  lattice;
  QTAtoms*    atoms;
  QTXTapp*    xtapp;
  QTGraphics* graphics;

  enum { ID_LATTICE, ID_ATOMS, ID_XTAPP, ID_TCPP, ID_GRAPHICS };

public:
  QTCtrl( DTModel& _model, GLView& _view );
signals:
  void changed( void );
public slots:
  void update( void );

public:
  void showLattice( void );
  void showAtoms( void );
  void showXTapp( void );
  void showGraphics( void );
};

#endif // __QTCTRL_H_INCLUDED
