/*
 Copyright (c) 2014 Shinji Tsuneyuki
 This file is distributed under the terms of the GNU General Public License version 3.
 */

/*!
 \file qtexception.cc
 \brief QTG[ΉNX
*/

#include <QtGui/QtGui>
#include "qtexception.h"

void MyException::critical( const QString& message )
{
  critical(message,"");
}


void MyException::critical( const MyException& e )
{
  critical(e.message,e.filename);
}

void MyException::critical( const QString& message,
			    const QString& filename )
{
  QString message2;
  
  if( filename == "" ){
    message2.sprintf("Error: %s\n",
		    qPrintable(message) );
  }
  else{
    message2.sprintf("Error: %s\nFile: %s\n",
		    qPrintable(message), qPrintable(filename) );
  }

  fprintf(stderr,"%s\n", qPrintable(message2) );
  QMessageBox::critical( NULL, "Error", message2, QMessageBox::Ok );
}

void MyException::information( const QString& message )
{
  information(message,"");
}

void MyException::information( const MyException& e )
{
  information(e.message,e.filename);
}

void MyException::information( const QString& message,
			    const QString& filename )
{
  QString message2;
  
  if( filename == NULL ){
    message2.sprintf("Info: %s\n",
		    qPrintable(message) );
  }
  else{
    message2.sprintf("Info: %s\nFile: %s\n",
		    qPrintable(message), qPrintable(filename) );
  }

  fprintf(stderr,"%s\n", qPrintable(message2) );
  QMessageBox::information( NULL, "Info", message2, QMessageBox::Ok );
}

void MyException::warning( const QString& message )
{
  warning(message,"");
}

void MyException::warning( const MyException& e )
{
  warning(e.message,e.filename);
}


void MyException::warning( const QString& message,
			    const QString& filename )
{
  QString message2;
  
  if( filename == NULL ){
    message2.sprintf("Warning: %s\n",
		    qPrintable(message) );
  }else{
    message2.sprintf("Warning: %s\nFile: %s\n",
		    qPrintable(message), qPrintable(filename) );
  }

  fprintf(stderr,"%s\n", qPrintable(message2) );
  QMessageBox::warning( NULL, "Warning", message2, QMessageBox::Ok );
}

bool MyException::question( const QString& message )
{
  return QMessageBox::Ok == QMessageBox::question
    ( NULL, "Question", message, QMessageBox::Ok, QMessageBox::No );
}
