/*
 Copyright (c) 2014 Shinji Tsuneyuki
 This file is distributed under the terms of the GNU General Public License version 3.
 */

/*!
 \file qtexception.h
 \brief QTG[ΉNX
*/

#ifndef __EXCEPTION_H_INCLUDED
#define __EXCEPTION_H_INCLUDED

#include <QtCore/QString>
#include "qtmisc.h"

struct MyException
{
  QString message;
  QString filename;
  MyException( const QString& message ){
    this->message  = message;
    this->filename = "";
  }
  MyException( const QString& message, const QString& filename ){
    this->message  = message;
    this->filename = filename;
  }
public:
  static void critical( const QString& message );
  static void critical( const QString& message,
			const QString& filename );
  static void critical( const MyException& e );

  static void information( const QString& message );
  static void information( const QString& message,
			   const QString& filename );
  static void information( const MyException& e );

  static void warning( const QString& message );
  static void warning( const QString& message,
		       const QString& filename );
  static void warning( const MyException& e );


  static bool question( const QString& message );
};

#endif // __EXCEPTION_H_INCLUDED
