/*
 Copyright (c) 2014 Shinji Tsuneyuki
 This file is distributed under the terms of the GNU General Public License version 3.
 */

/*!
 \file qtglfield.cc
 \brief tB[hGL\GUI\̓NX
*/

#include "dtmodel.h"
#include "qtglfield.h"

QTGLField::QTGLField( DTModel& _model, const int id ) : MyQTab(id), model(_model)
{
  QHBoxLayout* hlayout = new QHBoxLayout(this);
  hlayout->setSizeConstraint( QLayout::SetFixedSize );

  QVBoxLayout* vlayout1 = new QVBoxLayout;
  QVBoxLayout* vlayout2 = new QVBoxLayout;
  QVBoxLayout* vlayout3 = new QVBoxLayout;

  {
    MyQCheckBox* widget = new MyQCheckBox
      ( "show field", model.gloption.field.show,
	this, SLOT(edit(const MyEvent&)), ID_FIELD );
    vlayout1->addWidget(widget);
  }

  //--------- which
  {
    QGroupBox* group = new QGroupBox("Field mode");
    QGridLayout* grid = new QGridLayout;
    int row=0;

    {
      MyQRadioButton* widget = new MyQRadioButton
	( "single",
	  model.field.multi.mode, 0,
	  this, SLOT(edit(const MyEvent&)), ID_WHICH );
      grid->addWidget(widget,row,0);
      vwidget.push_back(widget);
    }
    //    row++;
    {
      QGroupBox* group = new QGroupBox("field index to show");
      QHBoxLayout* box = new QHBoxLayout;

      box->addWidget(new QLabel("No."));
      {
	MyQSpinBox* widget = new MyQSpinBox
	  ( model.field.idata, 0, 0,
	    this, SLOT(edit(const MyEvent&)), ID_SINGLE_INDEX );
	widget->setFixedWidth(40);
	box->addWidget(widget);
	vwidget.push_back(widget);
	spinbox_single = widget;
      }
      {
	MyQLabel* widget = new MyQLabel("of 0 fields");
	box->addWidget(widget);
	vwidget.push_back(widget);
	label_single = widget;
      }
      group->setLayout(box);

      grid->addWidget(group,row,1);
    }

    row++;
    {
      MyQRadioButton* widget = new MyQRadioButton
	( "multiple",
	  model.field.multi.mode, 1,
	  this, SLOT(edit(const MyEvent&)), ID_WHICH );
      grid->addWidget(widget,row,0);
      vwidget.push_back(widget);
    }
    row++;
    {
      MyQRadioButton* widget = new MyQRadioButton
	( "slater",
	  model.field.multi.mode, 2,
	  this, SLOT(edit(const MyEvent&)), ID_WHICH );
      grid->addWidget(widget,row,0);
      vwidget.push_back(widget);
    }
    //    row++;
    {
      QGroupBox* group = new QGroupBox("coordinates index to edit");
      QHBoxLayout* box = new QHBoxLayout;

      box->addWidget(new QLabel("No."));
      {
	MyQSpinBox* widget = new MyQSpinBox
	  ( model.field.multi.index_shown, 0, 0,
	    this, SLOT(edit(const MyEvent&)), ID_SLATER_INDEX );
	widget->setFixedWidth(40);
	box->addWidget(widget);
	vwidget.push_back(widget);
	spinbox_slater = widget;
      }
      {
	MyQLabel* widget = new MyQLabel("of 0 coords");
	box->addWidget(widget);
	vwidget.push_back(widget);
	label_slater = widget;
      }
      group->setLayout(box);

      grid->addWidget(group,row,1);
    }
    row++;

    {
      MyQGroupBox* group = new MyQGroupBox
	( "slater coordinates",
	  model.field.multi.coord_manual,
	  this, SLOT(edit(const MyEvent&)), ID_SLATER_COORD );
      vwidget.push_back(group);

      QGridLayout* box = new QGridLayout;
      int srow=0;

      checkbox_sl_manual = (MyQCheckBox*)(QWidget*)group;

      for( int i=0; i<3; i++ ){
	MyQLineEdit* widget = new MyQLineEdit
	  (
	   model.field.multi.coord_shown(i), 0.0, 1.0,
	   this, SLOT(edit(const MyEvent&)), ID_SLATER_COORD );
	widget->setFixedWidth(60);
	//	lineedit_sl_coord[i] = widget;
	box->addWidget(widget,srow,i);
	vwidget.push_back(widget);
      }
      group->setLayout(box);
      grid->addWidget(group,row,0,1,3);
    }
    row++;

    //--------- range
    {
      MyQGroupBox* group = new MyQGroupBox
	("field range",
	 model.gloption.field.range_manual,
	 this, SLOT(edit(const MyEvent&)), ID_MANUAL );
      vwidget.push_back(group);

      QHBoxLayout* box = new QHBoxLayout;
      box->addWidget(new QLabel("min:"));
      {
	MyQLineEdit* widget = new MyQLineEdit
	  (
	   model.gloption.field.data_min, -1.0e+99, +1.0e+99,
	   this, SLOT(edit(const MyEvent&)), ID_RANGE );
	widget->setFixedWidth(70);
	box->addWidget(widget);
	vwidget.push_back(widget);
      }
      box->addWidget(new QLabel("max:"));
      {
	MyQLineEdit* widget = new MyQLineEdit
	  (
	   model.gloption.field.data_max, -1.0e+99, +1.0e+99,
	   this, SLOT(edit(const MyEvent&)), ID_RANGE );
	widget->setFixedWidth(70);
	box->addWidget(widget);
	vwidget.push_back(widget);
      }

      group->setLayout(box);
      grid->addWidget(group,row,0,1,3);
    }
    row++;

    group->setLayout(grid);
    vlayout1->addWidget(group);
    group_which = group;
  }
  hlayout->addLayout(vlayout1);


  {
    MyQGroupBox* group = new MyQGroupBox
      ("Isosurfaces",
       model.gloption.field.isosurf.show,
       this, SLOT(edit(const MyEvent&)), ID_ISOSURF_SHOWN );
    vwidget.push_back(group);

    QGridLayout* grid = new QGridLayout;
    int row=0;

    {
      QGroupBox* group = new QGroupBox("surface index to edit");
      QHBoxLayout* box = new QHBoxLayout;

      box->addWidget(new QLabel("No."), Qt::AlignRight );
      {
	MyQSpinBox* widget = new MyQSpinBox
	  ( model.gloption.field.isosurf.index_shown, 0, 0,
	    this, SLOT(edit(const MyEvent&)), ID_ISOSURF_INDEX );
	widget->setFixedWidth(30);
	box->addWidget(widget);
	vwidget.push_back(widget);
	spinbox_index = widget;
      }
      {
	MyQLabel* widget = new MyQLabel("of 0 surfaces");
	box->addWidget(widget);
	vwidget.push_back(widget);
	label_size = widget;
      }
      group->setLayout(box);

      grid->addWidget(group,row,0,1,3);
    }
    row++;

    {
      MyQEditSlider* widget = new MyQEditSlider
	( "isosurface value", "value:", "", "low", "high",
	  model.gloption.field.isosurf.value_shown, 0.0, 1.0,
	  this, SLOT(edit(const MyEvent&)), ID_ISOSURF_VALUE );
      widget->setFixedWidth(180);
      vwidget.push_back(widget);
      widget_isosurf1 = widget;
      grid->addWidget(widget,row,0,1,3);
    }
    row++;

    {
      MyQPushButton* widget = new MyQPushButton
	( "add", this, SLOT(edit(const MyEvent&)), ID_ISOSURF_ADD );
      widget->setFixedWidth(60);
      grid->addWidget(widget,row,0);
      widget_isosurf2 = widget;
      vwidget.push_back(widget);
    }
    {
      MyQPushButton* widget = new MyQPushButton
	( "del", this, SLOT(edit(const MyEvent&)), ID_ISOSURF_DEL );
      widget->setFixedWidth(60);
      grid->addWidget(widget,row,1);
      widget_isosurf3 = widget;
      vwidget.push_back(widget);
    }
    row++;

    {
      grid->addWidget(new QLabel("faint"), row, 0,Qt::AlignRight );
    }
    {
      MyQSlider* widget = new MyQSlider
	( model.gloption.field.isosurf.alpha, 0.01, 1.0,
	  this, SLOT(edit(const MyEvent&)), ID_ISOSURF_VALUE );
      widget->setFixedWidth(80);
      grid->addWidget(widget, row, 1 );
      widget_isosurf4 = widget;
      vwidget.push_back(widget);
    }
    {
      grid->addWidget(new QLabel("clear"), row, 2, Qt::AlignLeft  );
    }

    group->setLayout(grid);
    vlayout2->addWidget(group);

    group_isosurf = group;
  }

  {
    MyQGroupBox* group = new MyQGroupBox
      ("Fog",
       model.gloption.field.fog.show,
       this, SLOT(edit(const MyEvent&)), ID_FOG );
    vwidget.push_back(group);
    QGridLayout* grid = new QGridLayout;
    int row=0;
    int col=0;
    {
      grid->addWidget(new QLabel("less"), row, col );
      col++;
    }
    {
      MyQSlider* widget = new MyQSlider
	( model.gloption.field.fog.scale, 0.0, 1.0,
	  this, SLOT(edit(const MyEvent&)), ID_FOG );
      widget->setFixedWidth(60);
      grid->addWidget(widget, row, col );
      vwidget.push_back(widget);
      slider_fog = widget;
      col++;
    }
    {
      grid->addWidget(new QLabel("more"), row, col );
      col++;
    }
    row++,col=0;
    {
      grid->addWidget(new QLabel("faint"), row, col );
      col++;
    }
    {
      MyQSlider* widget = new MyQSlider
	( model.gloption.field.fog.alpha, 0.0, 1.0,
	  this, SLOT(edit(const MyEvent&)), ID_FOG );
      widget->setFixedWidth(60);
      grid->addWidget(widget, row, col );
      vwidget.push_back(widget);
      slider_fog = widget;
      col++;
    }
    {
      grid->addWidget(new QLabel("dense"), row, col );
      col++;
    }

    group->setLayout(grid);
    vlayout2->addWidget(group);

    group_fog = group;
  }

  hlayout->addLayout(vlayout2);

  {
    int row=0;
    QGroupBox* group = new QGroupBox("Cross sections");
    QGridLayout* box = new QGridLayout;
    {
      MyQCheckBox* widget = new MyQCheckBox
	( "show A", model.gloption.field.crosec.showA,
	  this, SLOT(edit(const MyEvent&)), ID_CROSEC );
      widget->setFixedWidth(80);
      box->addWidget(widget, row, 0 );
      vwidget.push_back(widget);
    }
    {
      MyQSlider* widget = new MyQSlider
	( model.gloption.field.crosec.scaleA, 0.0, 1.0,
	  this, SLOT(edit(const MyEvent&)), ID_CROSEC );
      widget->setFixedWidth(80);
      box->addWidget(widget, row, 1 );
      vwidget.push_back(widget);
      slider_crosecx = widget;
    }
    row++;
    {
      MyQCheckBox* widget = new MyQCheckBox
	( "show B", model.gloption.field.crosec.showB,
	  this, SLOT(edit(const MyEvent&)), ID_CROSEC );
      box->addWidget(widget, row, 0 );
      vwidget.push_back(widget);
    }
    {
      MyQSlider* widget = new MyQSlider
	( model.gloption.field.crosec.scaleB, 0.0, 1.0,
	  this, SLOT(edit(const MyEvent&)), ID_CROSEC );
      widget->setFixedWidth(80);
      box->addWidget(widget, row, 1 );
      vwidget.push_back(widget);
      slider_crosecy = widget;
    }
    row++;
    {
      MyQCheckBox* widget = new MyQCheckBox
	( "show C", model.gloption.field.crosec.showC,
	  this, SLOT(edit(const MyEvent&)), ID_CROSEC );
      box->addWidget(widget, row, 0 );
      vwidget.push_back(widget);
    }
    {
      MyQSlider* widget = new MyQSlider
	( model.gloption.field.crosec.scaleC, 0.0, 1.0,
	  this, SLOT(edit(const MyEvent&)), ID_CROSEC );
      widget->setFixedWidth(80);
      box->addWidget(widget, row, 1 );
      vwidget.push_back(widget);
      slider_crosecz = widget;
    }
    row++;
    {
      int rowhow=0;
      QGroupBox* group = new QGroupBox("how");
      QGridLayout* boxhow = new QGridLayout;

      {
	MyQCheckBox* widget = new MyQCheckBox
	  ( "plane",
	    model.gloption.field.crosec.plane.show,
	    this, SLOT(edit(const MyEvent&)), ID_CROSEC );
	boxhow->addWidget(widget,rowhow,0,1,3);
	vwidget.push_back(widget);
      }
      rowhow++;

      {
	boxhow->addWidget(new QLabel("faint"), rowhow, 0 );
      }
      {
	MyQSlider* widget = new MyQSlider
	  ( model.gloption.field.crosec.plane.alpha, 0.1, 1.0,
	    this, SLOT(edit(const MyEvent&)), ID_CROSEC );
	widget->setFixedWidth(80);
	boxhow->addWidget(widget, rowhow, 1 );
	vwidget.push_back(widget);
      }
      {
	boxhow->addWidget(new QLabel("clear"), rowhow, 2 );
      }
      rowhow++;

      {
	MyQCheckBox* widget = new MyQCheckBox
	  ( "isoline",
	    model.gloption.field.crosec.isoline.show,
	    this, SLOT(edit(const MyEvent&)), ID_CROSEC );
	boxhow->addWidget(widget,rowhow,0,1,3);
	vwidget.push_back(widget);
      }
      rowhow++;
      {
	boxhow->addWidget(new QLabel("lines:"), rowhow, 0 );
      }
      {
	MyQSpinBox* widget = new MyQSpinBox
	  ( 
	   model.gloption.field.crosec.isoline.lines, 8, 256,
	   this, SLOT(edit(const MyEvent&)), ID_CROSEC );
	boxhow->addWidget(widget, rowhow, 1 );
	vwidget.push_back(widget);
      }
      rowhow++;
      {
	MyQCheckBox* widget = new MyQCheckBox
	  ( "gradient",
	    model.gloption.field.crosec.gradient.show,
	    this, SLOT(edit(const MyEvent&)), ID_CROSEC );
	boxhow->addWidget(widget,rowhow,0,1,3);
	vwidget.push_back(widget);
      }
      rowhow++;
      {
	boxhow->addWidget(new QLabel("short"), rowhow, 0 );
      }
      {
	MyQSlider* widget = new MyQSlider
	  ( model.gloption.field.crosec.gradient.scale, 0.01, 10.0,
	    this, SLOT(edit(const MyEvent&)), ID_CROSEC );
	widget->setFixedWidth(80);
	boxhow->addWidget(widget, rowhow, 1 );
	vwidget.push_back(widget);
      }
      {
	boxhow->addWidget(new QLabel("long"), rowhow, 2 );
      }
      rowhow++;
      {
	boxhow->addWidget(new QLabel("thin"), rowhow, 0 );
      }
      {
	MyQSlider* widget = new MyQSlider
	  ( model.gloption.field.crosec.gradient.thick, 1.0, 4.0,
	    this, SLOT(edit(const MyEvent&)), ID_CROSEC );
	widget->setFixedWidth(80);
	boxhow->addWidget(widget, rowhow, 1 );
	vwidget.push_back(widget);
      }
      {
	boxhow->addWidget(new QLabel("thick"), rowhow, 2 );
      }

      group->setLayout(boxhow);

      group_how = group;
      box->addWidget(group, row, 0, 1, 2 );
    }

    group->setLayout(box);
    vlayout3->addWidget(group);

    group_crosec = group;
  }

  hlayout->addLayout(vlayout3);

  setLayout(hlayout);

  update();
}

void QTGLField::edit( const MyEvent& ev )
{
  switch(ev.id){
  case ID_FIELD : {
  } break;
  case ID_WHICH : {
    switch( model.field.multi.mode ){
    case 0 : { // single
    } break;
    case 1 : { // mutiple
    } break;
    case 2 : { // slater
      model.calcSlater();
      emit modified(MyEvent(id));
    } break;
    }
    model.gloption.field.data_min = model.field.data_min();
    model.gloption.field.data_max = model.field.data_max();
  } break;
  case ID_SINGLE_INDEX : {
  } break;
  case ID_SLATER_INDEX : {
    model.field.multi.update_shown();
  } break;
  case ID_SLATER_COORD : {
    model.field.multi.change_shown();
    model.calcSlater();
    emit modified(MyEvent(id));
  } break;
  case ID_MANUAL : {
  } break;
  case ID_RANGE : {
  } break;
  case ID_FOG : {
  } break;
  case ID_ISOSURF_SHOWN : {
  } break;
  case ID_ISOSURF_INDEX : {
    model.gloption.field.isosurf.update_shown();
  } break;
  case ID_ISOSURF_VALUE : {
    model.gloption.field.isosurf.change_shown();
  } break;
  case ID_ISOSURF_ADD : {
    model.gloption.field.isosurf.add();
  } break;
  case ID_ISOSURF_DEL : {
    model.gloption.field.isosurf.del();
  } break;
  case ID_CROSEC : {
  } break;
  default: break;
  }

  emit changed(MyEvent(id));
}

void QTGLField::update( void )
{
  if( !model.field.isset() ){
    this->setEnabled(false);
    return;
  }else{
    this->setEnabled(true);
  }

  model.field.multi.update_shown();

  spinbox_single->setRange( 1, model.field.getSize() );
  if( model.field.getSize()>=2 ){
    spinbox_slater->setRange( 1, model.field.multi.vcoord.size() );
  }
  else{
    spinbox_slater->setRange( 0, 0 );
  }

  switch( model.field.multi.mode ){
  case 0 : { // single
    spinbox_single->setEnabled(true);
    spinbox_slater->setEnabled(false);

    checkbox_sl_manual->setEnabled(false);
  } break;
  case 1 : { // multiple
    spinbox_single->setEnabled(false);
    spinbox_slater->setEnabled(false);

    checkbox_sl_manual->setEnabled(false);
  } break;
  case 2 : { // slater
    spinbox_single->setEnabled(false);
    spinbox_slater->setEnabled(true);

    checkbox_sl_manual->setEnabled(true);
  } break;
  }

  if( model.gloption.field.range_manual ){
  }else{
    model.gloption.field.data_min = model.field.data_min();
    model.gloption.field.data_max = model.field.data_max();
  }

  if( model.gloption.field.show ){
    group_which->setEnabled(true);
    group_fog->setEnabled(true);
    group_isosurf->setEnabled(true);
    group_crosec->setEnabled(true);
  }else{
    group_which->setEnabled(false);
    group_fog->setEnabled(false);
    group_isosurf->setEnabled(false);
    group_crosec->setEnabled(false);
  }

  spinbox_index->setRange( 1, model.gloption.field.isosurf.vvalue.size() );
  {
    char text[32];
    snprintf( text, sizeof(text), "of %d surfs",
	      (int)model.gloption.field.isosurf.vvalue.size() );
    label_size->setText(text);
  }
  {
    char text[32];
    snprintf( text, sizeof(text), "of %d fields",
	      (int)model.field.getSize() );
    label_single->setText(text);
  }
  {
    char text[32];
    snprintf( text, sizeof(text), "of %d coords",
	      (int)model.field.multi.vcoord.size() );
    label_slater->setText(text);
  }

  {
    const double min = 
      0.95*model.gloption.field.data_min + 0.05*model.gloption.field.data_max;
    const double max = 
      0.05*model.gloption.field.data_min + 0.95*model.gloption.field.data_max;

    widget_isosurf1->setRange(min,max);
  }

  if( model.gloption.field.isosurf.show ){
    model.gloption.field.isosurf.update_shown();
  }else{
  }

  if( model.gloption.field.crosec.showA ){
    slider_crosecx->setEnabled(true);
  }else{
    slider_crosecx->setEnabled(false);
  }

  if( model.gloption.field.crosec.showB ){
    slider_crosecy->setEnabled(true);
  }else{
    slider_crosecy->setEnabled(false);
  }

  if( model.gloption.field.crosec.showC ){
    slider_crosecz->setEnabled(true);
  }else{
    slider_crosecz->setEnabled(false);
  }

  if( model.gloption.field.crosec.showA ||
      model.gloption.field.crosec.showB ||
      model.gloption.field.crosec.showC ){
    group_how->setEnabled(true);
  }else{
    group_how->setEnabled(false);
  }

  MyQTab::update();
}
