/*
 Copyright (c) 2014 Shinji Tsuneyuki
 This file is distributed under the terms of the GNU General Public License version 3.
 */

/*!
 \file qtglfield.h
 \brief tB[hGL\GUI\̓NX
*/

#ifndef __QTGLFIELD_H_INCLUDED
#define __QTGLFIELD_H_INCLUDED

#include "qtwidgets.h"

class DTModel;

class QTGLField : public MyQTab
{
  Q_OBJECT

private:
  DTModel& model;

  enum { ID_FIELD, ID_WHICH,
	 ID_SINGLE_INDEX, ID_SLATER_INDEX, ID_SLATER_COORD,
	 ID_MANUAL, ID_RANGE,
	 ID_FOG,
	 ID_ISOSURF_SHOWN, ID_ISOSURF_INDEX,
	 ID_ISOSURF_VALUE, ID_ISOSURF_ADD, ID_ISOSURF_DEL,
	 ID_CROSEC };

  QGroupBox* group_which;
  MyQCheckBox*  checkbox_manual;
  MyQLineEdit* lineedit_min;
  MyQLineEdit* lineedit_max;

  MyQCheckBox*  checkbox_sl_manual;
  MyQLineEdit* lineedit_sl_coord[3];

  MyQSpinBox*  spinbox_single;
  MyQSpinBox*  spinbox_slater;
  MyQSpinBox*  spinbox_index;

  QGroupBox* group_fog;
  QGroupBox* group_isosurf;
  QGroupBox* group_crosec;
  QSlider*   slider_fog;

  MyQLabel*  label_single;
  MyQLabel*  label_slater;
  MyQLabel*  label_size;
  MyQEditSlider*   widget_isosurf1;
  QWidget*   widget_isosurf2;
  QWidget*   widget_isosurf3;
  QWidget*   widget_isosurf4;

  QSlider*   slider_crosecx;
  QSlider*   slider_crosecy;
  QSlider*   slider_crosecz;

  QGroupBox* group_how;

public:
  QTGLField( DTModel& _model, const int id );
signals:
  void changed(const MyEvent&);
  void modified(const MyEvent&);
public slots:
  void update( void );
private slots:
  void edit( const MyEvent& ev );
};

#endif // __QTGLFIELD_H_INCLUDED
