/*
 Copyright (c) 2014 Shinji Tsuneyuki
 This file is distributed under the terms of the GNU General Public License version 3.
 */

/*!
 \file qtgllattice.cc
 \brief iqGL\GUI\̓NX
*/

#include "dtmodel.h"
#include "qtgllattice.h"

QTGLLattice::QTGLLattice( DTModel& _model, const int id ) :  MyQTab(id), model(_model)
{
  QGridLayout* layout = new QGridLayout(this);
  layout->setSizeConstraint( QLayout::SetFixedSize );

  {
    MyQCheckBox* widget = new MyQCheckBox
      ( "show lattices", model.gloption.lattice.show,
	this, SLOT(edit(const MyEvent&)), ID_LATTICE );
    layout->addWidget(widget,0,0);
  }
  /*
  {
    QGroupBox* group = new QGroupBox("lattice index to show");
    QHBoxLayout* box = new QHBoxLayout;

    box->addWidget(new QLabel("No."));
    {
      static int dummy = 0;
      MyQSpinBox* widget = new MyQSpinBox
	( dummy, 0, 0,
	  this, SLOT(edit(const MyEvent&)), ID_INDEX );
      widget->setFixedWidth(40);
      box->addWidget(widget);
      vwidget.push_back(widget);
      spinbox_index = widget;
    }
    {
      MyQLabel* widget = new MyQLabel("of 0 lattice");
      box->addWidget(widget);
      vwidget.push_back(widget);
      label_index = widget;
    }
    group->setLayout(box);
    group_index = group;
    layout->addWidget(group,1,0,1,2);
  }
  */
  {
    MyQGroupBox* group = new MyQGroupBox
      ( "atoms", model.gloption.lattice.atom.show,
	  this, SLOT(edit(const MyEvent&)), ID_ATOM );
    vwidget.push_back(group);

    QGridLayout* box = new QGridLayout;
    int row=0;
    /*
    {
      MyQCheckBox* widget = new MyQCheckBox
	( "show copys", model.gloption.lattice.atom.show_copy,
	  this, SLOT(edit(const MyEvent&)), ID_ATOM );
      box->addWidget(widget, row, 0, 1, 3 );
      vwidget.push_back(widget);
    }
    row++;
    */

    {
      box->addWidget(new QLabel("small"), row, 0 );
    }
    {
      MyQSlider* widget = new MyQSlider
	( model.gloption.lattice.atom.scale,  0.1, 2.0,
	  this, SLOT(edit(const MyEvent&)), ID_ATOM );
      box->addWidget(widget, row, 1 );
      vwidget.push_back(widget);
    }
    {
      box->addWidget(new QLabel("large"), row, 2 );
    }
    row++;
    {
      box->addWidget(new QLabel("rough"), row, 0 );
    }
    {
      MyQSlider* widget = new MyQSlider
	( model.gloption.lattice.atom.slices,  4.0, 32.0,
	  this, SLOT(edit(const MyEvent&)), ID_ATOM );
      box->addWidget(widget, row, 1 );
      vwidget.push_back(widget);
    }
    {
      box->addWidget(new QLabel("smooth"), row, 2 );
    }
    row++;
    {
      MyQCheckBox* widget = new MyQCheckBox
	( "by square dots", model.gloption.lattice.atom.points,
	  this, SLOT(edit(const MyEvent&)), ID_ATOM );
      box->addWidget(widget, row, 0, 1, 3 );
      vwidget.push_back(widget);
    }

    group->setLayout(box);
    layout->addWidget(group,2,0);
    group_atom = group;
  }


  //----
  {
    MyQGroupBox* group = new MyQGroupBox
      ("bonds", model.gloption.lattice.bond.show,
	  this, SLOT(edit(const MyEvent&)), ID_BOND );
    vwidget.push_back(group);

    QGridLayout* box = new QGridLayout;
    int row=0;
    /*
    {
      MyQCheckBox* widget = new MyQCheckBox
	( "show copys", model.gloption.lattice.bond.show_copy,
	  this, SLOT(edit(const MyEvent&)), ID_BOND );
      box->addWidget(widget, row, 0, 1, 3 );
      vwidget.push_back(widget);
    }
    row++;
    */
    {
      box->addWidget(new QLabel("thin"), row, 0 );
    }
    {
      MyQSlider* widget = new MyQSlider
	( model.gloption.lattice.bond.scale,  0.1, 2.0/8,
	  this, SLOT(edit(const MyEvent&)), ID_BOND );
      box->addWidget(widget, row, 1 );
      vwidget.push_back(widget);
    }
    {
      box->addWidget(new QLabel("thick"), row, 2 );
    }
    row++;
    {
      box->addWidget(new QLabel("rough"), row, 0 );
    }
    {
      MyQSlider* widget = new MyQSlider
	( model.gloption.lattice.bond.slices,  4.0, 32.0,
	  this, SLOT(edit(const MyEvent&)), ID_BOND );
      box->addWidget(widget, row, 1 );
      vwidget.push_back(widget);
    }
    {
      box->addWidget(new QLabel("smooth"), row, 2 );
    }
    row++;
    {
      MyQCheckBox* widget = new MyQCheckBox
	( "by segments", model.gloption.lattice.bond.lines,
	  this, SLOT(edit(const MyEvent&)), ID_BOND );
      box->addWidget(widget, row, 0, 1, 3 );
      vwidget.push_back(widget);
    }
    row++;

    group->setLayout(box);
    layout->addWidget(group,2,1);

    group_bond = group;
  }

  setLayout(layout);

  update();
}

void QTGLLattice::edit( const MyEvent& ev )
{
  switch(ev.id){
  case ID_LATTICE : {
  } break;
  case ID_INDEX : {
  } break;
  case ID_ATOM : {
  } break;
  case ID_BOND : {
  } break;
  case ID_BOX : {
  } break;
  default: break;
  }

  emit changed(MyEvent(id));
}

void QTGLLattice::update( void )
{
  if( model.gloption.lattice.show ){
    //    group_index->setEnabled(true);
    group_atom->setEnabled(true);
    group_bond->setEnabled(true);
  }else{
    //    group_index->setEnabled(false);
    group_atom->setEnabled(false);
    group_bond->setEnabled(false);
  }
  /*
  spinbox_index->setRange( 1, model.lattice.getSize() );
  {
    char text[32];
    snprintf( text, sizeof(text), "of %d lattices",
	      (int)model.lattice.getSize() );
    label_index->setText(text);
  }
  */
  MyQTab::update();
}
