/*
 Copyright (c) 2014 Shinji Tsuneyuki
 This file is distributed under the terms of the GNU General Public License version 3.
 */

/*!
 \file qtgllattice.h
 \brief iqGL\GUI\̓NX
*/

#ifndef __QTGLLATTICE_H_INCLUDED
#define __QTGLLATTICE_H_INCLUDED

#include "qtwidgets.h"

class DTModel;

class QTGLLattice : public MyQTab
{
  Q_OBJECT

private:
  DTModel& model;

  enum { ID_LATTICE, ID_INDEX, ID_ATOM, ID_BOND, ID_BOX };

  QGroupBox*  group_index;
  MyQSpinBox* spinbox_index;
  MyQLabel*   label_index;
  QGroupBox*  group_atom;
  QGroupBox*  group_bond;
  QGroupBox*  group_box;
  vector<QWidget*> vwidget_atom;
  vector<QWidget*> vwidget_bond;

public:
  QTGLLattice( DTModel& _model, const int id );
signals:
  void changed(const MyEvent&);
public slots:
  void update( void );
private slots:
  void edit( const MyEvent& ev );
};

#endif // __QTGLLATTICE_H_INCLUDED
