/*
 Copyright (c) 2014 Shinji Tsuneyuki
 This file is distributed under the terms of the GNU General Public License version 3.
 */

/*!
 \file qtglmisc.cc
 \brief ̑GL\GUI\̓NX
*/

#include "dtmodel.h"
#include "qtmisc.h"
#include "qtglmisc.h"
#include "symbol.h"

QTGLMisc::QTGLMisc( DTModel& _model, const int id ) : MyQTab(id), model(_model)
{
  QHBoxLayout* layout  = new QHBoxLayout(this);
  layout->setSizeConstraint( QLayout::SetFixedSize );

  QVBoxLayout* layout1 = new QVBoxLayout;
  {
    QGroupBox* group = new QGroupBox("Light effect");
    QGridLayout* box = new QGridLayout;
    {
      MyQCheckBox* widget = new MyQCheckBox
	( "second light effect", model.gloption.light.second,
	  this, SLOT(edit(const MyEvent&)), ID_EFFECT );
      box->addWidget(widget);
      vwidget.push_back(widget);
    }
    {
      MyQCheckBox* widget = new MyQCheckBox
	( "fog effect", model.gloption.light.fog,
	  this, SLOT(edit(const MyEvent&)), ID_EFFECT );
      box->addWidget(widget);
      vwidget.push_back(widget);
    }
    group->setLayout(box);
    layout1->addWidget(group);
  }

  {
    QGroupBox* group = new QGroupBox("Field misc objects");
    QGridLayout* box = new QGridLayout;

    {
      MyQCheckBox* widget = new MyQCheckBox
	( "lattice frame", model.gloption.lattice.cell.show,
	  this, SLOT(edit(const MyEvent&)), ID_EFFECT );
      box->addWidget(widget);
      vwidget.push_back(widget);
    }
    {
      MyQCheckBox* widget = new MyQCheckBox
	( "field frame", model.gloption.field.frame.show,
	  this, SLOT(edit(const MyEvent&)), ID_EFFECT );
      box->addWidget(widget);
      vwidget.push_back(widget);
    }
    {
      MyQCheckBox* widget = new MyQCheckBox
	( "field bar", model.gloption.field.bar.show,
	  this, SLOT(edit(const MyEvent&)), ID_EFFECT );
      box->addWidget(widget);
      vwidget.push_back(widget);
    }
    {
      MyQCheckBox* widget = new MyQCheckBox
	( "XYZ axis", model.gloption.lattice.axis.show,
	  this, SLOT(edit(const MyEvent&)), ID_EFFECT );
      box->addWidget(widget);
      vwidget.push_back(widget);
    }
    group->setLayout(box);
    layout1->addWidget(group);
  }

  {
    QGroupBox* group = new QGroupBox("Color of object");
    QVBoxLayout* box = new QVBoxLayout;

    box->addWidget(new QLabel("target to edit:"));
    {
      MyQComboBox* widget = new MyQComboBox
	( model.gloption.icolor, model.gloption.vcolorname,
	  this, SLOT(edit(const MyEvent&)), ID_COLOR );
      box->addWidget(widget);
      vwidget.push_back(widget);

      combo_color = widget;
    }

    {
      MyQPushButton* widget = new MyQPushButton
	("edit", this, SLOT(edit(const MyEvent&)), ID_COLORDIAG );
      box->addWidget(widget);
      vwidget.push_back(widget);
    }
    group->setLayout(box);
    layout1->addWidget(group);
  }
  layout->addLayout(layout1);



  QVBoxLayout* layout2 = new QVBoxLayout;
  {
    // atom radius table
    {
      layout2->addWidget(new QLabel("atom radius:"));
    }
    {
      // element, radius
      table_atom = new QTableWidget( 0, 2, this );
      table_atom->setFixedHeight(110);
      //      table_atom->setSelectionMode( QAbstractItemView::ExtendedSelection );
      //      table_atom->setSelectionBehavior( QAbstractItemView::SelectRows );

      connect(table_atom,SIGNAL(itemChanged(QTableWidgetItem*)),this,SLOT(itemEditedAtom(QTableWidgetItem*)) );
      connect(table_atom,SIGNAL(itemSelectionChanged()),this,SLOT(itemSelectedAtom()) );
      int row=0;
      table_atom->setHorizontalHeaderItem(row,new QTableWidgetItem("elem"));
      table_atom->setColumnWidth(row++,60);
      table_atom->setHorizontalHeaderItem(row,new QTableWidgetItem("radius"));
      table_atom->setColumnWidth(row++,100);
      layout2->addWidget(table_atom);
    }

    // bond length table
    {
      layout2->addWidget(new QLabel("bond length:"));
    }
    {
      // element1, element2, length
      table_bond = new QTableWidget( 0, 3, this );
      table_bond->setFixedHeight(110);
      //      table_bond->setSelectionMode( QAbstractItemView::ExtendedSelection );
      //      table_bond->setSelectionBehavior( QAbstractItemView::SelectRows );

      connect(table_bond,SIGNAL(itemChanged(QTableWidgetItem*)),this,SLOT(itemEditedBond(QTableWidgetItem*)) );
      connect(table_bond,SIGNAL(itemSelectionChanged()),this,SLOT(itemSelectedBond()) );
      int row=0;
      table_bond->setHorizontalHeaderItem(row,new QTableWidgetItem("elem"));
      table_bond->setColumnWidth(row++,60);
      table_bond->setHorizontalHeaderItem(row,new QTableWidgetItem("elem"));
      table_bond->setColumnWidth(row++,60);
      table_bond->setHorizontalHeaderItem(row,new QTableWidgetItem("length"));
      table_bond->setColumnWidth(row++,100);
      layout2->addWidget(table_bond);
    }
    /*
    {
      QGridLayout* box = new QGridLayout;
      {
	MyQPushButton* widget = new MyQPushButton
	  ( "del", this, SLOT(edit(const MyEvent&)), ID_DEL );
	box->addWidget( widget, 0, 0 );
      }
      {
	MyQPushButton* widget = new MyQPushButton
	  ( "add",    this, SLOT(edit(const MyEvent&)), ID_ADD );
	box->addWidget( widget, 0, 1 );
      }
      layout2->addLayout(box);
    }
    */
  }
  layout->addLayout(layout2);

  setLayout(layout);

  update();
}

void QTGLMisc::edit( const MyEvent& ev )
{
  switch(ev.id){
  case ID_EFFECT : {
    emit changed(MyEvent(id));
  } break;

  case ID_COLOR :  break;
  case ID_COLORDIAG : {
    GLcolor& color = model.gloption.getColorTarget();
    QColor color_orig;

    color_orig.setRedF( color.R );
    color_orig.setGreenF( color.G );
    color_orig.setBlueF( color.B );

    QColor color_new = QColorDialog::getColor( color_orig, this);

    if( color_new.isValid() ){
      color = GLcolor
	( color_new.redF(),
	  color_new.greenF(),
	  color_new.blueF() );
      emit changed(MyEvent(id));
    }
  } break;
  default: break;
  }

}

void QTGLMisc::update( void )
{
  combo_color->update();
  {
    table_bond->blockSignals(true);

    vector<GLOption::Lattice::Atom::byElement>& velement 
      = model.gloption.lattice.atom.velement;

    if( table_atom->rowCount() != (int)velement.size() ){
      table_atom->clearContents();
      table_atom->setRowCount(velement.size());

      for( int n=0; n<(int)velement.size(); n++ ){
	int row=0;
	QTableWidgetItem* item = new QTableWidgetItem;
	item->setFlags( Qt::NoItemFlags );
	table_atom->setItem(n,row++,item); // element
	table_atom->setItem(n,row++,new QTableWidgetItem); // radius
      }
    }

    for( int n=0; n<(int)velement.size(); n++ ){
      int row=0;
      {
	QTableWidgetItem* item = table_atom->item(n,row++);
	item->setText( tr("%1").arg
		       ( (ElementSymbol::getAtomicName(n)) ) );
      }
      {
	QTableWidgetItem* item = table_atom->item(n,row++);
	item->setText( tr("%1").arg(velement[n].radius) );
      }
    }

    table_atom->blockSignals(false);
  }

  {
    table_bond->blockSignals(true);

    vector<GLOption::Lattice::Bond::byElement>& velement 
      = model.gloption.lattice.bond.velement;

    if( table_bond->rowCount() != 1+(int)velement.size() ){
      table_bond->clearContents();
      table_bond->setRowCount(1+velement.size());

      for( int n=0; n<(int)velement.size(); n++ ){
	int row=0;
	table_bond->setItem(n,row++,new QTableWidgetItem); // element
	table_bond->setItem(n,row++,new QTableWidgetItem); // element
	table_bond->setItem(n,row++,new QTableWidgetItem); // length
      }
      // the last row is empty
      {
	int n=(int)velement.size();
	int row=0;
	table_bond->setItem(n,row++,new QTableWidgetItem); // element
	table_bond->setItem(n,row++,new QTableWidgetItem); // element
	table_bond->setItem(n,row++,new QTableWidgetItem); // radius
      }
    }

    for( int n=0; n<(int)velement.size(); n++ ){
      int row=0;
      {
	QTableWidgetItem* item = table_bond->item(n,row++);
	item->setText( tr("%1").arg
		       ( (ElementSymbol::getAtomicName(velement[n].id1)) ) );
      }
      {
	QTableWidgetItem* item = table_bond->item(n,row++);
	item->setText( tr("%1").arg
		       ( (ElementSymbol::getAtomicName(velement[n].id2))) );
      }
      {
	QTableWidgetItem* item = table_bond->item(n,row++);
	item->setText( tr("%1").arg(velement[n].length) );
      }
    }

    table_bond->blockSignals(false);
  }
}



void QTGLMisc::itemSelectedAtom( void )
{
}

void QTGLMisc::itemSelectedBond( void )
{
}

void QTGLMisc::itemEditedAtom( QTableWidgetItem* item )
{
  table_atom->blockSignals(true);

  vector<GLOption::Lattice::Atom::byElement>& velement 
    = model.gloption.lattice.atom.velement;

  const int n = item->row();
  GLOption::Lattice::Atom::byElement& element = velement[n];

  switch( item->column() ){
  case 0 : { // element
    // do not change element
    item->setText( tr("%1").arg
		   ( (ElementSymbol::getAtomicName(n)) ) );
  } break;
  case 1 : { // radius
    double radius;
    if( 1 == sscanf( qPrintable(item->text()), "%lf", &radius ) ){
      item->setText( tr("%1").arg(radius) );
      if( element.radius != radius ){
	element.radius = radius;
	emit changed(MyEvent(id));
      }
    }
    else{ // reset by original
      item->setText( tr("%1").arg(element.radius) );
    }
  } break;
  }

  table_atom->blockSignals(false);
}

void QTGLMisc::itemEditedBond( QTableWidgetItem* item )
{
  table_atom->blockSignals(true);

  vector<GLOption::Lattice::Bond::byElement>& velement 
    = model.gloption.lattice.bond.velement;

  const int n = item->row();

  // new element
  if( n==(int)velement.size() ){
    velement.push_back(GLOption::Lattice::Bond::byElement());
  }
  GLOption::Lattice::Bond::byElement& element = velement[n];

  switch( item->column() ){
  case 0 : { // element
    char name[8];
    if( 1 == sscanf( qPrintable(item->text()), "%s", name ) ){
      item->setText( tr("%1").arg(name) );
      const int id1 = ElementSymbol::getAtomicNumber(name);
      if( element.id1 != id1 ){
	element.id1 = id1;
	emit changed(MyEvent(id));
      }
    }
    else{ // reset by original
      item->setText( tr("%1").arg
		     ( (ElementSymbol::getAtomicName(element.id1)) ) );
    }
  } break;
  case 1 : { // element
    char name[8];
    if( 1 == sscanf( qPrintable(item->text()), "%s", name ) ){
      item->setText( tr("%1").arg(name) );
      const int id2 = ElementSymbol::getAtomicNumber(name);
      if( element.id2 != id2 ){
	element.id2 = id2;
	emit changed(MyEvent(id));
      }
    }
    else{ // reset by original
      item->setText( tr("%1").arg
		     ( (ElementSymbol::getAtomicName(element.id2)) ) );
    }
  } break;
  case 2 : { // length
    double length;
    if( 1 == sscanf( qPrintable(item->text()), "%lf", &length ) ){
      item->setText( tr("%1").arg(length) );
      if( element.length != length ){
	element.length = length;
	emit changed(MyEvent(id));
      }
    }
    else{ // if failed, remove this element
      velement.erase( velement.begin()+n );
	emit changed(MyEvent(id));
    }
  } break;
  }

  table_atom->blockSignals(false);
}
