/*
 Copyright (c) 2014 Shinji Tsuneyuki
 This file is distributed under the terms of the GNU General Public License version 3.
 */

/*!
 \file qtglmisc.h
 \brief ̑GL\GUI\̓NX
*/

#ifndef __QTGLMISC_H_INCLUDED
#define __QTGLMISC_H_INCLUDED

#include "qtwidgets.h"

class DTModel;

class QTGLMisc : public MyQTab
{
  Q_OBJECT

private:
  DTModel& model;

  enum { ID_EFFECT, ID_COLOR, ID_COLORDIAG };

  MyQComboBox*  combo_color;
  QTableWidget* table_bond;
  QTableWidget* table_atom;

public:
  QTGLMisc( DTModel& _model, const int id );
public slots:
  void update( void );
private slots:
  void edit( const MyEvent& ev );

private slots:
  void itemSelectedAtom( void );
  void itemEditedAtom( QTableWidgetItem* );
  void itemSelectedBond( void );
  void itemEditedBond( QTableWidgetItem* );
};

#endif // __QTGLMISC_H_INCLUDED
