/*
 Copyright (c) 2014 Shinji Tsuneyuki
 This file is distributed under the terms of the GNU General Public License version 3.
 */

/*!
 \file qtglperiodic.cc
 \brief GL\GUI\̓NX
*/

#include "dtmodel.h"
#include "qtglperiodic.h"

QTGLPeriodic::QTGLPeriodic( DTModel& _model, const int id ) : MyQTab(id), model(_model)
{
  QHBoxLayout* hlayout = new QHBoxLayout(this);
  hlayout->setSizeConstraint( QLayout::SetFixedSize );

  QVBoxLayout* vlayout1 = new QVBoxLayout;

  {
    QGroupBox* group = new QGroupBox("periodic scrolling");
    QHBoxLayout* box = new QHBoxLayout;

    {
      MyQEditSlider* widget = new MyQEditSlider
	( "along A-vector", "", "", "", "",
	  model.gloption.location.scrollA, 0.0, 1.0,
	    this, SLOT(edit(const MyEvent&)), ID_SCROLL );
      box->addWidget(widget);
      widget->setFixedWidth(120);
      vwidget.push_back(widget);
    }

    {
      MyQEditSlider* widget = new MyQEditSlider
	( "along B-vector", "", "", "", "",
	  model.gloption.location.scrollB, 0.0, 1.0,
	  this, SLOT(edit(const MyEvent&)), ID_SCROLL );
      box->addWidget(widget);
      widget->setFixedWidth(120);
      vwidget.push_back(widget);
    }

    {
      MyQEditSlider* widget = new MyQEditSlider
	( "along C-vector", "", "", "", "",
	  model.gloption.location.scrollC, 0.0, 1.0,
	  this, SLOT(edit(const MyEvent&)), ID_SCROLL );
      box->addWidget(widget);
      widget->setFixedWidth(120);
      vwidget.push_back(widget);
    }

    group->setLayout(box);
    vlayout1->addWidget(group);

    group_scroll = group;
  }


  {
    QGroupBox* group = new QGroupBox("periodic extension");
    QHBoxLayout* box = new QHBoxLayout;

    {
      QGroupBox* sgroup = new QGroupBox("along A-vector");
      QVBoxLayout* sbox = new QVBoxLayout;
      {
	MyQSpinBox* widget = new MyQSpinBox
	  ( model.gloption.location.extendA, 0, 100,
	    this, SLOT(edit(const MyEvent&)), ID_EXTEND );
	widget->setFixedWidth(60);
	widget->setSuffix("%");
	widget->setSingleStep(2);
	sbox->addWidget(widget);
	sgroup->setLayout(sbox);

	vwidget.push_back(widget);
      }

      box->addWidget(sgroup);
    }

    {
      QGroupBox* sgroup = new QGroupBox("along B-vector");
      QVBoxLayout* sbox = new QVBoxLayout;
      {
	MyQSpinBox* widget = new MyQSpinBox
	  ( model.gloption.location.extendB, 0, 100,
	    this, SLOT(edit(const MyEvent&)), ID_EXTEND );
	widget->setFixedWidth(60);
	widget->setSuffix("%");
	widget->setSingleStep(2);
	sbox->addWidget(widget);
	sgroup->setLayout(sbox);

	vwidget.push_back(widget);
      }

      box->addWidget(sgroup);
    }

    {
      QGroupBox* sgroup = new QGroupBox("along C-vector");
      QVBoxLayout* sbox = new QVBoxLayout;
      {
	MyQSpinBox* widget = new MyQSpinBox
	  ( model.gloption.location.extendC, 0, 100,
	    this, SLOT(edit(const MyEvent&)), ID_EXTEND );
	widget->setFixedWidth(60);
	widget->setSuffix("%");
	widget->setSingleStep(2);
	sbox->addWidget(widget);
	sgroup->setLayout(sbox);

	vwidget.push_back(widget);
      }

      box->addWidget(sgroup);
    }

    group->setLayout(box);
    vlayout1->addWidget(group);

    group_extend = group;
  }
  //---- 
  {
    QGroupBox* group = new QGroupBox("Wigner-Seitz Cell");
    QHBoxLayout* box = new QHBoxLayout;

    {
      MyQCheckBox* widget = new MyQCheckBox
	( "show inside a Wigner-Seitz Cell", model.gloption.location.wigner,
	  this, SLOT(edit(const MyEvent&)), ID_WIGNER );
      box->addWidget(widget);
    }

    group->setLayout(box);
    vlayout1->addWidget(group);

    group_wigner = group;
  }

  hlayout->addLayout(vlayout1);

  setLayout(hlayout);
}


void QTGLPeriodic::edit( const MyEvent& ev )
{
  switch(ev.id){
  case ID_SCROLL : {
    emit changed(MyEvent(id));
  } break;
  case ID_EXTEND : {
    emit changed(MyEvent(id));
  } break;
  case ID_WIGNER : {
    emit changed(MyEvent(id));
  } break;
  }
}

void QTGLPeriodic::update( void )
{
  if( model.lattice.isclustering() ){
    model.gloption.location.scrollA = 0.0;
    model.gloption.location.scrollB = 0.0;
    model.gloption.location.scrollC = 0.0;
    model.gloption.location.extendA = 0;
    model.gloption.location.extendB = 0;
    model.gloption.location.extendC = 0;
    model.gloption.location.wigner  = false;
    group_scroll->setEnabled(false);
    group_extend->setEnabled(false);
    group_wigner->setEnabled(false);
  }else{
    group_scroll->setEnabled(true);
    group_extend->setEnabled(true);
    group_wigner->setEnabled(true);
  }

  if( model.gloption.location.wigner ){
    model.gloption.location.extendA = 0;
    model.gloption.location.extendB = 0;
    model.gloption.location.extendC = 0;
    group_extend->setEnabled(false);
  }
  else{
    group_extend->setEnabled(true);
  }

  MyQTab::update();
}
