/*
 Copyright (c) 2014 Shinji Tsuneyuki
 This file is distributed under the terms of the GNU General Public License version 3.
 */

/*!
 \file qtglperiodic.h
 \brief GL\GUI\̓NX
*/

#ifndef __QTGLPERIODIC_H_INCLUDED
#define __QTGLPERIODIC_H_INCLUDED

#include "qtwidgets.h"

class DTModel;

class QTGLPeriodic : public MyQTab
{
  Q_OBJECT

private:
  DTModel& model;

  enum { ID_SCROLL, ID_EXTEND, ID_WIGNER };

  QGroupBox* group_scroll;
  QGroupBox* group_extend;
  QGroupBox* group_wigner;

public:
  QTGLPeriodic( DTModel& _model, const int id );
public slots:
  void update( void );
private slots:
  void edit( const MyEvent& ev );
};

#endif // __QTGLPERIODIC_H_INCLUDED
