/*
 Copyright (c) 2014 Shinji Tsuneyuki
 This file is distributed under the terms of the GNU General Public License version 3.
 */

/*!
 \file qtgraphics.cc
 \brief GL\GUI\̓NX
*/

#include "qtgllattice.h"
#include "qtglfield.h"
#include "qtglperiodic.h"
#include "qtglmisc.h"
#include "qtgraphics.h"

QTGraphics::QTGraphics( DTModel& _model, const int _id ) :
  model(_model), id(_id)
{
  QVBoxLayout* layout = new QVBoxLayout(this);
  //  layout->setSizeConstraint( QLayout::SetFixedSize );

  //  setFixedSize(700,430);
  setMinimumSize(700,430);
  setWindowTitle("Graphics settings");

  {
    QTabWidget* group = new QTabWidget;

    {
      lattice = new QTGLLattice( model, ID_LATTICE );
      group->addTab(lattice, "Lattice");
      connect(lattice, SIGNAL(changed(const MyEvent&)), this, SLOT(edit(const MyEvent&)) );
    }
    {
      field = new QTGLField( model, ID_FIELD );
      group->addTab(field, "Field");
      connect(field, SIGNAL(changed(const MyEvent&)), this, SLOT(edit(const MyEvent&)) );
    }
    {
      periodic = new QTGLPeriodic( model, ID_PERIODIC );
      group->addTab(periodic, "Periodicity");
      connect(periodic, SIGNAL(changed(const MyEvent&)), this, SLOT(edit(const MyEvent&)) );
    }
    {
      misc = new QTGLMisc( model, ID_MISC );
      group->addTab(misc, "Miscellaneous");
      connect(misc, SIGNAL(changed(const MyEvent&)), this, SLOT(edit(const MyEvent&)) );
    }

    layout->addWidget(group);
    setLayout(layout);
  }

  {
    MyQPushButton* widget = new MyQPushButton
      ( "close", this, SLOT(edit(const MyEvent&)), ID_CLOSE );
    layout->addWidget(widget);
  }
  setLayout(layout);
}

void QTGraphics::edit( const MyEvent& ev )
{
  switch(ev.id){
  case ID_LATTICE : {
    emit changed();
  } break;
  case ID_FIELD : {
    emit changed();
  } break;
  case ID_PERIODIC : {
    emit changed();
  } break;
  case ID_MISC :  {
    emit changed();
  } break;
  case ID_CLOSE : {
    hide();
  } break;
  default: break;
  }
}

void QTGraphics::update( void )
{
  lattice->update();  
  field->update();  
  periodic->update();  
  misc->update();  
}


