/*
 Copyright (c) 2014 Shinji Tsuneyuki
 This file is distributed under the terms of the GNU General Public License version 3.
 */

/*!
 \file qtgraphics.h
 \brief GL\GUI\̓NX
*/

#ifndef __QTGRAPHICS_H_INCLUDED
#define __QTGRAPHICS_H_INCLUDED

#include <QtGui/QtGui>

class DTModel;
class QTGLLattice;
class QTGLField;
class QTGLPeriodic;
class QTGLMisc;

class MyEvent;

class QTGraphics : public QWidget
{
  Q_OBJECT

private:
  DTModel&    model;

  QTGLLattice*  lattice;
  QTGLField*    field;
  QTGLPeriodic* periodic;
  QTGLMisc*     misc;

  const int id;
  enum { ID_LATTICE, ID_FIELD, ID_PERIODIC, ID_MISC, ID_CLOSE };

public:
  QTGraphics( DTModel& _model, const int id );
signals:
  void changed( void );
public slots:
  void update( void );
private slots:
  void edit( const MyEvent& ev );
};

#endif // __QTGRAPHICS_H_INCLUDED
