/*
 Copyright (c) 2014 Shinji Tsuneyuki
 This file is distributed under the terms of the GNU General Public License version 3.
 */

/*!
 \file qtlattice.cc
 \brief iqGUI\̓NX
*/

#include "dtmodel.h"
#include "qtcell.h"
#include "qtsymmetry.h"
#include "qtlattice.h"
#include "qtcluster.h"
#include "qtbrillouin.h"

QTLattice::QTLattice( DTModel& _model, const int _id ) :
  model(_model), id(_id)
{
  QVBoxLayout* layout = new QVBoxLayout(this);
  //  layout->setSizeConstraint( QLayout::SetFixedSize );

  setMinimumSize( 512, 512 );
  setSizePolicy( QSizePolicy::Expanding, QSizePolicy::Expanding );
  setWindowTitle("Lattice settings");

  {
    QTabWidget* widget = new QTabWidget;

    // cell tab
    {
      cell = new QTCell( model, ID_CELL );
      widget->addTab(cell, "Cell");
      connect(cell, SIGNAL(changed(const MyEvent&)), this, SLOT(edit(const MyEvent&)) );
    }
    // symmetry tab
    {
      symmetry = new QTSymmetry( model, ID_SYMMETRY );
      widget->addTab(symmetry, "Symmetry");
      connect(symmetry, SIGNAL(changed(const MyEvent&)), this, SLOT(edit(const MyEvent&)) );
    }
    // cluster tab
    {
      cluster = new QTCluster( model, ID_CLUSTER );
      widget->addTab(cluster, "Clustering");
      connect(cluster, SIGNAL(changed(const MyEvent&)), this, SLOT(edit(const MyEvent&)) );
    }
    {
      brillouin = new QTBrillouin( model, ID_BRILLOUIN );
      widget->addTab(brillouin, "Brillouin");
      connect(brillouin, SIGNAL(changed(const MyEvent&)), this, SLOT(edit(const MyEvent&)) );
    }


    layout->addWidget(widget);
  }

  QHBoxLayout* box = new QHBoxLayout;
  {
    MyQPushButton* widget = new MyQPushButton
      ( "close", this, SLOT(edit(const MyEvent&)), ID_CLOSE );
    box->addWidget( widget );
  }
  {
    MyQPushButton* widget = new MyQPushButton
      ( "undo", this, SLOT(edit(const MyEvent&)), ID_UNDO );
    box->addWidget( widget );
  }

  layout->addLayout(box);

  setLayout(layout);
}


void QTLattice::edit( const MyEvent& ev )
{
  switch(ev.id){
  case ID_CELL : {
    emit changed();
  } break;
  case ID_SYMMETRY : {
    emit changed();
  } break;
  case ID_CLUSTER : {
    emit changed();
  } break;
  case ID_BRILLOUIN : {
    emit changed();
  } break;

  case ID_CLOSE : {
    hide();
  } break;
  case ID_UNDO : {
    model.undo();
  } break;
  default: break;
  }
}

void QTLattice::update( void )
{
  cell->update();  
  symmetry->update();  
  cluster->update();  
  brillouin->update();
}
