/*
 Copyright (c) 2014 Shinji Tsuneyuki
 This file is distributed under the terms of the GNU General Public License version 3.
 */

/*!
 \file qtlattice.h
 \brief 
*/

#ifndef __QTLATTICE_H_INCLUDED
#define __QTLATTICE_H_INCLUDED

#include <QtGui/QtGui>

class DTModel;
class QTCell;
class QTSymmetry;
class QTCluster;
class QTBrillouin;

class MyEvent;

class QTLattice : public QWidget
{
  Q_OBJECT

private:
  DTModel&     model;
  const int id;

  enum { ID_CELL, ID_SYMMETRY, ID_CLUSTER, ID_BRILLOUIN, 
	 ID_CLOSE, ID_UNDO };

  QTCell*      cell;
  QTSymmetry*  symmetry;
  QTCluster*   cluster;
  QTBrillouin* brillouin;

public:
  QTLattice( DTModel& _model, const int id );
signals:
  void changed( void );
public slots:
  void update( void );

private:
  void updateBrillouin( void );

private slots:
  void edit( const MyEvent& ev );
};

#endif // __QTLATTICE_H_INCLUDED
