/*
 Copyright (c) 2014 Shinji Tsuneyuki
 This file is distributed under the terms of the GNU General Public License version 3.
 */

#ifndef __QTMISC_H_INCLUDED
#define __QTMISC_H_INCLUDED

#include <math.h>

static inline FILE* fopen( const QString& fname, const char* mode )
{
  return fopen(qPrintable(fname),mode);
}

static inline double findAppRange( double& max, double& min )
{
  double diff   = max-min;
  if( diff == 0.0 ) return diff;

  double scale  = pow( 10.0, floor(log10(diff)) );
  double factor = diff/scale;

  if( 1.0<=factor && factor< 2.0 ){
    diff =  2.0/10*scale;
  }
  else if( 2.0<=factor && factor< 5.0 ){
    diff =  5.0/10*scale;
  }
  else if( 5.0<=factor && factor<10.0 ){
    diff = 10.0/10*scale;
  }
  else{
    diff = scale;
  }

  max = ceil (max/diff)*diff;
  min = floor(min/diff)*diff;

  return diff;
}

static inline double findAppSpacing( const double& max, const double& min )
{
  double diff   = max-min;
  double scale  = pow( 10.0, floor(log10(diff)) );
  double factor = diff/scale;

  if( 0.0<=factor && factor< 2.0 ){
    diff =  2.0/10*scale;
  }
  else if( 2.0<=factor && factor< 5.0 ){
    diff =  5.0/10*scale;
  }
  else if( 5.0<=factor && factor<10.0 ){
    diff = 10.0/10*scale;
  }
  else{
    diff = scale;
  }

  return diff;
}

#endif //  __QTMISC_H_INCLUDED

