/*
 Copyright (c) 2014 Shinji Tsuneyuki
 This file is distributed under the terms of the GNU General Public License version 3.
 */

/*!
 \file qtsymmetry.cc
 \brief iq̑Ώ̐GUI\̃NX
*/

#include "dtmodel.h"
#include "qtsymmetry.h"

QTSymmetry::QTSymmetry( DTModel& _model, const int id ) : MyQTab(id), model(_model)
{
  QVBoxLayout* layout = new QVBoxLayout(this);
  layout->setSizeConstraint( QLayout::SetFixedSize );

  // space group
  {
    QGroupBox* group = new QGroupBox("space group");
    QHBoxLayout* box = new QHBoxLayout;

    box->addWidget(new QLabel("symmetry:"));
    {
      MyQComboBox* widget = new MyQComboBox
	( model.lattice.symmetry.idbsymname, model.lattice.symmetry.vdbsymname,
	  this, SLOT(edit(const MyEvent&)), ID_SYMMETRY );
      box->addWidget(widget);
      vwidget.push_back(widget);
    }

    group->setLayout(box);
    layout->addWidget(group);
  }
  {
    QGroupBox* group = new QGroupBox("transformations of this space group");
    QVBoxLayout* box = new QVBoxLayout;

    {
      QPlainTextEdit* widget = new QPlainTextEdit("",this);
      widget->setFixedHeight(300);
      widget->setReadOnly(true);
      box->addWidget(widget);
      plain_symmetry = widget;
    }

    {
      QLabel* widget = new QLabel("");
      box->addWidget(widget);
      lavel_has_inversion = widget;
    }

    group->setLayout(box);
    layout->addWidget(group);
  }

  setLayout(layout);

  update();
}


void QTSymmetry::edit( const MyEvent& ev )
{
  switch(ev.id){
  case ID_SYMMETRY : {
  } break;
  }

  emit changed(MyEvent(id));
}

void QTSymmetry::update( void )
{
  plain_symmetry->clear();

  for( int n=0; n<(int)model.lattice.symmetry.vmatrix.size(); n++ ){
    plain_symmetry->appendPlainText
      ( model.lattice.symmetry.vmatrix[n].name() );
  }

  /*
  if( model.lattice.symmetry.has_inversion ){
    lavel_has_inversion->setText("(-x,-y,-z) is omitted");
  }
  else{
    lavel_has_inversion->setText("");
  }
  */

  MyQTab::update();
}
