/*
 Copyright (c) 2014 Shinji Tsuneyuki
 This file is distributed under the terms of the GNU General Public License version 3.
 */

#ifndef __QTTABLE_H_INCLUDED
#define __QTTABLE_H_INCLUDED

#include <QtGui/QtGui>
#include <QtGui/QTableWidget>

#include "qtwidgets.h"


class latticeEvent;

class QTTableAtom : public QWidget
{
  Q_OBJECT

  enum { ID_REMOVE, ID_ADD, ID_CLOSE };
  QTableWidget* table;

public:
  TableAtom( void );

signals:
  void valueChanged( const latticeEvent& ev );
private slots:
  void change( const MyEvent& ev );

private slots:
  void atomSelected( const latticeEvent& ev );
  void update( void );
  void itemSelected( void );
  void itemEdited( QTableWidgetItem* );
};

#endif // __QTTABLE_H_INCLUDED
