/*
 Copyright (c) 2014 Shinji Tsuneyuki
 This file is distributed under the terms of the GNU General Public License version 3.
 */

/*!
 \file qttapp.h
 \brief TAPP̐ݒGUI\̃NX
*/

#ifndef __QTTAPP_H_INCLUDED
#define __QTTAPP_H_INCLUDED

#include "qtwidgets.h"

class DTModel;

class QTTappOption : public MyQTab
{
  Q_OBJECT

private:
  DTModel& model;

  enum { ID_OPTION };

public:
  QTTappOption( DTModel& _model, const int id );
signals:
  void changed(const MyEvent&);
public slots:
  void updateExpert( const bool expert );
private slots:
  void edit( const MyEvent& ev );
};

class QTTappLSDA : public MyQTab
{
  Q_OBJECT

private:
  DTModel& model;

  enum { ID_XCTYPE, ID_NSPIN, ID_SPINMODE,
	 ID_IPMODE, ID_NFIXED };

public:
  QTTappLSDA( DTModel& _model, const int id );
signals:
  void changed(const MyEvent&);
public slots:
  void updateExpert( const bool expert );
private slots:
  void edit( const MyEvent& ev );
};

class QTTappCutoff : public MyQTab
{
  Q_OBJECT

private:
  DTModel& model;

  enum { ID_QF, ID_RF, ID_QM, ID_QC, ID_BETA };

public:
  QTTappCutoff( DTModel& _model, const int id );
signals:
  void changed(const MyEvent&);
public slots:
  void updateExpert( const bool expert );
private slots:
  void edit( const MyEvent& ev );
};

class QTTappMesh : public MyQTab
{
  Q_OBJECT

private:
  DTModel& model;

  enum { ID_ND, ID_NK, ID_NW, ID_NB, ID_ZNEXT, ID_DSPIN };

public:
  QTTappMesh( DTModel& _model, const int id );
signals:
  void changed(const MyEvent&);
public slots:
  void updateExpert( const bool expert );
private slots:
  void edit( const MyEvent& ev );
};

class QTTappEwald : public MyQTab
{
  Q_OBJECT

private:
  DTModel& model;

  enum { ID_QGB, ID_QRB, ID_G };

public:
  QTTappEwald( DTModel& _model, const int id );
signals:
  void changed(const MyEvent&);
public slots:
  void updateExpert( const bool expert );
private slots:
  void edit( const MyEvent& ev );
};

class QTTappSampling : public MyQTab
{
  Q_OBJECT

private:
  DTModel& model;

  enum { ID_OUTLINE, ID_DETAIL_NK, ID_DETAIL_INDEX, ID_DETAIL_MMM,
	 ID_DETAIL_ADD, ID_DETAIL_DEL, ID_DETAIL_EX };

  MyQLabel*   label_size;
  MyQSpinBox* spinbox_index;
  QGroupBox*  group_sampling;

public:
  QTTappSampling( DTModel& _model, const int id );
signals:
  void changed(const MyEvent&);
public slots:
  void updateExpert( const bool expert );
private slots:
  void edit( const MyEvent& ev );
};


class QTTappFile : public MyQTab
{
  Q_OBJECT

private:
  DTModel& model;

  enum { ID_FILE };

public:
  QTTappFile( DTModel& _model, const int id );
signals:
  void changed(const MyEvent&);
public slots:
  void updateExpert( const bool expert );
private slots:
  void edit( const MyEvent& ev );
};


class QTTappMass : public MyQTab
{
  Q_OBJECT

private:
  DTModel& model;

  enum { ID_INDEX, ID_TENSOR, ID_ADD, ID_DEL };

  MyQLabel*   label_size;
  MyQSpinBox* spinbox_index;
  QGroupBox*  group_mass;

public:
  QTTappMass( DTModel& _model, const int id );
signals:
  void changed(const MyEvent&);
public slots:
  void updateExpert( const bool expert );
private slots:
  void edit( const MyEvent& ev );
};


class QTTappParameter : public MyQTab
{
  Q_OBJECT

private:
  DTModel& model;

  enum { ID_EPS, ID_EEPSA, ID_FEPS, ID_EKBT,
	 ID_DECR, ID_OKATOM, ID_UPTIME, ID_MISC };

public:
  QTTappParameter( DTModel& _model, const int id );
signals:
  void changed(const MyEvent&);
public slots:
  void updateExpert( const bool expert );
private slots:
  void edit( const MyEvent& ev );
};


class QTTappPolar : public MyQTab
{
  Q_OBJECT

private:
  DTModel& model;

  enum { ID_KD_INDEX, ID_KD, ID_KD_ADD, ID_KD_DEL,
	 ID_IT_INDEX, ID_IT, ID_IT_ADD, ID_IT_DEL };

  MyQLabel*   label_kd_size;
  MyQLabel*   label_it_size;
  MyQSpinBox* spinbox_index_kd;
  MyQSpinBox* spinbox_index_it;
  QGroupBox*  group_polar_kd;
  QGroupBox*  group_polar_it;

public:
  QTTappPolar( DTModel& _model, const int id );
signals:
  void changed(const MyEvent&);
public slots:
  void updateExpert( const bool expert );
private slots:
  void edit( const MyEvent& ev );
};


class QTTappVBPEF : public MyQTab
{
  Q_OBJECT

private:
  DTModel& model;

  enum { ID_KPOINT_INDEX, ID_KPOINT, ID_KPOINT_ADD, ID_KPOINT_DEL, ID_VBPEF };

  MyQLabel*   label_size;
  MyQSpinBox* spinbox_index;
  QGroupBox*  group_kpoint;

public:
  QTTappVBPEF( DTModel& _model, const int id );
signals:
  void changed(const MyEvent&);
public slots:
  void updateExpert( const bool expert );
private slots:
  void edit( const MyEvent& ev );
};

class QTTappVBWFN : public MyQTab
{
  Q_OBJECT

private:
  DTModel& model;

  enum { ID_VBWFN, ID_NB_INDEX, ID_NB, ID_NB_ADD, ID_NB_DEL };

  MyQLabel*   label_size;
  MyQSpinBox* spinbox_index;

public:
  QTTappVBWFN( DTModel& _model, const int id );
signals:
  void changed(const MyEvent&);
public slots:
  void updateExpert( const bool expert );
private slots:
  void edit( const MyEvent& ev );
};

class QTTappTCHRPOT : public MyQTab
{
  Q_OBJECT

private:
  DTModel& model;

  enum { ID_TCHRPOT };

public:
  QTTappTCHRPOT( DTModel& _model, const int id );
signals:
  void changed(const MyEvent&);
public slots:
  void updateExpert( const bool expert );
private slots:
  void edit( const MyEvent& ev );
};


class QTTapp : public QWidget
{
  Q_OBJECT

private:
  DTModel& model;
  const int id;

  enum { ID_OPTION, ID_LSDA, ID_CUTOFF,
	 ID_MESH, ID_EWALD, ID_SAMPLING, ID_FILE, ID_MASS,
	 ID_PARAMETER, ID_POLAR, ID_VBPEF, ID_VBWFN, ID_TCHRPOT,
	 ID_CLOSE, ID_UNDO, ID_EXPERT };

  vector<MyQTab*> vwidget;
  bool expert;

public:
  QTTapp( DTModel& _model, const int id );
signals:
  void changed( void );
public slots:
  void update( void );
private slots:
  void edit( const MyEvent& ev );
};

#endif // __QTTAPP_H_INCLUDED
