/*
 Copyright (c) 2014 Shinji Tsuneyuki
 This file is distributed under the terms of the GNU General Public License version 3.
 */

/*!
 \file qttcpp.cc
 \brief TC++̐ݒGUI\̃NXij
*/

#include "dtmodel.h"
#include "qttcpp.h"

QTTCPP::QTTCPP( DTModel& _model, const int _id ) :  model(_model), id(_id)
{
  QVBoxLayout* layout = new QVBoxLayout(this);
  layout->setSizeConstraint( QLayout::SetFixedSize );

  setFixedSize(380,600);
  setWindowTitle("TCPP parameter configuration");

  {
    QTabWidget* group = new QTabWidget;
    {
      QTTCPPGroup* widget = new QTTCPPGroup( model, ID_GROUP );
      group->addTab(widget, "Group");
      vwidget.push_back(widget);
      connect(widget, SIGNAL(changed(const MyEvent&)), this, SLOT(edit(const MyEvent&)) );
    }

    layout->addWidget(group);
  }

  // add group for new group here.

  QHBoxLayout* box = new QHBoxLayout;
  {
    MyQPushButton* widget = new MyQPushButton
      ( "close", this, SLOT(edit(const MyEvent&)), ID_CLOSE );
    box->addWidget( widget );
  }
  {
    MyQPushButton* widget = new MyQPushButton
      ( "undo", this, SLOT(edit(const MyEvent&)), ID_UNDO );
    box->addWidget( widget );
  }
  {
    expert = false;
    MyQToggleButton* widget = new MyQToggleButton
      ( "expert", expert, this, SLOT(edit(const MyEvent&)), ID_EXPERT );
    box->addWidget( widget );
  }

  layout->addLayout(box);

  setLayout(layout);
}

void QTTCPP::edit( const MyEvent& ev )
{
  switch(ev.id){
  case ID_GROUP : {
    emit changed();
  } break;
  // add operations for new group here.

  case ID_CLOSE : {
    hide();
  } break;
  case ID_UNDO : {
    model.undo();
  } break;
  case ID_EXPERT : {
    update();
  } break;
  default: break;
  }
}

void QTTCPP::update( void )
{
  for( int i=0; i<(int)vwidget.size(); i++ ){
    vwidget[i]->updateExpert(expert);
  }
}



//-----------------------------------------------------------
QTTCPPGroup::QTTCPPGroup( DTModel& _model, const int id ) : MyQTab(id), model(_model)
{
  QVBoxLayout* layout = new QVBoxLayout(this);
  layout->setSizeConstraint( QLayout::SetFixedSize );


  // value
  {
    MyQGroupBox* group = new MyQGroupBox("value");
    QHBoxLayout* box = new QHBoxLayout;

    {
      box->addWidget(new QLabel("value:") );
      {
	MyQSpinBox* widget = new MyQSpinBox
	  ( model.tcpp.group.value,
	    DTTCPP::Group::value_min, DTTCPP::Group::value_max,
	    this, SLOT(edit(const MyEvent&)), ID_VALUE );
	box->addWidget(widget);

	vwidget.push_back(widget);
      }
      box->addWidget(new QLabel("unit") );
    }

    group->setLayout(box);
    layout->addWidget(group);

    group->setExpert(false);
    // false means this group widgets are for standard users.
    // true  means this group widgets are for expert users.
    vgroup.push_back(group);
  }

  setLayout(layout);
  updateExpert(false);
}

void QTTCPPGroup::edit( const MyEvent& ev )
{
  switch(ev.id){
  case ID_VALUE : {
    // do some extra manupulations for data models
    // such as, model.tcpp.group.other_value++;
  } break;
  default : {
  } break;
  }

  emit changed(MyEvent(id));
}

void QTTCPPGroup::updateExpert( const bool expert )
{
  // do some manupulations for qt control widgets
  MyQTab::updateExpert(expert);
}


