/*
 Copyright (c) 2014 Shinji Tsuneyuki
 This file is distributed under the terms of the GNU General Public License version 3.
 */

/*!
 \file qttcpp.h
 \brief TC++̐ݒGUI\̃NXij
*/

#ifndef __QTTCPP_H_INCLUDED
#define __QTTCPP_H_INCLUDED

#include "qtwidgets.h"

class DTModel;

class QTTCPP : public QWidget
{
  Q_OBJECT

private:
  DTModel& model;
  const int id;

  enum { ID_GROUP, // add new group id here
	 ID_CLOSE, ID_UNDO, ID_EXPERT };

  vector<MyQTab*> vwidget;
  bool expert;

public:
  QTTCPP( DTModel& _model, const int id );
signals:
  void changed( void );
public slots:
  void update( void );
private slots:
  void edit( const MyEvent& ev );
};

class QTTCPPGroup : public MyQTab
{
  Q_OBJECT

private:
  DTModel& model;

  enum { ID_VALUE };  // add new value id here

public:
  QTTCPPGroup( DTModel& _model, const int id );
signals:
  void changed(const MyEvent&);
public slots:
  void updateExpert( const bool expert );
private slots:
  void edit( const MyEvent& ev );
};


#endif // __QTTCPP_H_INCLUDED
