/*
 Copyright (c) 2014 Shinji Tsuneyuki
 This file is distributed under the terms of the GNU General Public License version 3.
 */

/*!
 \file qtwidgets.h
 \brief t@\GUIiNX
*/

#ifndef __QTWIDGETS_H_INCLUDED
#define __QTWIDGETS_H_INCLUDED

#include <QtCore/QString>
#include <QtGui/QtGui>
#include <QtGui/QSlider>
#include <QtGui/QGridLayout>

#include <vector>
using namespace std;

class MyEvent
{
public:
  int id;
  MyEvent( int _id ) : id(_id) {}
};

class MyQAction : public QAction
{
  Q_OBJECT

  const int id;

public:
  MyQAction( const char* text,
	     QObject* target, const char* slot, const int _id );

private slots:
  void convert( void );

signals:
  void valueChanged(const MyEvent&);
};

class MyQWidget
{
public:
  MyQWidget( void ){}
  virtual ~MyQWidget( void ){}
  virtual void update( void ) = 0;
};

class MyQLabel : public QLabel, public MyQWidget
{
  Q_OBJECT

public:
  MyQLabel( const char* text );
  virtual void update( void );
};

class MyQPushButton : public QPushButton, public MyQWidget
{
  Q_OBJECT

  const int id;

public:
  MyQPushButton( const char* text,
	       QWidget* target, const char* slot, const int _id );
  virtual void update( void );

private slots:
  void convert( void );

signals:
  void valueChanged(const MyEvent&);
};

class MyQToggleButton : public QPushButton, public MyQWidget
{
  Q_OBJECT

  bool& value;
  const int id;

public:
  MyQToggleButton( const char* text, bool& _value,
	       QWidget* target, const char* slot, const int _id );
  virtual void update( void );

private slots:
  void convert( bool checked );

signals:
  void valueChanged(const MyEvent&);
};

class MyQCheckBox : public QCheckBox, public MyQWidget
{
  Q_OBJECT

  bool& value;
  const int id;

public:
  MyQCheckBox( const char* text, bool& _value, 
	       QWidget* target, const char* slot, const int _id );
  virtual void update( void );

private slots:
  void convert( int i );

signals:
  void valueChanged(const MyEvent&);
};

class MyQTriCheckBox : public QCheckBox, public MyQWidget
{
  Q_OBJECT

  int& value;
  const int id;

public:
  MyQTriCheckBox( const char* text, int& _value, 
	       QWidget* target, const char* slot, const int _id );
  virtual void update( void );

private slots:
  void convert( int i );

signals:
  void valueChanged(const MyEvent&);
};


class MyQSpinBox : public QSpinBox, public MyQWidget
{
  Q_OBJECT

  int& value;
  const int min, max;
  const int id;

public:
  MyQSpinBox( int& _value, const int _min, const int _max,
	     QWidget* target, const char* slot, const int _id );
  virtual void update( void );
  void setRange( const int min, const int max );

private slots:
  void convert( int i );

signals:
  void valueChanged(const MyEvent&);
};

class MyQDoubleSpinBox : public QDoubleSpinBox, public MyQWidget
{
  Q_OBJECT

  double& value;
  const double min, max;
  const int id;

public:
  MyQDoubleSpinBox( double& _value, const double _min, const double _max,
	     QWidget* target, const char* slot, const int _id );
  virtual void update( void );
  void setRange( const int min, const int max );

private slots:
  void convert( double d );

signals:
  void valueChanged(const MyEvent&);
};

class MyQSlider : public QSlider, public MyQWidget
{
  Q_OBJECT

  double& value;
  double min, max;
  const int id;
  bool logscale;

public:
  MyQSlider( double& _value, const double _min, const double _max,
	     QWidget* target, const char* slot, const int _id );
  virtual void update( void );
  void setRange( const double min, const double max );

private slots:
  void convert( int i );

signals:
  void valueChanged(const MyEvent&);
};

class MyQRadioButton : public QRadioButton, public MyQWidget
{
  Q_OBJECT

  int  idummy;
  int& target_ivalue;
  int  this_ivalue;
  QString sdummy;
  QString& target_svalue;
  const QString this_svalue;
  const int id;

public:
  MyQRadioButton( const char* name,
		  int& _target_ivalue, const int _this_ivalue,
		  QWidget* target, const char* slot, const int _id );
  MyQRadioButton( const char* name,
		  QString& _target_svalue,
		  QWidget* target, const char* slot, const int _id );
  virtual void update( void );

private slots:
  void convert( void );

signals:
  void valueChanged(const MyEvent&);
};

class MyQComboBox : public QComboBox, public MyQWidget
{
  Q_OBJECT

  int& value;
  const vector<QString>& vname;
  const int id;

public:
  MyQComboBox( int& _value, const vector<QString>& _vname,
	       QWidget* target, const char* slot, const int _id );
  virtual void update( void );

private slots:
  void convert( const QString& str );

signals:
  void valueChanged(const MyEvent&);
};


class MyQLineEdit : public QLineEdit, public MyQWidget
{
  Q_OBJECT

  enum { INTEGER, DOUBLE_F, DOUBLE_E, STRING } type;
  
  int     idummy;
  int&    ivalue;
  int     imin, imax;

  double  ddummy;
  double& dvalue;
  double  dmin, dmax;

  QString  sdummy;
  QString& svalue;
  char     format[12];

  const int id;

  QString temp_str;
  bool temp_str_changed;

public:
  MyQLineEdit( int&    _value, const int    _min, const int    _max,
	       QWidget* target, const char* slot, const int _id );
  MyQLineEdit( double& _value, const double _min, const double _max,
	       QWidget* target, const char* slot, const int _id );
  MyQLineEdit( QString& _value,
	       QWidget* target, const char* slot, const int _id );
  virtual void update( void );
  void setRange( const int    min, const int    max );
  void setRange( const double min, const double max );
  void setFormat( const char* format );
private slots:
  void convert( const QString& str );
  void convert( void );

signals:
  void valueChanged(const MyEvent&);
};


class MyQGroupBox : public QGroupBox, public MyQWidget
{
  Q_OBJECT

  bool* value_ptr;
  int   id;
  bool  expert;

public:
  MyQGroupBox( const char* text );
  MyQGroupBox( const char* text, bool& value );
  MyQGroupBox( const char* text, bool& value,
	       QWidget* target, const char* slot, const int id );

  virtual void update( const bool expert );
  virtual void update( void );
  void setExpert( const bool expert );
  void setCheckable( bool& value);
  void setCheckable
    ( bool& value, QWidget* target, const char* slot, const int id );

private slots:
  void convert( bool i );

signals:
  void valueChanged(const MyEvent&);
};

class MyQTab : public QWidget
{
  Q_OBJECT

protected:
  const int id;
public:
  vector<MyQGroupBox*>  vgroup;
  vector<MyQWidget*>   vwidget;

public:
  MyQTab( const int _id ) : id(_id) {}
signals:
  void changed(const MyEvent&);

public:
  virtual void updateExpert( const bool expert );
  virtual void update( void );
};

class MyQSpinBoxGroup : public MyQGroupBox
{
  Q_OBJECT

  int min, max;
  QWidget* target;
  const char* slot;
  int id;

  QHBoxLayout* box;
  MyQSpinBox* spinbox;
  vector<MyQSpinBox*> vspinbox;
  QLabel*     label_range;
public:
  MyQSpinBoxGroup( const char* text,
		   const char* name, int& value, const int min, const int max,
		   QWidget* target, const char* slot, const int id );
  MyQSpinBoxGroup( const char* text, const char* name,
		   const int min, const int max,
		   QWidget* target, const char* slot, const int id );
  void setCheckable( bool& checkable );
  void addSpinBox( int& value );

  virtual void update( void );
  void setRange( const int min, const int max );

signals:
  void valueChanged(const MyEvent&);
};

class MyQDoubleSpinBoxGroup : public MyQGroupBox
{
  Q_OBJECT

  double min, max;
  QWidget* target;
  const char* slot;
  int id;

  QHBoxLayout* box;
  MyQDoubleSpinBox* spinbox;
  vector<MyQDoubleSpinBox*> vspinbox;
  QLabel* label_range;


public:
  MyQDoubleSpinBoxGroup( const char* text, const char* name,
			 double& value, const double min, const double max,
			 QWidget* target, const char* slot, const int id );
  MyQDoubleSpinBoxGroup( const char* text, const char* name,
			 const double min, const double max,
			 QWidget* target, const char* slot, const int id );
  void setCheckable( bool& checkable );
  void addSpinBox( double& value );

  virtual void update( void );

signals:
  void valueChanged(const MyEvent&);
};

class MyQEditSliderGroup : public MyQGroupBox
{
  Q_OBJECT

  QWidget* target;
  const char* slot;
  int id;

  MyQLineEdit* lineedit;
  MyQSlider*   slider;


public:
  MyQEditSliderGroup( const char* text, const char* name, const char* unit,
	      const char* low, const char* high,
	      double& value, const double min, const double max,
	      QWidget* target, const char* slot, const int id );
  virtual void update( void );
  void setCheckable( bool& checkable );
  void setRange( const double min, const double max );
  void setFormat( const char* format );

signals:
  void valueChanged(const MyEvent&);
};

class MyQEditSlider : public MyQEditSliderGroup
{
  Q_OBJECT

public:
  MyQEditSlider( const char* text, const char* name, const char* unit,
		 const char* low, const char* high,
		 double& value, const double min, const double max,
		 QWidget* target, const char* slot, const int id ) :
    MyQEditSliderGroup( text, name, unit,
			low, high,
			value, min, max,
			target, slot, id ){}
};


#endif // __QTWIDGETS_H_INCLUDED
