/*
 Copyright (c) 2014 Shinji Tsuneyuki
 This file is distributed under the terms of the GNU General Public License version 3.
 */

/*!
 \file qtxml.h
 \brief XMLf[^ǍNX
*/

#ifndef __QTXML_H_INCLUDED
#define __QTXML_H_INCLUDED

#include <QtCore/QString>
#include <QtXml/QDomDocument>
#include <QtCore/QFile>
#include <vector>
#include <stdarg.h>
using namespace std;

namespace XML
{
  bool load( QDomDocument& doc, const char* filename );
  bool save( const QDomDocument& doc, const char* filename );

  QDomNode getRoot( const QDomDocument& doc );

  QDomElement getFirstElementByTagName( const QDomNode& node, const char* tag );
  vector<QDomElement> getElementsByTagName( const QDomNode& node, const char* tag );

  QString getChildValue( const QDomNode& node );
  QString getAttribute( const QDomElement& elem, const char* attr );

  int sscanf( const QString& str, const char* const format, ... );
  int sscanf( const QString& str, const char* const format, QString* str2 );
}

#endif // __QTXML_H_INCLUDED
