/*
 Copyright (c) 2014 Shinji Tsuneyuki
 This file is distributed under the terms of the GNU General Public License version 3.
 */

/*!
 \file qtxpm.h
 \brief XPMACRf[^
*/

#ifndef QTXPM_H_INCLUDED
#define QTXPM_H_INCLUDED

namespace CELL_SHAPE {
  namespace CUBIC{
    const char* const xpm[] = {
      "16 16 3 1",
      "  c black",
      ". c #C0C0C0",
      "X c gray100",
      /* pixels */
      "XXXXX           ",
      "XXXX .XXXXXXXX  ",
      "XXX X.XXXXXXX X ",
      "XX XX.XXXXXX XX ",
      "X XXX.XXXXX XXX ",
      "           XXXX ",
      " XXXX.XXXX XXXX ",
      " XXXX.XXXX XXXX ",
      " XXXX.XXXX XXXX ",
      " XXXX.XXXX XXXX ",
      " XXXX..... .... ",
      " XXX.XXXXX XXX X",
      " XX.XXXXXX XX XX",
      " X.XXXXXXX X XXX",
      " .XXXXXXXX  XXXX",
      "           XXXXX"
    };
  }

  namespace TETRAGONAL_A {
    const char* const xpm[] = {
      "16 16 3 1",
      "  c black",
      ". c #C0C0C0",
      "X c gray100",
      "XXXXXXXXXXXXXXXX",
      "XXXXXXXXXXXXXXXX",
      "XXXXXXXXXXXXXXXX",
      "XXXX            ",
      "XXX .XXXXXXXXX  ",
      "XX X.XXXXXXXX X ",
      "X XX.XXXXXXX XX ",
      "            XXX ",
      " XXX.XXXXXX XXX ",
      " XXX.XXXXXX XXX ",
      " XXX.XXXXXX XXX ",
      " XXX....... ... ",
      " XX.XXXXXXX XX X",
      " X.XXXXXXXX X XX",
      " .XXXXXXXXX  XXX",
      "            XXXX"
    };
  }

  namespace TETRAGONAL_B {
    const char* const xpm[] = {
      "16 16 3 1",
      "  c black",
      ". c #C0C0C0",
      "X c gray100",
      "XXXXXXX         ",
      "XXXXXX .XXXXXX  ",
      "XXXXX X.XXXXX X ",
      "XXXX XX.XXXX XX ",
      "XXX XXX.XXX XXX ",
      "XX XXXX.XX XXXX ",
      "X XXXXX.X XXXXX ",
      "         XXXXXX ",
      " XXXXXX. ...... ",
      " XXXXX.X XXXXX X",
      " XXXX.XX XXXX XX",
      " XXX.XXX XXX XXX",
      " XX.XXXX XX XXXX",
      " X.XXXXX X XXXXX",
      " .XXXXXX  XXXXXX",
      "         XXXXXXX"
    };
  }
  namespace TETRAGONAL_C {
    const char* const xpm[] = {
      "16 16 3 1",
      "  c black",
      ". c #C0C0C0",
      "X c gray100",
      "XXXX         XXX",
      "XXX .XXXXXX  XXX",
      "XX X.XXXXX X XXX",
      "X XX.XXXX XX XXX",
      "         XXX XXX",
      " XXX.XXX XXX XXX",
      " XXX.XXX XXX XXX",
      " XXX.XXX XXX XXX",
      " XXX.XXX XXX XXX",
      " XXX.XXX XXX XXX",
      " XXX.XXX XXX XXX",
      " XXX.... ... XXX",
      " XX.XXXX XX XXXX",
      " X.XXXXX X XXXXX",
      " .XXXXXX  XXXXXX",
      "         XXXXXXX"
    };
  }
  namespace ORTHORHOMBIC {
    const char* const xpm[] = {
      "16 16 3 1",
	"  c black",
	". c #C0C0C0",
	"X c gray100",
	/* pixels */
	"XXX            X",
	"XX .XXXXXXXXX  X",
	"X X.XXXXXXXX X X",
	"            XX X",
	" XX.XXXXXXX XX X",
	" XX.XXXXXXX XX X",
	" XX.XXXXXXX XX X",
	" XX.XXXXXXX XX X",
	" XX.XXXXXXX XX X",
	" XX.XXXXXXX XX X",
	" XX.XXXXXXX XX X",
	" XX.XXXXXXX XX X",
	" XX........ .. X",
	" X.XXXXXXXX X XX",
	" .XXXXXXXXX  XXX",
	"            XXXX"
    };
  }
  namespace MONOCLINIC_A {
    const char* const xpm[] = {
      "16 16 3 1",
      "  c black",
      ". c #C0C0C0",
      "X c gray100",
      "XXXXX           ",
      "XXXX .XXXXXXXX  ",
      "XXX X.XXXXXXX X ",
      "XX XX.XXXXXX XX ",
      "X           XXX ",
      "X XXX.XXXXX XXX ",
      "X XX.XXXXXX XX X",
      "X XX.XXXXXX XX X",
      "X XX.XXXXXX XX X",
      "X XX.XXXXXX XX X",
      " XXX.XXXXX XXX X",
      " XXX...... ... X",
      " XX.XXXXXX XX XX",
      " X.XXXXXXX X XXX",
      " .XXXXXXXX  XXXX",
      "           XXXXX"
    };
  }
  namespace MONOCLINIC_B {
    const char* const xpm[] = {
      "16 16 3 1",
      "  c black",
      ". c #C0C0C0",
      "X c gray100",
      "XXXXXXXXXX      ",
      "XXXX      XXXX  ",
      "XXX .XXXXXXXX X ",
      "XX X.XXXXXXX XX ",
      "X XX.X      XXX ",
      "      XXXXX XXX ",
      " XXX.XXXXXX XXX ",
      " XXX.XXXXXX XXX ",
      " XXX.XXXXXX XXX ",
      " XXX.XXXXXX XXX ",
      " XXX.XXXXX. ... ",
      " XXX......X XX X",
      " XX.XXXXXXX X XX",
      " X.XXXXXXXX  XXX",
      " .XXXX      XXXX",
      "      XXXXXXXXXX"
    };
  }
  namespace MONOCLINIC_C {
    const char* const xpm[] = {
      "16 16 3 1",
      "  c black",
      ". c #C0C0C0",
      "X c gray100",
      "XXXXX           ",
      "XXX  .XXXXXXX   ",
      "X  XX.XXXXX  XX ",
      "           XXXX ",
      " XXXX.XXXX XXXX ",
      " XXXX.XXXX XXXX ",
      " XXXX.XXXX XXXX ",
      " XXXX.XXXX XXXX ",
      " XXXX.XXXX XXXX ",
      " XXXX.XXXX XXXX ",
      " XXXX.XXXX XXXX ",
      " XXXX.XXXX XXXX ",
      " XXXX..... .... ",
      " XX..XXXXX XX  X",
      " ..XXXXXXX   XXX",
      "           XXXXX"
    };
  }
  namespace TRIGONAL {
    const char* const xpm[] = {
      "16 16 3 1",
      "  c black",
      ". c #C0C0C0",
      "X c gray100",
      "XXXXXXXXXXX     ",
      "XXXXXX     XXX  ",
      "XXXXX .XXXXXX X ",
      "XXXX X.XXXXX XX ",
      "XXX XX.XXXX XXX ",
      "XX XXX     XXX X",
      "X     XXXX XXX X",
      "X XXX.XXXX XXX X",
      "X XXX.XXXX XXX X",
      "X XXX.XXXX ... X",
      "X XXX.... XXX XX",
      " XXX.XXXX XX XXX",
      " XX.XXXXX X XXXX",
      " X.XXXXXX  XXXXX",
      " .XXX     XXXXXX",
      "     XXXXXXXXXXX"
    };
  }
  namespace TRICLINIC {
    const char* const xpm[] = {
      "16 16 3 1",
      "  c black",
      ". c #C0C0C0",
      "X c gray100",
      "XXXXXXX         ",
      "XXXXXX .XXXXXX  ",
      "XXXXX X.XXXXX X ",
      "XXXX X.XXXXX X X",
      "XXX         XX X",
      "XXX XX.XXXX XX X",
      "XXX X.XXXXX X XX",
      "XX XX.XXXX XX XX",
      "XX XX.XXXX XX XX",
      "XX X.XXXXX X XXX",
      "X XX.XXXX XX XXX",
      "X XX..... .. XXX",
      "X X.XXXXX X XXXX",
      " X.XXXXX X XXXXX",
      " .XXXXXX  XXXXXX",
      "         XXXXXXX"
    };
  }
  namespace HEXAGONAL_A {
    const char* const xpm[] = {
      "16 16 3 1",
      "  c black",
      ". c #C0C0C0",
      "X c gray100",
      "XXXXX         XX",
      "XXXX X.XXXXX X X",
      "XXX XX.XXXX XX X",
      "XX XXXX.XX XXXX ",
      "X         XXXXX ",
      "X XXXXX.X XXXXX ",
      "X XXXXX.X XXXXX ",
      "X XXXXX.X XXXXX ",
      " XXXXX.X XXXXX X",
      " XXXXX.X XXXXX X",
      " XXXXX.X XXXXX X",
      " XXXXX.X XXXXX X",
      "         XXXX XX",
      "X XX.XXXX XX XXX",
      "X X.XXXXX X XXXX",
      "XX         XXXXX"
    };
  }
  namespace HEXAGONAL_B {
    const char* const xpm[] = {
      "16 16 3 1",
      "  c black",
      ". c #C0C0C0",
      "X c gray100",
      "XXXXXX       XXX",
      "XXXXX XXXXXX  XX",
      "XXXX .XXXXX X XX",
      "XXX .XXXXX XXX X",
      "XXX       XXXX X",
      "XX .XXXXX XXXXX ",
      "XX .XXXXX XXXX  ",
      "X XX.XXXXX XX  X",
      "X XX.XXXXX X X X",
      " XXXX.XXXXX X XX",
      " XXXX.XXXXX X XX",
      "X XXXX.... .. XX",
      "X XXX.XXXX X XXX",
      "XX X.XXXX X XXXX",
      "XX .XXXXX  XXXXX",
      "XXX       XXXXXX"
    };
  }
  namespace HEXAGONAL_C {
    const char* const xpm[] = {
      "16 16 3 1",
      "  c black",
      ". c #C0C0C0",
      "X c gray100",
      "XXXXX        XXX",
      "XXX  .XXXXXX. XX",
      "X  XX.XXXXXX.X X",
      " XXXX.XXXXXX.XX ",
      "  XXX.XXXXXX.   ",
      " X XX.XXXXX  XX ",
      " XX        X.XX ",
      " XX X.XXXX X.XX ",
      " XX X.XXXX X.XX ",
      " XX X..... ..XX ",
      " XX .XXXXX XX.X ",
      " .. XXXXXX XXX. ",
      " XX XXXXXX XXXX ",
      "X X XXXXXX XX  X",
      "XX  XXXXXX   XXX",
      "XXX        XXXXX"
    };
  }
}


namespace ATOM_ALIGNMENT {
  namespace ANY {
    const char* const xpm[] = {
      "16 16 3 1",
      "  c black",
      ". c #C0C0C0",
      "X c gray100",
      "XXXXX           ",
      "XXXX .XXXXXXXX  ",
      "XXX X.XXXXXXX X ",
      "XX XX.XXXXXX XX ",
      "X           XXX ",
      "X XXX.XXXXX XXX ",
      "X XXX.XXXXX XXX ",
      "X XXX.XXXXX XXX ",
      "X XXX.XXXXX XXX ",
      "X XXX.XXXXX XXX ",
      "X XXX...... ... ",
      "X XX.XXXXXX XX X",
      "X X.XXXXXXX X XX",
      "X .XXXXXXXX  XXX",
      "X           XXXX",
      "XXXXXXXXXXXXXXXX"
    };
  }
  namespace SIMPLE {
    const char* const xpm[] = {
      "16 16 4 1",
      "  c black",
      ". c red",
      "X c #C0C0C0",
      "o c gray100",
      "ooooo           ",
      "oooo Xoooooooo  ",
      "ooo oXooooooo o ",
      "oo ooXoooooo oo ",
      "o           ooo ",
      "o oooXooooo ooo ",
      "o oooXooooo ooo ",
      "o oooXooooo ooo ",
      "o oooXooooo ooo ",
      "o oooXooooo ooo ",
      "o oooXXXXXX XXX ",
      "o ooXoooooo oo o",
      "o oXooooooo o oo",
      "o.Xoooooooo  ooo",
      "...         oooo",
      "o.oooooooooooooo"
    };
  }
  namespace FACE_CENTERED {
    const char* const xpm[] = {
      "16 16 5 1",
      "  c black",
      ". c #800000",
      "X c red",
      "o c #C0C0C0",
      "O c gray100",
      "OOOOO           ",
      "OOOO oOOOOOOOO  ",
      "OOO OoOOOOOOO O ",
      "OO OOoOOOOOO OO ",
      "O           OOO ",
      "O OOOoOOOOO OOO ",
      "O O.OoOOOOO OOO ",
      "O ...oOOOOO OOO ",
      "O O.OoXOOOO OOO ",
      "O OOOXXXOOO OOO ",
      "O OOOoXoooo ooo ",
      "O OOoOOO.OO OO O",
      "O OoOOO...O O OO",
      "OXoOOOOO.OO  OOO",
      "XXX         OOOO",
      "OXOOOOOOOOOOOOOO"
    };
  }
  namespace BODY_CENTERED {
    const char* const xpm[] = {
      "16 16 5 1",
      "  c black",
      ". c #800000",
      "X c red",
      "o c #C0C0C0",
      "O c gray100",
      "OOOOO           ",
      "OOOO oOOOOOOOO  ",
      "OOO OoOOOOOOO O ",
      "OO OOoOOOOOO OO ",
      "O           OOO ",
      "O OOOoOOOOO OOO ",
      "O OOOoOO.OO OOO ",
      "O OOOoO...O OOO ",
      "O OOOoOO.OO OOO ",
      "O OOOoOOOOO OOO ",
      "O OOOoooooo ooo ",
      "O OOoOOOOOO OO O",
      "O OoOOOOOOO O OO",
      "OXoOOOOOOOO  OOO",
      "XXX         OOOO",
      "OXOOOOOOOOOOOOOO"      
    };
  }
  namespace BASE_CENTERED {
    const char* const xpm[] = {
      "16 16 5 1",
      "  c black",
      ". c #800000",
      "X c red",
      "o c #C0C0C0",
      "O c gray100",
      "OOOOO           ",
      "OOOO oOOOOOOOO  ",
      "OOO OoOOOOOOO O ",
      "OO OOoOOOOOO OO ",
      "O           OOO ",
      "O OOOoOOOOO OOO ",
      "O OOOoOOOOO OOO ",
      "O OOOoOOOOO OOO ",
      "O OOOoOOOOO OOO ",
      "O OOOoOOOOO OOO ",
      "O OOOoooooo ooo ",
      "O OOoOOO.OO OO O",
      "O OoOOO...O O OO",
      "OXoOOOOO.OO  OOO",
      "XXX         OOOO",
      "OXOOOOOOOOOOOOOO"
    };
  }
  namespace DIAMOND {
    const char* const xpm[] = {
      "16 16 7 1",
      "  c black",
      ". c #800000",
      "X c red",
      "o c #804000",
      "O c #FF8040",
      "+ c #C0C0C0",
      "@ c gray100",
      "@@@@@           ",
      "@@@@ +@@@@@@@@  ",
      "@@@ @+@@@@@@@ @ ",
      "@@ @@+O@@@@@ @@ ",
      "@    ooo    @@@ ",
      "@ @@@+O@@O@ @@@ ",
      "@ @.@+@@OOO @@@ ",
      "@ ...+@@@O@ @@@ ",
      "@ @.@+X@@@@o@@@ ",
      "@ @@@XXX@@OoO@@ ",
      "@ @@O+X++++o+++ ",
      "@ @OOO@@.@@ @@ @",
      "@ @+O@@...@ @ @@",
      "@X+@@@@@.@@  @@@",
      "XXX         @@@@",
      "@X@@@@@@@@@@@@@@"
    };
  }
}

#endif // QTXPM_H_INCLUDED
