/*
 Copyright (c) 2014 Shinji Tsuneyuki
 This file is distributed under the terms of the GNU General Public License version 3.
 */

/*!
  \file qtxtapp.cc
  \brief xTAPP̐ݒGUI\̃NX
*/

#include "dtmodel.h"
#include "qtxtapp.h"

//------------------------------------------------------------

QTXTappTappInput1::QTXTappTappInput1( DTModel& _model, const int id ) : MyQTab(id), model(_model)
{
  QHBoxLayout* hlayout = new QHBoxLayout(this);
  hlayout->setSizeConstraint( QLayout::SetFixedSize );

  {
    QVBoxLayout* vlayout = new QVBoxLayout;

    // number_spin, radio button
    {
      MyQGroupBox* widget = new MyQGroupBox("number_spin");

      QHBoxLayout* box = new QHBoxLayout;

      {
	MyQRadioButton* swidget = new MyQRadioButton
	  ( "LDA", model.xtapp.tappinput.number_spin, 1,
	    this, SLOT(edit(const MyEvent&)), ID_MISC );
	box->addWidget(swidget,Qt::AlignLeft);
	vwidget.push_back(swidget);
      }
      {
	MyQRadioButton* swidget = new MyQRadioButton
	  ( "LSDA", model.xtapp.tappinput.number_spin, 2,
	    this, SLOT(edit(const MyEvent&)), ID_MISC );
	box->addWidget(swidget,Qt::AlignLeft);
	vwidget.push_back(swidget);
      }
      widget->setLayout(box);
      widget->setFixedWidth(250);
      vlayout->addWidget(widget);

      widget->setToolTip(DTXTapp::TappInput::number_spin_bal);
      widget->setCheckable(DTXTapp::TappInput::number_spin_manual);
      widget->setExpert   (DTXTapp::TappInput::number_spin_expert);
      vgroup.push_back(widget);
    }

    // spin_mode, radio button
    {
      MyQGroupBox* widget = new MyQGroupBox("spin_mode");

      QHBoxLayout* box = new QHBoxLayout;

      {
	MyQRadioButton* swidget = new MyQRadioButton
	  ( "fix", model.xtapp.tappinput.spin_mode, 1,
	    this, SLOT(edit(const MyEvent&)), ID_MISC );
	box->addWidget(swidget,Qt::AlignLeft);
	vwidget.push_back(swidget);
      }
      {
	MyQRadioButton* swidget = new MyQRadioButton
	  ( "free", model.xtapp.tappinput.spin_mode, 2,
	    this, SLOT(edit(const MyEvent&)), ID_MISC );
	box->addWidget(swidget,Qt::AlignLeft);
	vwidget.push_back(swidget);
      }
      widget->setLayout(box);
      widget->setFixedWidth(250);
      vlayout->addWidget(widget);

      widget->setToolTip(DTXTapp::TappInput::spin_mode_bal);
      widget->setCheckable(DTXTapp::TappInput::spin_mode_manual);
      widget->setExpert   (DTXTapp::TappInput::spin_mode_expert);
      vgroup.push_back(widget);
    }

    // cutoff_local_potential, edit slider
    {
      MyQEditSliderGroup* widget = new MyQEditSliderGroup
	( "cutoff_local_potential", "cutoff:", "a.u.", "low", "high",
	  model.xtapp.tappinput.cutoff_local_potential,
	  DTXTapp::TappInput::cutoff_local_potential_min,
	  DTXTapp::TappInput::cutoff_local_potential_max,
	  this, SLOT(edit(const MyEvent&)), ID_MISC );
      widget->setFixedWidth(250);
      vlayout->addWidget(widget);
      vwidget.push_back(widget);

      widget->setToolTip(DTXTapp::TappInput::cutoff_local_potential_bal);
      widget->setCheckable(DTXTapp::TappInput::cutoff_local_potential_manual);
      widget->setExpert   (DTXTapp::TappInput::cutoff_local_potential_expert);
      vgroup.push_back(widget);
    }

    // cutoff_wave_function, edit slider
    {
      MyQEditSliderGroup* widget = new MyQEditSliderGroup
	( "cutoff_wave_function", "cutoff:", "a.u.", "low", "high",
	  model.xtapp.tappinput.cutoff_wave_function,
	  DTXTapp::TappInput::cutoff_wave_function_min,
	  DTXTapp::TappInput::cutoff_wave_function_max,
	  this, SLOT(edit(const MyEvent&)), ID_MISC );

      widget->setFixedWidth(250);
      vlayout->addWidget(widget);
      vwidget.push_back(widget);

      widget->setToolTip(DTXTapp::TappInput::cutoff_wave_function_bal);
      widget->setCheckable(DTXTapp::TappInput::cutoff_wave_function_manual);
      widget->setExpert   (DTXTapp::TappInput::cutoff_wave_function_expert);
      vgroup.push_back(widget);
    }

    // cutoff_uspp_q, edit slider
    {
      MyQEditSliderGroup* widget = new MyQEditSliderGroup
	( "cutoff_uspp_q", "cutoff:", "a.u.", "low", "high",
	  model.xtapp.tappinput.cutoff_uspp_q,
	  DTXTapp::TappInput::cutoff_uspp_q_min,
	  DTXTapp::TappInput::cutoff_uspp_q_max,
	  this, SLOT(edit(const MyEvent&)), ID_MISC );
      widget->setFixedWidth(250);
      vlayout->addWidget(widget);
      vwidget.push_back(widget);

      widget->setToolTip(DTXTapp::TappInput::cutoff_uspp_q_bal);
      widget->setCheckable(DTXTapp::TappInput::cutoff_uspp_q_manual);
      widget->setExpert   (DTXTapp::TappInput::cutoff_uspp_q_expert);
      vgroup.push_back(widget);
    }


    // number_band, spinbox
    {
      MyQSpinBoxGroup* widget = new MyQSpinBoxGroup
	( "number_band", "band:",
	  model.xtapp.tappinput.number_band,
	  DTXTapp::TappInput::number_band_min,
	  DTXTapp::TappInput::number_band_max,
	  this, SLOT(edit(const MyEvent&)), ID_MISC );
      widget->setFixedWidth(250);
      vlayout->addWidget(widget);
      vwidget.push_back(widget);

      widget->setToolTip(DTXTapp::TappInput::number_band_bal);
      widget->setCheckable(DTXTapp::TappInput::number_band_manual);
      widget->setExpert   (DTXTapp::TappInput::number_band_expert);
      vgroup.push_back(widget);
    }

    hlayout->addLayout(vlayout);
  }

  {
    QVBoxLayout* vlayout = new QVBoxLayout;

    // xtrap_beta, edit slider
    {
      MyQEditSliderGroup* widget = new MyQEditSliderGroup
	( "xtrap_beta", "beta:", "", "low", "high",
	  model.xtapp.tappinput.xtrap_beta,
	  DTXTapp::TappInput::xtrap_beta_min,
	  DTXTapp::TappInput::xtrap_beta_max,
	  this, SLOT(edit(const MyEvent&)), ID_MISC );
      widget->setFixedWidth(250);
      vlayout->addWidget(widget);
      vwidget.push_back(widget);

      widget->setToolTip(DTXTapp::TappInput::xtrap_beta_bal);
      widget->setCheckable(DTXTapp::TappInput::xtrap_beta_manual);
      widget->setExpert   (DTXTapp::TappInput::xtrap_beta_expert);
      vgroup.push_back(widget);
    }

    // cutoff_btp_a, edit slider
    {
      MyQEditSliderGroup* widget = new MyQEditSliderGroup
	( "cutoff_btp_a", "cutoff:", "a.u.", "low", "high",
	  model.xtapp.tappinput.cutoff_btp_a,
	  DTXTapp::TappInput::cutoff_btp_a_min,
	  DTXTapp::TappInput::cutoff_btp_a_max,
	  this, SLOT(edit(const MyEvent&)), ID_MISC );
      widget->setFixedWidth(250);
      vlayout->addWidget(widget);
      vwidget.push_back(widget);

      widget->setToolTip(DTXTapp::TappInput::cutoff_btp_a_bal);
      widget->setCheckable(DTXTapp::TappInput::cutoff_btp_a_manual);
      widget->setExpert   (DTXTapp::TappInput::cutoff_btp_a_expert);
      vgroup.push_back(widget);
    }

    // cutoff_btp_gc, edit slider
    {
      MyQEditSliderGroup* widget = new MyQEditSliderGroup
	( "cutoff_btp_gc", "cutoff:", "a.u.", "low", "high",
	  model.xtapp.tappinput.cutoff_btp_gc,
	  DTXTapp::TappInput::cutoff_btp_gc_min,
	  DTXTapp::TappInput::cutoff_btp_gc_max,
	  this, SLOT(edit(const MyEvent&)), ID_MISC );
      widget->setFixedWidth(250);
      vlayout->addWidget(widget);
      vwidget.push_back(widget);

      widget->setToolTip(DTXTapp::TappInput::cutoff_btp_gc_bal);
      widget->setCheckable(DTXTapp::TappInput::cutoff_btp_gc_manual);
      widget->setExpert   (DTXTapp::TappInput::cutoff_btp_gc_expert);
      vgroup.push_back(widget);
    }

    // cutoff_btp_sigma, edit slider
    {
      MyQEditSliderGroup* widget = new MyQEditSliderGroup
	( "cutoff_btp_sigma", "cutoff:", "a.u.", "low", "high",
	  model.xtapp.tappinput.cutoff_btp_sigma,
	  DTXTapp::TappInput::cutoff_btp_sigma_min,
	  DTXTapp::TappInput::cutoff_btp_sigma_max,
	  this, SLOT(edit(const MyEvent&)), ID_MISC );
      widget->setFixedWidth(250);
      vlayout->addWidget(widget);
      vwidget.push_back(widget);

      widget->setToolTip(DTXTapp::TappInput::cutoff_btp_sigma_bal);
      widget->setCheckable(DTXTapp::TappInput::cutoff_btp_sigma_manual);
      widget->setExpert   (DTXTapp::TappInput::cutoff_btp_sigma_expert);
      vgroup.push_back(widget);
    }

    // extra_charge, edit slider
    {
      MyQEditSliderGroup* widget = new MyQEditSliderGroup
	( "extra_charge", "charge:", "", "-", "+",
	  model.xtapp.tappinput.extra_charge,
	  DTXTapp::TappInput::extra_charge_min,
	  DTXTapp::TappInput::extra_charge_max,
	  this, SLOT(edit(const MyEvent&)), ID_MISC );
      widget->setFixedWidth(250);
      vlayout->addWidget(widget);
      vwidget.push_back(widget);

      widget->setToolTip(DTXTapp::TappInput::extra_charge_bal);
      widget->setCheckable(DTXTapp::TappInput::extra_charge_manual);
      widget->setExpert   (DTXTapp::TappInput::extra_charge_expert);
      vgroup.push_back(widget);
    }

    hlayout->addLayout(vlayout);
  }

  {
    QVBoxLayout* vlayout = new QVBoxLayout;

    // diff_spin, edit slider
    {
      MyQEditSliderGroup* widget = new MyQEditSliderGroup
	( "diff_spin", "diff:", "", "lower", "upper",
	  model.xtapp.tappinput.diff_spin,
	  DTXTapp::TappInput::diff_spin_min,
	  DTXTapp::TappInput::diff_spin_max,
	  this, SLOT(edit(const MyEvent&)), ID_MISC );
      widget->setFixedWidth(250);
      vlayout->addWidget(widget);
      vwidget.push_back(widget);

      widget->setToolTip(DTXTapp::TappInput::diff_spin_bal);
      widget->setCheckable(DTXTapp::TappInput::diff_spin_manual);
      widget->setExpert   (DTXTapp::TappInput::diff_spin_expert);
      vgroup.push_back(widget);
    }

    // elec_kbt, edit slider
    {
      MyQEditSliderGroup* widget = new MyQEditSliderGroup
	( "elec_kbt", "elec_kbt:", "", "low", "high",
	  model.xtapp.tappinput.elec_kbt,
	  DTXTapp::TappInput::elec_kbt_min,
	  DTXTapp::TappInput::elec_kbt_max,
	  this, SLOT(edit(const MyEvent&)), ID_MISC );
      widget->setFixedWidth(250);
      vlayout->addWidget(widget);
      vwidget.push_back(widget);

      widget->setToolTip(DTXTapp::TappInput::elec_kbt_bal);
      widget->setCheckable(DTXTapp::TappInput::elec_kbt_manual);
      widget->setExpert   (DTXTapp::TappInput::elec_kbt_expert);
      vgroup.push_back(widget);
    }

    // number_xtrap_stage, spinbox
    {
      MyQSpinBoxGroup* widget = new MyQSpinBoxGroup
	("number_xtrap_stage", "stage:",
	 model.xtapp.tappinput.number_xtrap_stage,
	 DTXTapp::TappInput::number_xtrap_stage_min,
	 DTXTapp::TappInput::number_xtrap_stage_max,
	 this, SLOT(edit(const MyEvent&)), ID_MISC );
      widget->setFixedWidth(250);
      vlayout->addWidget(widget);
      vwidget.push_back(widget);

      widget->setToolTip(DTXTapp::TappInput::number_xtrap_stage_bal);
      widget->setCheckable(DTXTapp::TappInput::number_xtrap_stage_manual);
      widget->setExpert   (DTXTapp::TappInput::number_xtrap_stage_expert);
      vgroup.push_back(widget);
    }

    // initial_wfn, radio button
    {
      MyQGroupBox* widget = new MyQGroupBox("initial_wfn");
      QHBoxLayout* box = new QHBoxLayout;

      {
	MyQRadioButton* swidget = new MyQRadioButton
	  ( "random", model.xtapp.tappinput.initial_wfn, 0,
	    this, SLOT(edit(const MyEvent&)), ID_MISC );
	box->addWidget(swidget,Qt::AlignLeft);
	vwidget.push_back(swidget);
      }
      {
	MyQRadioButton* swidget = new MyQRadioButton
	  ( "file", model.xtapp.tappinput.initial_wfn, 1,
	    this, SLOT(edit(const MyEvent&)), ID_MISC );
	box->addWidget(swidget,Qt::AlignLeft);
	vwidget.push_back(swidget);
      }
      widget->setLayout(box);
      widget->setFixedWidth(250);
      vlayout->addWidget(widget);

      widget->setToolTip(DTXTapp::TappInput::initial_wfn_bal);
      widget->setCheckable(DTXTapp::TappInput::initial_wfn_manual);
      widget->setExpert   (DTXTapp::TappInput::initial_wfn_expert);
      vgroup.push_back(widget);
    }


    // initial_lpt, radio button
    {
      MyQGroupBox* widget = new MyQGroupBox("initial_lpt");
      QHBoxLayout* box = new QHBoxLayout;

      {
	MyQRadioButton* swidget = new MyQRadioButton
	  ( "ion", model.xtapp.tappinput.initial_lpt, 0,
	    this, SLOT(edit(const MyEvent&)), ID_MISC );
	box->addWidget(swidget,Qt::AlignLeft);
	vwidget.push_back(swidget);
      }
      {
	MyQRadioButton* swidget = new MyQRadioButton
	  ( "file", model.xtapp.tappinput.initial_lpt, 1,
	    this, SLOT(edit(const MyEvent&)), ID_MISC );
	box->addWidget(swidget,Qt::AlignLeft);
	vwidget.push_back(swidget);
      }
      {
	MyQRadioButton* swidget = new MyQRadioButton
	  ( "atom", model.xtapp.tappinput.initial_lpt, 2,
	    this, SLOT(edit(const MyEvent&)), ID_MISC );
	box->addWidget(swidget,Qt::AlignLeft);
	vwidget.push_back(swidget);
      }
      widget->setLayout(box);
      widget->setFixedWidth(250);
      vlayout->addWidget(widget);

      widget->setToolTip(DTXTapp::TappInput::initial_lpt_bal);
      widget->setCheckable(DTXTapp::TappInput::initial_lpt_manual);
      widget->setExpert   (DTXTapp::TappInput::initial_lpt_expert);
      vgroup.push_back(widget);
    }

    hlayout->addLayout(vlayout);
  }

  setLayout(hlayout);
  updateExpert(false);
}


//------------------------------------------------------------

QTXTappTappInput2::QTXTappTappInput2( DTModel& _model, const int id ) : MyQTab(id), model(_model)
{
  QHBoxLayout* hlayout = new QHBoxLayout(this);
  hlayout->setSizeConstraint( QLayout::SetFixedSize );

  {
    QVBoxLayout* vlayout = new QVBoxLayout;

    // store_wfn, radio button
    {
      MyQGroupBox* widget = new MyQGroupBox("store_wfn");
      QHBoxLayout* box = new QHBoxLayout;

      {
	MyQRadioButton* swidget = new MyQRadioButton
	  ( "not store", model.xtapp.tappinput.store_wfn, 0,
	    this, SLOT(edit(const MyEvent&)), ID_MISC );
	box->addWidget(swidget,Qt::AlignLeft);
	vwidget.push_back(swidget);
      }
      {
	MyQRadioButton* swidget = new MyQRadioButton
	  ( "store", model.xtapp.tappinput.store_wfn, 1,
	    this, SLOT(edit(const MyEvent&)), ID_MISC );
	box->addWidget(swidget,Qt::AlignLeft);
	vwidget.push_back(swidget);
      }
      widget->setLayout(box);
      widget->setFixedWidth(250);
      vlayout->addWidget(widget);

      widget->setToolTip(DTXTapp::TappInput::store_wfn_bal);
      widget->setCheckable(DTXTapp::TappInput::store_wfn_manual);
      widget->setExpert   (DTXTapp::TappInput::store_wfn_expert);
      vgroup.push_back(widget);
    }

    // chain_calc, radio button
    {
      MyQGroupBox* widget = new MyQGroupBox("chain_calc");
      QGridLayout* grid = new QGridLayout;
      {
	MyQRadioButton* swidget = new MyQRadioButton
	  ( "first", model.xtapp.tappinput.chain_calc, 0,
	    this, SLOT(edit(const MyEvent&)), ID_MISC );
	grid->addWidget(swidget,0,0,Qt::AlignLeft);
	vwidget.push_back(swidget);
      }
      {
	MyQRadioButton* swidget = new MyQRadioButton
	  ( "reuse", model.xtapp.tappinput.chain_calc, 1,
	    this, SLOT(edit(const MyEvent&)), ID_MISC );
	grid->addWidget(swidget,0,1,Qt::AlignLeft);
	vwidget.push_back(swidget);
      }
      {
	MyQRadioButton* swidget = new MyQRadioButton
	  ( "reuse SCF", model.xtapp.tappinput.chain_calc, 2,
	    this, SLOT(edit(const MyEvent&)), ID_MISC );
	grid->addWidget(swidget,1,0,Qt::AlignLeft);
	vwidget.push_back(swidget);
      }
      {
	MyQRadioButton* swidget = new MyQRadioButton
	  ( "reuse OPT", model.xtapp.tappinput.chain_calc, 3,
	    this, SLOT(edit(const MyEvent&)), ID_MISC );
	grid->addWidget(swidget,1,1,Qt::AlignLeft);
	vwidget.push_back(swidget);
      }
      widget->setLayout(grid);
      widget->setFixedWidth(250);
      vlayout->addWidget(widget);

      widget->setToolTip(DTXTapp::TappInput::chain_calc_bal);
      widget->setCheckable(DTXTapp::TappInput::chain_calc_manual);
      widget->setExpert   (DTXTapp::TappInput::chain_calc_expert);
      vgroup.push_back(widget);
    }


    // scf_converge, edit slider
    {
      MyQEditSliderGroup* widget = new MyQEditSliderGroup
	( "scf_converge", "converge:", "a.u.", "high", "low",
	  model.xtapp.tappinput.scf_converge,
	  DTXTapp::TappInput::scf_converge_min,
	  DTXTapp::TappInput::scf_converge_max,
	  this, SLOT(edit(const MyEvent&)), ID_MISC );
      widget->setFixedWidth(250);
      vlayout->addWidget(widget);
      vwidget.push_back(widget);

      widget->setToolTip(DTXTapp::TappInput::scf_converge_bal);
      widget->setCheckable(DTXTapp::TappInput::scf_converge_manual);
      widget->setExpert   (DTXTapp::TappInput::scf_converge_expert);
      vgroup.push_back(widget);
    }

    // scf_converge_energy, edit slider
    {
      MyQEditSliderGroup* widget = new MyQEditSliderGroup
	( "scf_converge_energy", "converge:", "a.u.", "high", "low",
	  model.xtapp.tappinput.scf_converge_energy,
	  DTXTapp::TappInput::scf_converge_energy_min,
	  DTXTapp::TappInput::scf_converge_energy_max,
	  this, SLOT(edit(const MyEvent&)), ID_MISC );
      widget->setFixedWidth(250);
      vlayout->addWidget(widget);
      vwidget.push_back(widget);

      widget->setToolTip(DTXTapp::TappInput::scf_converge_energy_bal);
      widget->setCheckable(DTXTapp::TappInput::scf_converge_energy_manual);
      widget->setExpert   (DTXTapp::TappInput::scf_converge_energy_expert);
      vgroup.push_back(widget);
    }

    // scf_number_iter_1st, spinbox
    {
      MyQSpinBoxGroup* widget = new MyQSpinBoxGroup
	("scf_number_iter_1st", "iter:",
	 model.xtapp.tappinput.scf_number_iter_1st,
	 DTXTapp::TappInput::scf_number_iter_1st_min,
	 DTXTapp::TappInput::scf_number_iter_1st_max,
	 this, SLOT(edit(const MyEvent&)), ID_MISC );
      widget->setFixedWidth(250);
      vlayout->addWidget(widget);
      vwidget.push_back(widget);

      widget->setToolTip(DTXTapp::TappInput::scf_number_iter_1st_bal);
      widget->setCheckable(DTXTapp::TappInput::scf_number_iter_1st_manual);
      widget->setExpert   (DTXTapp::TappInput::scf_number_iter_1st_expert);
      vgroup.push_back(widget);
    }

    // scf_number_iter, spinbox
    {
      MyQSpinBoxGroup* widget = new MyQSpinBoxGroup
	("scf_number_iter", "iter:",
	 model.xtapp.tappinput.scf_number_iter,
	 DTXTapp::TappInput::scf_number_iter_min,
	 DTXTapp::TappInput::scf_number_iter_max,
	 this, SLOT(edit(const MyEvent&)), ID_MISC );
      widget->setFixedWidth(250);
      vlayout->addWidget(widget);
      vwidget.push_back(widget);

      widget->setToolTip(DTXTapp::TappInput::scf_number_iter_bal);
      widget->setCheckable(DTXTapp::TappInput::scf_number_iter_manual);
      widget->setExpert   (DTXTapp::TappInput::scf_number_iter_expert);
      vgroup.push_back(widget);
    }

    hlayout->addLayout(vlayout);
  }

  {
    QVBoxLayout* vlayout = new QVBoxLayout;

    // davidson_flag, spinbox
    {
      MyQSpinBoxGroup* widget = new MyQSpinBoxGroup
	("davidson_flag", "flag:",
	 model.xtapp.tappinput.davidson_flag,
	 DTXTapp::TappInput::davidson_flag_min,
	 DTXTapp::TappInput::davidson_flag_max,
	 this, SLOT(edit(const MyEvent&)), ID_MISC );
      widget->setFixedWidth(250);
      vlayout->addWidget(widget);
      vwidget.push_back(widget);

      widget->setToolTip(DTXTapp::TappInput::davidson_flag_bal);
      widget->setCheckable(DTXTapp::TappInput::davidson_flag_manual);
      widget->setExpert   (DTXTapp::TappInput::davidson_flag_expert);
      vgroup.push_back(widget);
    }

    // davidson_number_diag_1st, spinbox
    {
      MyQSpinBoxGroup* widget = new MyQSpinBoxGroup
	("davidson_number_diag_1st", "iter:",
	 model.xtapp.tappinput.davidson_number_diag_1st,
	 DTXTapp::TappInput::davidson_number_diag_1st_min,
	 DTXTapp::TappInput::davidson_number_diag_1st_max,
	 this, SLOT(edit(const MyEvent&)), ID_MISC );
      widget->setFixedWidth(250);
      vlayout->addWidget(widget);
      vwidget.push_back(widget);

      widget->setToolTip(DTXTapp::TappInput::davidson_number_diag_1st_bal);
      widget->setCheckable(DTXTapp::TappInput::davidson_number_diag_1st_manual);
      widget->setExpert   (DTXTapp::TappInput::davidson_number_diag_1st_expert);
      vgroup.push_back(widget);
    }

    // davidson_number_diag, spinbox
    {
      MyQSpinBoxGroup* widget = new MyQSpinBoxGroup
	("davidson_number_diag", "iter:",
	 model.xtapp.tappinput.davidson_number_diag,
	 DTXTapp::TappInput::davidson_number_diag_min,
	 DTXTapp::TappInput::davidson_number_diag_max,
	 this, SLOT(edit(const MyEvent&)), ID_MISC );
      widget->setFixedWidth(250);
      vlayout->addWidget(widget);
      vwidget.push_back(widget);

      widget->setToolTip(DTXTapp::TappInput::davidson_number_diag_bal);
      widget->setCheckable(DTXTapp::TappInput::davidson_number_diag_manual);
      widget->setExpert   (DTXTapp::TappInput::davidson_number_diag_expert);
      vgroup.push_back(widget);
    }

    // control_uptime, edit slider
    {
      MyQEditSliderGroup* widget = new MyQEditSliderGroup
	( "control_uptime", "uptime:", "", "low", "high",
	  model.xtapp.tappinput.control_uptime,
	  DTXTapp::TappInput::control_uptime_min,
	  DTXTapp::TappInput::control_uptime_max,
	  this, SLOT(edit(const MyEvent&)), ID_MISC );
      widget->setFixedWidth(250);
      vlayout->addWidget(widget);
      vwidget.push_back(widget);

      widget->setToolTip(DTXTapp::TappInput::control_uptime_bal);
      widget->setCheckable(DTXTapp::TappInput::control_uptime_manual);
      widget->setExpert   (DTXTapp::TappInput::control_uptime_expert);
      vgroup.push_back(widget);
    }

    // cutoff_bspl_fit, edit slider
    {
      MyQEditSliderGroup* widget = new MyQEditSliderGroup
	( "cutoff_bspl_fit", "cutoff:", "a.u.", "low", "high",
	  model.xtapp.tappinput.cutoff_bspl_fit,
	  DTXTapp::TappInput::cutoff_bspl_fit_min,
	  DTXTapp::TappInput::cutoff_bspl_fit_max,
	  this, SLOT(edit(const MyEvent&)), ID_MISC );
      widget->setFixedWidth(250);
      vlayout->addWidget(widget);
      vwidget.push_back(widget);

      widget->setToolTip(DTXTapp::TappInput::cutoff_bspl_fit_bal);
      widget->setCheckable(DTXTapp::TappInput::cutoff_bspl_fit_manual);
      widget->setExpert   (DTXTapp::TappInput::cutoff_bspl_fit_expert);
      vgroup.push_back(widget);
    }

    // control_q_han_win_fac, edit slider
    {
      MyQEditSliderGroup* widget = new MyQEditSliderGroup
	( "control_q_han_win_fac", "cutoff:", "a.u.", "low", "high",
	  model.xtapp.tappinput.control_q_han_win_fac,
	  DTXTapp::TappInput::control_q_han_win_fac_min,
	  DTXTapp::TappInput::control_q_han_win_fac_max,
	  this, SLOT(edit(const MyEvent&)), ID_MISC );
      widget->setFixedWidth(250);
      vlayout->addWidget(widget);
      vwidget.push_back(widget);

      widget->setToolTip(DTXTapp::TappInput::control_q_han_win_fac_bal);
      widget->setCheckable(DTXTapp::TappInput::control_q_han_win_fac_manual);
      widget->setExpert   (DTXTapp::TappInput::control_q_han_win_fac_expert);
      vgroup.push_back(widget);
    }

    hlayout->addLayout(vlayout);
  }

  {
    QVBoxLayout* vlayout = new QVBoxLayout;


    // control_nbsf, spinbox
    {
      MyQSpinBoxGroup* widget = new MyQSpinBoxGroup
	("control_nbsf", "mesh:",
	 model.xtapp.tappinput.control_nbsf,
	 DTXTapp::TappInput::control_nbsf_min,
	 DTXTapp::TappInput::control_nbsf_max,
	 this, SLOT(edit(const MyEvent&)), ID_MISC );
      widget->setFixedWidth(250);
      vlayout->addWidget(widget);
      vwidget.push_back(widget);

      widget->setToolTip(DTXTapp::TappInput::control_nbsf_bal);
      widget->setCheckable(DTXTapp::TappInput::control_nbsf_manual);
      widget->setExpert   (DTXTapp::TappInput::control_nbsf_expert);
      vgroup.push_back(widget);
    }

    // xc_type
    {
      MyQGroupBox* widget = new MyQGroupBox("xc_type");
      QHBoxLayout* box = new QHBoxLayout;

      box->addWidget(new QLabel("xc_type:"));
      {
	MyQComboBox* widget = new MyQComboBox
	  ( model.xtapp.tappinput.ixc_type, model.xtapp.tappinput.vxc_type,
	    this, SLOT(edit(const MyEvent&)), ID_MISC );
	box->addWidget(widget);
	vwidget.push_back(widget);
      }

      widget->setLayout(box);
      widget->setFixedWidth(250);
      vlayout->addWidget(widget);

      widget->setToolTip(DTXTapp::TappInput::xc_type_bal);
      widget->setCheckable(DTXTapp::TappInput::xc_type_manual);
      widget->setExpert   (DTXTapp::TappInput::xc_type_expert);
      vgroup.push_back(widget);
    }

    // cutoff_exch_att_rc, edit slider
    {
      MyQEditSliderGroup* widget = new MyQEditSliderGroup
	( "cutoff_exch_att_rc", "cutoff:", "", "low", "high",
	  model.xtapp.tappinput.cutoff_exch_att_rc,
	  DTXTapp::TappInput::cutoff_exch_att_rc_min,
	  DTXTapp::TappInput::cutoff_exch_att_rc_max,
	  this, SLOT(edit(const MyEvent&)), ID_MISC );
      widget->setFixedWidth(250);
      vlayout->addWidget(widget);
      vwidget.push_back(widget);

      widget->setToolTip(DTXTapp::TappInput::cutoff_exch_att_rc_bal);
      widget->setCheckable(DTXTapp::TappInput::cutoff_exch_att_rc_manual);
      widget->setExpert   (DTXTapp::TappInput::cutoff_exch_att_rc_expert);
      vgroup.push_back(widget);
    }

    // cutoff_exch_att_rd, edit slider
    {
      MyQEditSliderGroup* widget = new MyQEditSliderGroup
	( "cutoff_exch_att_rd", "cutoff:", "", "low", "high",
	  model.xtapp.tappinput.cutoff_exch_att_rd,
	  DTXTapp::TappInput::cutoff_exch_att_rd_min,
	  DTXTapp::TappInput::cutoff_exch_att_rd_max,
	  this, SLOT(edit(const MyEvent&)), ID_MISC );
      widget->setFixedWidth(250);
      vlayout->addWidget(widget);
      vwidget.push_back(widget);

      widget->setToolTip(DTXTapp::TappInput::cutoff_exch_att_rd_bal);
      widget->setCheckable(DTXTapp::TappInput::cutoff_exch_att_rd_manual);
      widget->setExpert   (DTXTapp::TappInput::cutoff_exch_att_rd_expert);
      vgroup.push_back(widget);
    }

    // scf_threshold_hybrid, edit slider
    {
      MyQEditSliderGroup* widget = new MyQEditSliderGroup
	( "scf_threshold_hybrid", "threshold:", "", "low", "high",
	  model.xtapp.tappinput.scf_threshold_hybrid,
	  DTXTapp::TappInput::scf_threshold_hybrid_min,
	  DTXTapp::TappInput::scf_threshold_hybrid_max,
	  this, SLOT(edit(const MyEvent&)), ID_MISC );
      widget->setFixedWidth(250);
      vlayout->addWidget(widget);
      vwidget.push_back(widget);

      widget->setToolTip(DTXTapp::TappInput::scf_threshold_hybrid_bal);
      widget->setCheckable(DTXTapp::TappInput::scf_threshold_hybrid_manual);
      widget->setExpert   (DTXTapp::TappInput::scf_threshold_hybrid_expert);
      vgroup.push_back(widget);
    }

    // compat_old_squ_norm, radio button
    {
      MyQGroupBox* widget = new MyQGroupBox("compat_old_squ_norm");
      QHBoxLayout* box = new QHBoxLayout;

      {
	MyQRadioButton* swidget = new MyQRadioButton
	  ( "disable", model.xtapp.tappinput.compat_old_squ_norm, 0,
	    this, SLOT(edit(const MyEvent&)), ID_MISC );
	box->addWidget(swidget,Qt::AlignLeft);
	vwidget.push_back(swidget);
      }
      {
	MyQRadioButton* swidget = new MyQRadioButton
	  ( "enable", model.xtapp.tappinput.compat_old_squ_norm, 1,
	    this, SLOT(edit(const MyEvent&)), ID_MISC );
	box->addWidget(swidget,Qt::AlignLeft);
	vwidget.push_back(swidget);
      }
      widget->setLayout(box);
      widget->setFixedWidth(250);
      vlayout->addWidget(widget);

      widget->setToolTip(DTXTapp::TappInput::compat_old_squ_norm_bal);
      widget->setCheckable(DTXTapp::TappInput::compat_old_squ_norm_manual);
      widget->setExpert   (DTXTapp::TappInput::compat_old_squ_norm_expert);
      vgroup.push_back(widget);
    }

    hlayout->addLayout(vlayout);
  }

  setLayout(hlayout);
  updateExpert(false);
}

void QTXTappTappInput1::edit( const MyEvent& ev )
{
  emit changed(MyEvent(id));
}

void QTXTappTappInput1::updateExpert( const bool expert )
{
  MyQTab::updateExpert(expert);
}

void QTXTappTappInput2::edit( const MyEvent& ev )
{
  emit changed(MyEvent(id));
}

void QTXTappTappInput2::updateExpert( const bool expert )
{
  MyQTab::updateExpert(expert);
}



QTXTappSmplKpt::QTXTappSmplKpt( DTModel& _model, const int id ) : MyQTab(id), model(_model)
{
  QHBoxLayout* hlayout = new QHBoxLayout(this);
  hlayout->setSizeConstraint( QLayout::SetFixedSize );

  {
    QVBoxLayout* layout = new QVBoxLayout;

    // dos_mode
    {
      MyQGroupBox* widget = new MyQGroupBox("dos_mode");
      QHBoxLayout* box = new QHBoxLayout;

      box->addWidget(new QLabel("mode:"));
      {
	MyQComboBox* widget = new MyQComboBox
	  ( model.xtapp.smplkpt.idos_mode, model.xtapp.smplkpt.vdos_mode,
	    this, SLOT(edit(const MyEvent&)), ID_MISC );
	box->addWidget(widget);
	vwidget.push_back(widget);
      }
      widget->setLayout(box);
      widget->setFixedWidth(250);
      layout->addWidget(widget);

      widget->setToolTip(DTXTapp::SmplKpt::dos_mode_bal);
      widget->setCheckable(DTXTapp::SmplKpt::dos_mode_manual);
      widget->setExpert   (DTXTapp::SmplKpt::dos_mode_expert);
      vgroup.push_back(widget);
    }

    // dos_band_lower, spinbox
    {
      MyQSpinBoxGroup* widget = new MyQSpinBoxGroup
	("dos_band_lower", "band:",
	 model.xtapp.smplkpt.dos_band_lower,
	 DTXTapp::SmplKpt::dos_band_lower_min,
	 DTXTapp::SmplKpt::dos_band_lower_max,
	 this, SLOT(edit(const MyEvent&)), ID_MISC );
      widget->setFixedWidth(250);
      vwidget.push_back(widget);
      layout->addWidget(widget);

      widget->setToolTip(DTXTapp::SmplKpt::dos_band_lower_bal);
      widget->setCheckable(DTXTapp::SmplKpt::dos_band_lower_manual);
      widget->setExpert   (DTXTapp::SmplKpt::dos_band_lower_expert);
      vgroup.push_back(widget);
    }

    // dos_band_upper, spinbox
    {
      MyQSpinBoxGroup* widget = new MyQSpinBoxGroup
	("dos_band_upper", "band:",
	 model.xtapp.smplkpt.dos_band_upper,
	 DTXTapp::SmplKpt::dos_band_upper_min,
	 DTXTapp::SmplKpt::dos_band_upper_max,
	 this, SLOT(edit(const MyEvent&)), ID_MISC );
      widget->setFixedWidth(250);
      vwidget.push_back(widget);
      layout->addWidget(widget);

      widget->setToolTip(DTXTapp::SmplKpt::dos_band_upper_bal);
      widget->setCheckable(DTXTapp::SmplKpt::dos_band_upper_manual);
      widget->setExpert   (DTXTapp::SmplKpt::dos_band_upper_expert);
      vgroup.push_back(widget);
    }

    // dos_mesh, spinbox
    {
      MyQSpinBoxGroup* widget = new MyQSpinBoxGroup
	("dos_mesh", "mesh:",
	 DTXTapp::SmplKpt::dos_mesh_min,
	 DTXTapp::SmplKpt::dos_mesh_max,
	 this, SLOT(edit(const MyEvent&)), ID_MISC );
      widget->addSpinBox( model.xtapp.smplkpt.dos_mesh[0] );
      widget->addSpinBox( model.xtapp.smplkpt.dos_mesh[1] );
      widget->addSpinBox( model.xtapp.smplkpt.dos_mesh[2] );
      widget->setFixedWidth(250);
      vwidget.push_back(widget);
      layout->addWidget(widget);

      widget->setToolTip(DTXTapp::SmplKpt::dos_mesh_bal);
      widget->setCheckable(DTXTapp::SmplKpt::dos_mesh_manual);
      widget->setExpert   (DTXTapp::SmplKpt::dos_mesh_expert);
      vgroup.push_back(widget);
    }

    // cutoff_dos_cos, edit slider
    {
      MyQEditSliderGroup* widget = new MyQEditSliderGroup
	( "cutoff_dos_cos", "cutoff:", "a.u.", "low", "high",
	  model.xtapp.smplkpt.cutoff_dos_cos,
	  DTXTapp::SmplKpt::cutoff_dos_cos_min,
	  DTXTapp::SmplKpt::cutoff_dos_cos_max,
	  this, SLOT(edit(const MyEvent&)), ID_MISC );
      widget->setFixedWidth(250);
      layout->addWidget(widget);
      vwidget.push_back(widget);

      widget->setToolTip(DTXTapp::SmplKpt::cutoff_dos_cos_bal);
      widget->setCheckable(DTXTapp::SmplKpt::cutoff_dos_cos_manual);
      widget->setExpert   (DTXTapp::SmplKpt::cutoff_dos_cos_expert);
      vgroup.push_back(widget);
    }


    // rmesh_number_shell, spinbox
    {
      MyQSpinBoxGroup* widget = new MyQSpinBoxGroup
	("rmesh_number_shell", "shell:",
	 model.xtapp.smplkpt.rmesh_number_shell,
	 DTXTapp::SmplKpt::rmesh_number_shell_min,
	 DTXTapp::SmplKpt::rmesh_number_shell_max,
	 this, SLOT(edit(const MyEvent&)), ID_MISC );
      widget->setFixedWidth(250);
      vwidget.push_back(widget);
      layout->addWidget(widget);

      widget->setToolTip(DTXTapp::SmplKpt::rmesh_number_shell_bal);
      widget->setCheckable(DTXTapp::SmplKpt::rmesh_number_shell_manual);
      widget->setExpert   (DTXTapp::SmplKpt::rmesh_number_shell_expert);
      vgroup.push_back(widget);

      spinbox_rmesh_number_shell = widget;
    }

    // rmesh_range, spinbox
    {
      MyQSpinBoxGroup* widget = new MyQSpinBoxGroup
	("rmesh_range", "mesh:",
	 DTXTapp::SmplKpt::rmesh_range_min,
	 DTXTapp::SmplKpt::rmesh_range_max,
	 this, SLOT(edit(const MyEvent&)), ID_MISC );
      widget->addSpinBox( model.xtapp.smplkpt.rmesh_range[0] );
      widget->addSpinBox( model.xtapp.smplkpt.rmesh_range[1] );
      widget->addSpinBox( model.xtapp.smplkpt.rmesh_range[2] );

      widget->setFixedWidth(250);
      layout->addWidget(widget);
      vwidget.push_back(widget);

      widget->setToolTip(DTXTapp::SmplKpt::rmesh_range_bal);
      widget->setCheckable(DTXTapp::SmplKpt::rmesh_range_manual);
      widget->setExpert   (DTXTapp::SmplKpt::rmesh_range_expert);
      vgroup.push_back(widget);

      spinbox_rmesh_range = widget;
    }

    hlayout->addLayout(layout);
  }


  {
    QVBoxLayout* layout = new QVBoxLayout;

    // mmm outline
    {
      MyQGroupBox* group = new MyQGroupBox("mmm outline");
      QVBoxLayout* grid = new QVBoxLayout;

      // mesh spinbox
      {
	MyQSpinBoxGroup* widget = new MyQSpinBoxGroup
	  ("mesh", "mesh:",
	   1, 100,
	   this, SLOT(edit(const MyEvent&)), ID_OUTLINE );
	for( int j=0; j<3; j++ ){
	  widget->addSpinBox( model.xtapp.smplkpt.mesh[j] );
	}
	//      widget->setFixedWidth(250);
	grid->addWidget(widget);
	vwidget.push_back(widget);

	widget->setExpert   (false);
      }
      // gamma checkbox
      {
	MyQCheckBox* widget = new MyQCheckBox
	  ( "gamma point in mesh", model.xtapp.smplkpt.gamma,
	    this, SLOT(edit(const MyEvent&)), ID_OUTLINE );
	grid->addWidget(widget);
	vwidget.push_back(widget);
      }

      group->setToolTip(DTXTapp::SmplKpt::mmm_outline_bal);
      group->setLayout(grid);
      layout->addWidget(group);

      group->setExpert(false);
      vgroup.push_back(group);
    }

    // mmm
    {
      MyQGroupBox* group = new MyQGroupBox("mmm detail");
      QVBoxLayout* grid = new QVBoxLayout;

      // bz_mesh, spinbox
      {
	MyQSpinBoxGroup* widget = new MyQSpinBoxGroup
	  ("bz_mesh","mesh:",
	   model.xtapp.smplkpt.bz_mesh,
	   0, 1000,
	   this, SLOT(edit(const MyEvent&)), ID_DETAIL_VALUE );
	//	widget->setFixedWidth(250);
	widget->setToolTip(DTXTapp::SmplKpt::bz_mesh_bal);
	widget->setCheckable(DTXTapp::SmplKpt::bz_mesh_manual);
	widget->setExpert   (DTXTapp::SmplKpt::bz_mesh_expert);
	vwidget.push_back(widget);
	grid->addWidget(widget);
      }

      {
	MyQSpinBoxGroup* widget = new MyQSpinBoxGroup
	  ("tile index to edit","tile No.",
	   model.xtapp.smplkpt.index_shown, 0, 0,
	   this, SLOT(edit(const MyEvent&)), ID_DETAIL_INDEX );
	//      widget->setFixedWidth(250);
	grid->addWidget(widget);
	vwidget.push_back(widget);

	spinbox_mmm_index = widget;
      }

      {
	MyQSpinBoxGroup* widget = new MyQSpinBoxGroup
	  ("mmm1:","mmm1:",
	   0, 1000,
	   this, SLOT(edit(const MyEvent&)), ID_DETAIL_VALUE );
	for( int j=0; j<3; j++ ){
	  widget->addSpinBox( model.xtapp.smplkpt.mmm1_shown[j] );
	}
	//      widget->setFixedWidth(250);
	grid->addWidget(widget);
	vwidget.push_back(widget);
      }
      {
	MyQSpinBoxGroup* widget = new MyQSpinBoxGroup
	  ("mmm2:","mmm2:",
	   0, 1000,
	   this, SLOT(edit(const MyEvent&)), ID_DETAIL_VALUE );
	for( int j=0; j<3; j++ ){
	  widget->addSpinBox( model.xtapp.smplkpt.mmm2_shown[j] );
	}
	//      widget->setFixedWidth(250);
	grid->addWidget(widget);
	vwidget.push_back(widget);
      }

      MyQGroupBox* widget = new MyQGroupBox("");
      QHBoxLayout* box  = new QHBoxLayout;
      {
	MyQPushButton* swidget = new MyQPushButton
	  ( "add tile", this, SLOT(edit(const MyEvent&)), ID_DETAIL_ADD );
	swidget->setFixedWidth(60);
	box->addWidget(swidget);
	vwidget.push_back(swidget);
      }
      {
	MyQPushButton* swidget = new MyQPushButton
	  ( "del tile", this, SLOT(edit(const MyEvent&)), ID_DETAIL_DEL );
	swidget->setFixedWidth(60);
	box->addWidget(swidget);
	vwidget.push_back(swidget);
      }
      widget->setLayout(box);

      widget->setFixedWidth(250);
      grid->addWidget(widget);
      vwidget.push_back(widget);

      group->setToolTip(DTXTapp::SmplKpt::mmm_detail_bal);
      group->setLayout(grid);
      layout->addWidget(group);

      group->setExpert(true);
      vgroup.push_back(group);
    }

    hlayout->addLayout(layout);
  }

  setLayout(hlayout);
  updateExpert(false);
}

void QTXTappSmplKpt::edit( const MyEvent& ev )
{
  switch(ev.id){
  case ID_OUTLINE : {
    model.xtapp.smplkpt.setByOutline();
  } break;
  case ID_DETAIL_INDEX : {
    model.xtapp.smplkpt.update_shown();
  } break;
  case ID_DETAIL_VALUE : {
    model.xtapp.smplkpt.change_shown();
    model.xtapp.smplkpt.setByDetail();
  } break;
  case ID_DETAIL_ADD : {
    model.xtapp.smplkpt.addMMM();
    model.xtapp.smplkpt.setByDetail();
  } break;
  case ID_DETAIL_DEL : {
    model.xtapp.smplkpt.delMMM();
    model.xtapp.smplkpt.setByDetail();
  } break;
  default : break;
  }

  emit changed(MyEvent(id));
}




void QTXTappSmplKpt::updateExpert( const bool expert )
{
  model.xtapp.smplkpt.update_shown();
  spinbox_mmm_index->setRange( 1, model.xtapp.smplkpt.size_shown() );

  const QString& mode = 
    model.xtapp.smplkpt.vdos_mode
    [model.xtapp.smplkpt.idos_mode];

  if( mode == "'COS'" ){
    spinbox_rmesh_number_shell->setEnabled(true);
    spinbox_rmesh_range->setEnabled(true);
  }
  else{
    spinbox_rmesh_number_shell->setEnabled(false);
    spinbox_rmesh_range->setEnabled(false);
  }


  MyQTab::updateExpert(expert);
}


//------------------------------------------------------------

QTXTappStructOpt::QTXTappStructOpt( DTModel& _model, const int id ) : MyQTab(id), model(_model)
{
  QHBoxLayout* hlayout = new QHBoxLayout(this);
  hlayout->setSizeConstraint( QLayout::SetFixedSize );

  {
    QVBoxLayout* layout = new QVBoxLayout;

    // converge_energy, edit slider
    {
      MyQEditSliderGroup* widget = new MyQEditSliderGroup
	( "converge_energy", "energy:", "a.u.", "high", "low",
	  model.xtapp.structopt.converge_energy,
	  DTXTapp::StructOpt::converge_energy_min,
	  DTXTapp::StructOpt::converge_energy_max,
	  this, SLOT(edit(const MyEvent&)), ID_MISC );
      widget->setFixedWidth(250);
      layout->addWidget(widget);
      vwidget.push_back(widget);

      widget->setToolTip(DTXTapp::StructOpt::converge_energy_bal);
      widget->setCheckable(DTXTapp::StructOpt::converge_energy_manual);
      widget->setExpert   (DTXTapp::StructOpt::converge_energy_expert);
      vgroup.push_back(widget);
    }
    // converge_force, edit slider
    {
      MyQEditSliderGroup* widget = new MyQEditSliderGroup
	( "converge_force", "force:", "a.u.", "high", "low",
	  model.xtapp.structopt.converge_force,
	  DTXTapp::StructOpt::converge_force_min,
	  DTXTapp::StructOpt::converge_force_max,
	  this, SLOT(edit(const MyEvent&)), ID_MISC );
      widget->setFixedWidth(250);
      layout->addWidget(widget);
      vwidget.push_back(widget);

      widget->setToolTip(DTXTapp::StructOpt::converge_force_bal);
      widget->setCheckable(DTXTapp::StructOpt::converge_force_manual);
      widget->setExpert   (DTXTapp::StructOpt::converge_force_expert);
      vgroup.push_back(widget);
    }
    // search_1d_fratio, edit slider
    {
      MyQEditSliderGroup* widget = new MyQEditSliderGroup
	( "search_1d_fratio", "ratio:", "", "low", "high",
	  model.xtapp.structopt.search_1d_fratio,
	  DTXTapp::StructOpt::search_1d_fratio_min,
	  DTXTapp::StructOpt::search_1d_fratio_max,
	  this, SLOT(edit(const MyEvent&)), ID_MISC );
      widget->setFixedWidth(250);
      layout->addWidget(widget);
      vwidget.push_back(widget);

      widget->setToolTip(DTXTapp::StructOpt::search_1d_fratio_bal);
      widget->setCheckable(DTXTapp::StructOpt::search_1d_fratio_manual);
      widget->setExpert   (DTXTapp::StructOpt::search_1d_fratio_expert);
      vgroup.push_back(widget);
    }
    // displacement_max, edit slider
    {
      MyQEditSliderGroup* widget = new MyQEditSliderGroup
	( "displacement_max", "max:", "a.u.", "low", "high",
	  model.xtapp.structopt.displacement_max,
	  DTXTapp::StructOpt::displacement_max_min,
	  DTXTapp::StructOpt::displacement_max_max,
	  this, SLOT(edit(const MyEvent&)), ID_MISC );
      widget->setFixedWidth(250);
      layout->addWidget(widget);
      vwidget.push_back(widget);

      widget->setToolTip(DTXTapp::StructOpt::displacement_max_bal);
      widget->setCheckable(DTXTapp::StructOpt::displacement_max_manual);
      widget->setExpert   (DTXTapp::StructOpt::displacement_max_expert);
      vgroup.push_back(widget);
    }

    hlayout->addLayout(layout);
  }


  {
    QVBoxLayout* layout = new QVBoxLayout;

    // number_cycle, spinbox
    {
      MyQSpinBoxGroup* widget = new MyQSpinBoxGroup
	("number_cycle","cycle:",
	 model.xtapp.structopt.number_cycle,
	 DTXTapp::StructOpt::number_cycle_min,
	 DTXTapp::StructOpt::number_cycle_max,
	 this, SLOT(edit(const MyEvent&)), ID_MISC );
      widget->setFixedWidth(250);
      layout->addWidget(widget);
      vwidget.push_back(widget);

      widget->setToolTip(DTXTapp::StructOpt::number_cycle_bal);
      widget->setCheckable(DTXTapp::StructOpt::number_cycle_manual);
      widget->setExpert   (DTXTapp::StructOpt::number_cycle_expert);
      vgroup.push_back(widget);
    }
    // refresh_cycle, spinbox
    {
      MyQSpinBoxGroup* widget = new MyQSpinBoxGroup
	("refresh_cycle","cycle:",
	 model.xtapp.structopt.refresh_cycle,
	 DTXTapp::StructOpt::refresh_cycle_min,
	 DTXTapp::StructOpt::refresh_cycle_max,
	 this, SLOT(edit(const MyEvent&)), ID_MISC );
      widget->setFixedWidth(250);
      layout->addWidget(widget);
      vwidget.push_back(widget);
      
      widget->setToolTip(DTXTapp::StructOpt::refresh_cycle_bal);
      widget->setCheckable(DTXTapp::StructOpt::refresh_cycle_manual);
      widget->setExpert   (DTXTapp::StructOpt::refresh_cycle_expert);
      vgroup.push_back(widget);
    }
    // search_1d_max_step, spinbox
    {
      MyQSpinBoxGroup* widget = new MyQSpinBoxGroup
	("search_1d_max_step","step:",
	 model.xtapp.structopt.search_1d_max_step,
	 DTXTapp::StructOpt::search_1d_max_step_min,
	 DTXTapp::StructOpt::search_1d_max_step_max,
	 this, SLOT(edit(const MyEvent&)), ID_MISC );
      widget->setFixedWidth(250);
      layout->addWidget(widget);
      vwidget.push_back(widget);

      widget->setToolTip(DTXTapp::StructOpt::search_1d_max_step_bal);
      widget->setCheckable(DTXTapp::StructOpt::search_1d_max_step_manual);
      widget->setExpert   (DTXTapp::StructOpt::search_1d_max_step_expert);
      vgroup.push_back(widget);
    }

    // extern_pressure, edit slider
    {
      MyQEditSliderGroup* widget = new MyQEditSliderGroup
	( "extern_pressure", ":", "a.u.", "low", "high",
	  model.xtapp.structopt.extern_pressure,
	  DTXTapp::StructOpt::extern_pressure_min,
	  DTXTapp::StructOpt::extern_pressure_max,
	  this, SLOT(edit(const MyEvent&)), ID_MISC );
      widget->setFixedWidth(250);
      layout->addWidget(widget);
      vwidget.push_back(widget);

      widget->setToolTip(DTXTapp::StructOpt::extern_pressure_bal);
      widget->setCheckable(DTXTapp::StructOpt::extern_pressure_manual);
      widget->setExpert   (DTXTapp::StructOpt::extern_pressure_expert);
      vgroup.push_back(widget);
    }
    // stress_scale, lineedit
    {
      MyQGroupBox* widget = new MyQGroupBox("stress_scale");
      QGridLayout* box = new QGridLayout;
      int row=0,col=0;

      box->addWidget(new QLabel("xx:"),row,col++);
      {
	MyQLineEdit* swidget = new MyQLineEdit
	  ( model.xtapp.structopt.stress_scale[0],
	    DTXTapp::StructOpt::stress_scale_min,
	    DTXTapp::StructOpt::stress_scale_max,
	    this, SLOT(edit(const MyEvent&)), ID_MISC );
	swidget->setFixedWidth(80);
	box->addWidget(swidget,row,col++);
	vwidget.push_back(swidget);
      }
      row++,col=0;

      box->addWidget(new QLabel("yy:"),row,col++);
      {
	MyQLineEdit* swidget = new MyQLineEdit
	  ( model.xtapp.structopt.stress_scale[1],
	    DTXTapp::StructOpt::stress_scale_min,
	    DTXTapp::StructOpt::stress_scale_max,
	    this, SLOT(edit(const MyEvent&)), ID_MISC );
	swidget->setFixedWidth(80);
	box->addWidget(swidget,row,col++);
	vwidget.push_back(swidget);
      }
      row++,col=0;

      box->addWidget(new QLabel("zz:"),row,col++);
      {
	MyQLineEdit* swidget = new MyQLineEdit
	  ( model.xtapp.structopt.stress_scale[2],
	    DTXTapp::StructOpt::stress_scale_min,
	    DTXTapp::StructOpt::stress_scale_max,
	    this, SLOT(edit(const MyEvent&)), ID_MISC );
	swidget->setFixedWidth(80);
	box->addWidget(swidget,row,col++);
	vwidget.push_back(swidget);
      }
      row++,col=0;

      box->addWidget(new QLabel("yz:"),row,col++);
      {
	MyQLineEdit* swidget = new MyQLineEdit
	  ( model.xtapp.structopt.stress_scale[3],
	    DTXTapp::StructOpt::stress_scale_min,
	    DTXTapp::StructOpt::stress_scale_max,
	    this, SLOT(edit(const MyEvent&)), ID_MISC );
	swidget->setFixedWidth(80);
	box->addWidget(swidget,row,col++);
	vwidget.push_back(swidget);
      }
      row++,col=0;

      box->addWidget(new QLabel("zx:"),row,col++);
      {
	MyQLineEdit* swidget = new MyQLineEdit
	  ( model.xtapp.structopt.stress_scale[4],
	    DTXTapp::StructOpt::stress_scale_min,
	    DTXTapp::StructOpt::stress_scale_max,
	    this, SLOT(edit(const MyEvent&)), ID_MISC );
	swidget->setFixedWidth(80);
	box->addWidget(swidget,row,col++);
	vwidget.push_back(swidget);
      }
      row++,col=0;

      box->addWidget(new QLabel("xy:"),row,col++);
      {
	MyQLineEdit* swidget = new MyQLineEdit
	  ( model.xtapp.structopt.stress_scale[5],
	    DTXTapp::StructOpt::stress_scale_min,
	    DTXTapp::StructOpt::stress_scale_max,
	    this, SLOT(edit(const MyEvent&)), ID_MISC );
	swidget->setFixedWidth(80);
	box->addWidget(swidget,row,col++);
	vwidget.push_back(swidget);
      }
      row++,col=0;

      widget->setLayout(box);
      widget->setFixedWidth(250);
      layout->addWidget(widget);

      widget->setToolTip(DTXTapp::StructOpt::stress_scale_bal);
      widget->setCheckable(DTXTapp::StructOpt::stress_scale_manual);
      widget->setExpert   (DTXTapp::StructOpt::stress_scale_expert);
      vgroup.push_back(widget);
    }

    hlayout->addLayout(layout);
  }

  setLayout(hlayout);
  updateExpert(false);
}

void QTXTappStructOpt::edit( const MyEvent& ev )
{
  emit changed(MyEvent(id));
}

void QTXTappStructOpt::updateExpert( const bool expert )
{
  MyQTab::updateExpert(expert);
}

//------------------------------------------------------------

QTXTappStrOptConstr::QTXTappStrOptConstr( DTModel& _model, const int id ) : MyQTab(id), model(_model)
{
  QVBoxLayout* layout = new QVBoxLayout(this);
  layout->setSizeConstraint( QLayout::SetFixedSize );

  // tim
  {
    MyQGroupBox* group = new MyQGroupBox("tim");
    QGridLayout* grid = new QGridLayout;
    int row = 0;

    {
      MyQSpinBoxGroup* widget = new MyQSpinBoxGroup
	("tim index to edit","tim No.",
	 model.xtapp.stroptconstr.tim_index_shown, 0, 0,
	 this, SLOT(edit(const MyEvent&)), ID_TIM_INDEX );
      vwidget.push_back(widget);
      spinbox_tim_index = widget;
      grid->addWidget(widget,row,0,1,4);
    }
    row++;

    grid->addWidget(new QLabel("tim:"),row,0);
    for( int i=0; i<3; i++ ){
      for( int j=0; j<3; j++ ){
	MyQLineEdit* widget = new MyQLineEdit
	  (
	   model.xtapp.stroptconstr.tim_shown(i,j), 0.0, 128.0,
	   this, SLOT(edit(const MyEvent&)), ID_TIM_VALUE );
	widget->setFixedWidth(80);
	grid->addWidget(widget,row,j+1);
	vwidget.push_back(widget);
      }
      row++;
    }
    group_tim = group;

    group->setToolTip(DTXTapp::StrOptConstr::tim_bal);
    group->setLayout(grid);
    group->setExpert(true);
    vgroup.push_back(group);

    layout->addWidget(group);
  }

  {
    MyQGroupBox* group = new MyQGroupBox("");
    QHBoxLayout* grid = new QHBoxLayout;

    {
      MyQPushButton* widget = new MyQPushButton
	( "add tim", this, SLOT(edit(const MyEvent&)), ID_TIM_ADD );
      widget->setFixedWidth(60);
      grid->addWidget(widget,Qt::AlignCenter);
      vwidget.push_back(widget);
    }
    {
      MyQPushButton* widget = new MyQPushButton
	( "del tim", this, SLOT(edit(const MyEvent&)), ID_TIM_DEL );
      widget->setFixedWidth(60);
      grid->addWidget(widget,Qt::AlignCenter);
      vwidget.push_back(widget);
    }

    group->setLayout(grid);
    layout->addWidget(group);

    group->setExpert(true);
    vgroup.push_back(group);
  }

  // set
  {
    MyQGroupBox* group = new MyQGroupBox("set");
    QGridLayout* grid = new QGridLayout;
    int row = 0;

    {
      MyQSpinBoxGroup* widget = new MyQSpinBoxGroup
	("atom set index to edit","set No.",
	 model.xtapp.stroptconstr.set_index_shown, 0, 0,
	 this, SLOT(edit(const MyEvent&)), ID_SET_INDEX );
      vwidget.push_back(widget);
      spinbox_set_index = widget;
      grid->addWidget(widget,row,0,1,2);
    }
    row++;

    grid->addWidget(new QLabel("imkd:"),row,0);
    {
      MyQLineEdit* widget = new MyQLineEdit
	( model.xtapp.stroptconstr.set_shown.imkd, 0, 100,
	  this, SLOT(edit(const MyEvent&)), ID_SET_VALUE );
	widget->setFixedWidth(80);
	grid->addWidget(widget,row,1);
	vwidget.push_back(widget);
    }
    row++;
    grid->addWidget(new QLabel("tatm:"),row,0);
    {
      MyQLineEdit* widget = new MyQLineEdit
	( model.xtapp.stroptconstr.set_shown.tatm,
	  this, SLOT(edit(const MyEvent&)), ID_SET_VALUE );
	widget->setFixedWidth(180);
	grid->addWidget(widget,row,1);
	vwidget.push_back(widget);
    }
    row++;
    group_set = group;

    group->setToolTip(DTXTapp::StrOptConstr::set_bal);

    group->setLayout(grid);
    group->setExpert(true);
    vgroup.push_back(group);

    layout->addWidget(group);
  }

  {
    MyQGroupBox* group = new MyQGroupBox("");
    QHBoxLayout* grid = new QHBoxLayout;

    {
      MyQPushButton* widget = new MyQPushButton
	( "add set", this, SLOT(edit(const MyEvent&)), ID_SET_ADD );
      widget->setFixedWidth(60);
      grid->addWidget(widget,Qt::AlignCenter);
      vwidget.push_back(widget);
    }
    {
      MyQPushButton* widget = new MyQPushButton
	( "del set", this, SLOT(edit(const MyEvent&)), ID_SET_DEL );
      widget->setFixedWidth(60);
      grid->addWidget(widget,Qt::AlignCenter);
      vwidget.push_back(widget);
    }

    group->setLayout(grid);
    layout->addWidget(group);

    group->setExpert(true);
    vgroup.push_back(group);
  }

  setLayout(layout);
  updateExpert(false);
}

void QTXTappStrOptConstr::edit( const MyEvent& ev )
{
  switch(ev.id){
  case ID_TIM_INDEX : {
    model.xtapp.stroptconstr.tim_update_shown();
  } break;
  case ID_TIM_VALUE : {
    model.xtapp.stroptconstr.tim_change_shown();
  } break;
  case ID_TIM_ADD : {
    model.xtapp.stroptconstr.tim_add();
  } break;
  case ID_TIM_DEL : {
    model.xtapp.stroptconstr.tim_del();
  } break;

  case ID_SET_INDEX : {
    model.xtapp.stroptconstr.set_update_shown();
  } break;
  case ID_SET_VALUE : {
    model.xtapp.stroptconstr.set_change_shown();
  } break;
  case ID_SET_ADD : {
    model.xtapp.stroptconstr.set_add();
  } break;
  case ID_SET_DEL : {
    model.xtapp.stroptconstr.set_del();
  } break;
  default : break;
  }

  emit changed(MyEvent(id));
}

void QTXTappStrOptConstr::updateExpert( const bool expert )
{
  if( model.xtapp.stroptconstr.tim_size_shown()>0 ){
    group_tim->setEnabled(true);
  }
  else{
    group_tim->setEnabled(false);
  }

  if( model.xtapp.stroptconstr.set_size_shown()>0 ){
    group_set->setEnabled(true);
  }
  else{
    group_set->setEnabled(false);
  }

  model.xtapp.stroptconstr.tim_update_shown();
  spinbox_tim_index->setRange( 1, model.xtapp.stroptconstr.tim_size_shown() );

  model.xtapp.stroptconstr.set_update_shown();
  spinbox_set_index->setRange( 1, model.xtapp.stroptconstr.set_size_shown() );

  MyQTab::updateExpert(expert);
}

//------------------------------------------------------------

QTXTappTraceBand::QTXTappTraceBand( DTModel& _model, const int id ) : MyQTab(id), model(_model)
{
  QHBoxLayout* hlayout = new QHBoxLayout(this);
  hlayout->setSizeConstraint( QLayout::SetFixedSize );

  {
    QVBoxLayout* layout = new QVBoxLayout;

    // distrib_mode
    {
      MyQGroupBox* widget = new MyQGroupBox("distrib_mode");
      QHBoxLayout* box = new QHBoxLayout;

      box->addWidget(new QLabel("mode:"));
      {
	MyQComboBox* swidget = new MyQComboBox
	  ( model.xtapp.traceband.idistrib_mode, model.xtapp.traceband.vdistrib_mode,
	    this, SLOT(edit(const MyEvent&)), ID_MISC );
	box->addWidget(swidget);
	vwidget.push_back(swidget);
      }
      widget->setLayout(box);
      widget->setFixedWidth(250);
      layout->addWidget(widget);

      widget->setToolTip(DTXTapp::TraceBand::distrib_mode_bal);
      widget->setCheckable(DTXTapp::TraceBand::distrib_mode_manual);
      widget->setExpert   (DTXTapp::TraceBand::distrib_mode_expert);
      vgroup.push_back(widget);
    }

    // output_charge, radio button
    {
      MyQGroupBox* widget = new MyQGroupBox("output_charge");
      QHBoxLayout* box = new QHBoxLayout;

      {
	MyQRadioButton* swidget = new MyQRadioButton
	  ( "disable", model.xtapp.traceband.output_charge, 0,
	    this, SLOT(edit(const MyEvent&)), ID_MISC );
	box->addWidget(swidget,Qt::AlignLeft);
	vwidget.push_back(swidget);
      }
      {
	MyQRadioButton* swidget = new MyQRadioButton
	  ( "enable", model.xtapp.traceband.output_charge, 1,
	    this, SLOT(edit(const MyEvent&)), ID_MISC );
	box->addWidget(swidget,Qt::AlignLeft);
	vwidget.push_back(swidget);
      }
      widget->setLayout(box);
      widget->setFixedWidth(250);
      layout->addWidget(widget);

      widget->setToolTip(DTXTapp::TraceBand::output_charge_bal);
      widget->setCheckable(DTXTapp::TraceBand::output_charge_manual);
      widget->setExpert   (DTXTapp::TraceBand::output_charge_expert);
      vgroup.push_back(widget);
    }

    // output_wave_function, radio button
    {
      MyQGroupBox* widget = new MyQGroupBox("output_wave_function");
      QHBoxLayout* box = new QHBoxLayout;

      {
	MyQRadioButton* swidget = new MyQRadioButton
	  ( "disable", model.xtapp.traceband.output_wave_function, 0,
	    this, SLOT(edit(const MyEvent&)), ID_MISC );
	box->addWidget(swidget,Qt::AlignLeft);
	vwidget.push_back(swidget);
      }
      {
	MyQRadioButton* swidget = new MyQRadioButton
	  ( "enable", model.xtapp.traceband.output_wave_function, 1,
	    this, SLOT(edit(const MyEvent&)), ID_MISC );
	box->addWidget(swidget,Qt::AlignLeft);
	vwidget.push_back(swidget);
      }
      widget->setLayout(box);
      widget->setFixedWidth(250);
      layout->addWidget(widget);

      widget->setToolTip(DTXTapp::TraceBand::output_wave_function_bal);
      widget->setCheckable(DTXTapp::TraceBand::output_wave_function_manual);
      widget->setExpert   (DTXTapp::TraceBand::output_wave_function_expert);
      vgroup.push_back(widget);
    }

    // davidson_flag, spinbox
    {
      MyQSpinBoxGroup* widget = new MyQSpinBoxGroup
	("davidson_flag","flag:",
	 model.xtapp.traceband.davidson_flag,
	 DTXTapp::TraceBand::davidson_flag_min,
	 DTXTapp::TraceBand::davidson_flag_max,
	 this, SLOT(edit(const MyEvent&)), ID_MISC );
      widget->setFixedWidth(250);
      layout->addWidget(widget);
      vwidget.push_back(widget);

      widget->setToolTip(DTXTapp::TraceBand::davidson_flag_bal);
      widget->setCheckable(DTXTapp::TraceBand::davidson_flag_manual);
      widget->setExpert   (DTXTapp::TraceBand::davidson_flag_expert);
      vgroup.push_back(widget);
    }

    // davidson_number_diag, spinbox
    {
      MyQSpinBoxGroup* widget = new MyQSpinBoxGroup
	("davidson_number_diag","step:",
	 model.xtapp.traceband.davidson_number_diag,
	 DTXTapp::TraceBand::davidson_number_diag_min,
	 DTXTapp::TraceBand::davidson_number_diag_max,
	 this, SLOT(edit(const MyEvent&)), ID_MISC );
      widget->setFixedWidth(250);
      layout->addWidget(widget);
      vwidget.push_back(widget);

      widget->setToolTip(DTXTapp::TraceBand::davidson_number_diag_bal);
      widget->setCheckable(DTXTapp::TraceBand::davidson_number_diag_manual);
      widget->setExpert   (DTXTapp::TraceBand::davidson_number_diag_expert);
      vgroup.push_back(widget);
    }

    // diag_converge, edit slider
    {
      MyQEditSliderGroup* widget = new MyQEditSliderGroup
	( "diag_converge", "converge:", "", "high", "low",
	  model.xtapp.traceband.diag_converge,
	  DTXTapp::TraceBand::diag_converge_min,
	  DTXTapp::TraceBand::diag_converge_max,
	  this, SLOT(edit(const MyEvent&)), ID_MISC );
      widget->setFixedWidth(250);
      vwidget.push_back(widget);
      layout->addWidget(widget);

      widget->setToolTip(DTXTapp::TraceBand::diag_converge_bal);
      widget->setCheckable(DTXTapp::TraceBand::diag_converge_manual);
      widget->setExpert   (DTXTapp::TraceBand::diag_converge_expert);
      vgroup.push_back(widget);
    }

    hlayout->addLayout(layout);
  }


  {
    QVBoxLayout* layout = new QVBoxLayout;


    // distrib_band_lower, spinbox
    {
      MyQSpinBoxGroup* widget = new MyQSpinBoxGroup
	("distrib_band_lower","lower:",
	 model.xtapp.traceband.distrib_band_lower,
	 DTXTapp::TraceBand::distrib_band_lower_min,
	 DTXTapp::TraceBand::distrib_band_lower_max,
	 this, SLOT(edit(const MyEvent&)), ID_MISC );
      widget->setFixedWidth(250);
      layout->addWidget(widget);
      vwidget.push_back(widget);

      widget->setToolTip(DTXTapp::TraceBand::distrib_band_lower_bal);
      widget->setCheckable(DTXTapp::TraceBand::distrib_band_lower_manual);
      widget->setExpert   (DTXTapp::TraceBand::distrib_band_lower_expert);
      vgroup.push_back(widget);
    }

    // distrib_band_upper, spinbox
    {
      MyQSpinBoxGroup* widget = new MyQSpinBoxGroup
	("distrib_band_upper","upper:",
	 model.xtapp.traceband.distrib_band_upper,
	 DTXTapp::TraceBand::distrib_band_upper_min,
	 DTXTapp::TraceBand::distrib_band_upper_max,
	 this, SLOT(edit(const MyEvent&)), ID_MISC );
      widget->setFixedWidth(250);
      layout->addWidget(widget);
      vwidget.push_back(widget);

      widget->setToolTip(DTXTapp::TraceBand::distrib_band_upper_bal);
      widget->setCheckable(DTXTapp::TraceBand::distrib_band_upper_manual);
      widget->setExpert   (DTXTapp::TraceBand::distrib_band_upper_expert);
      vgroup.push_back(widget);
    }

    // distrib_number_sphere, spinbox
    {
      MyQSpinBoxGroup* widget = new MyQSpinBoxGroup
	("distrib_number_sphere","sphere:",
	 model.xtapp.traceband.distrib_number_sphere,
	 DTXTapp::TraceBand::distrib_number_sphere_min,
	 DTXTapp::TraceBand::distrib_number_sphere_max,
	 this, SLOT(edit(const MyEvent&)), ID_MISC );
      widget->setFixedWidth(250);
      layout->addWidget(widget);
      vwidget.push_back(widget);

      widget->setToolTip(DTXTapp::TraceBand::distrib_number_sphere_bal);
      widget->setCheckable(DTXTapp::TraceBand::distrib_number_sphere_manual);
      widget->setExpert   (DTXTapp::TraceBand::distrib_number_sphere_expert);
      vgroup.push_back(widget);

      group_sphere = widget;
    }

    // distrib_number_plate, spinbox
    {
      MyQSpinBoxGroup* widget = new MyQSpinBoxGroup
	("distrib_number_plate","plate:",
	 model.xtapp.traceband.distrib_number_plate,
	 DTXTapp::TraceBand::distrib_number_plate_min,
	 DTXTapp::TraceBand::distrib_number_plate_max,
	 this, SLOT(edit(const MyEvent&)), ID_MISC );
      widget->setFixedWidth(250);
      layout->addWidget(widget);
      vwidget.push_back(widget);

      widget->setToolTip(DTXTapp::TraceBand::distrib_number_plate_bal);
      widget->setCheckable(DTXTapp::TraceBand::distrib_number_plate_manual);
      widget->setExpert   (DTXTapp::TraceBand::distrib_number_plate_expert);
      vgroup.push_back(widget);

      group_plate = widget;
    }

    // number_band, spinbox
    {
      MyQSpinBoxGroup* widget = new MyQSpinBoxGroup
	("number_band","band:",
	 model.xtapp.traceband.number_band,
	 DTXTapp::TraceBand::number_band_min,
	 DTXTapp::TraceBand::number_band_max,
	 this, SLOT(edit(const MyEvent&)), ID_MISC );
      widget->setFixedWidth(250);
      layout->addWidget(widget);
      vwidget.push_back(widget);

      widget->setToolTip(DTXTapp::TraceBand::number_band_bal);
      widget->setCheckable(DTXTapp::TraceBand::number_band_manual);
      widget->setExpert   (DTXTapp::TraceBand::number_band_expert);
      vgroup.push_back(widget);
    }

    /* DEBUG
    // number_band_traced, spinbox
    {
      MyQSpinBoxGroup* widget = new MyQSpinBoxGroup
	("number_band_traced","band:",
	 model.xtapp.traceband.number_band_traced,
	 DTXTapp::TraceBand::number_band_traced_min,
	 DTXTapp::TraceBand::number_band_traced_max,
	 this, SLOT(edit(const MyEvent&)), ID_MISC );
      widget->setFixedWidth(250);
      layout->addWidget(widget);
      vwidget.push_back(widget);

      widget->setToolTip(DTXTapp::TraceBand::number_band_traced_bal);
      widget->setCheckable(DTXTapp::TraceBand::number_band_traced_manual);
      widget->setExpert   (DTXTapp::TraceBand::number_band_traced_expert);
      vgroup.push_back(widget);
    }

    // number_trace_block, spinbox
    {
      MyQSpinBoxGroup* widget = new MyQSpinBoxGroup
	("number_trace_block","block:",
	 model.xtapp.traceband.number_trace_block,
	 DTXTapp::TraceBand::number_trace_block_min,
	 DTXTapp::TraceBand::number_trace_block_max,
	 this, SLOT(edit(const MyEvent&)), ID_MISC );
      widget->setFixedWidth(250);
      layout->addWidget(widget);
      vwidget.push_back(widget);

      widget->setToolTip(DTXTapp::TraceBand::number_trace_block_bal);
      widget->setCheckable(DTXTapp::TraceBand::number_trace_block_manual);
      widget->setExpert   (DTXTapp::TraceBand::number_trace_block_expert);
      vgroup.push_back(widget);
    }
    */

    hlayout->addLayout(layout);
  }

  {
    QVBoxLayout* layout = new QVBoxLayout;

    // iaxis, radio button
    {
      MyQGroupBox* widget = new MyQGroupBox("iaxis");
      QHBoxLayout* box = new QHBoxLayout;

      {
	MyQRadioButton* swidget = new MyQRadioButton
	  ( "x", model.xtapp.traceband.iaxis, 1,
	    this, SLOT(edit(const MyEvent&)), ID_MISC );
	box->addWidget(swidget,Qt::AlignLeft);
	vwidget.push_back(swidget);
      }
      {
	MyQRadioButton* swidget = new MyQRadioButton
	  ( "y", model.xtapp.traceband.iaxis, 2,
	    this, SLOT(edit(const MyEvent&)), ID_MISC );
	box->addWidget(swidget,Qt::AlignLeft);
	vwidget.push_back(swidget);
      }
      {
	MyQRadioButton* swidget = new MyQRadioButton
	  ( "z", model.xtapp.traceband.iaxis, 3,
	    this, SLOT(edit(const MyEvent&)), ID_MISC );
	box->addWidget(swidget,Qt::AlignLeft);
	vwidget.push_back(swidget);
      }
      widget->setLayout(box);
      widget->setFixedWidth(250);
      layout->addWidget(widget);

      widget->setToolTip(DTXTapp::TraceBand::iaxis_bal);
      widget->setCheckable(DTXTapp::TraceBand::iaxis_manual);
      widget->setExpert   (DTXTapp::TraceBand::iaxis_expert);
      widget->setExpert(true);
      vgroup.push_back(widget);

      group_iaxis = widget;
    }
    // rzero, lineedit
    {
      MyQGroupBox* widget = new MyQGroupBox("rzero");
      QGridLayout* box = new QGridLayout;
      int row=0,col=0;

      box->addWidget(new QLabel("x:"),row,col++);
      {
	MyQLineEdit* swidget = new MyQLineEdit
	  ( model.xtapp.traceband.rzero.x,
	    DTXTapp::TraceBand::rzero_min,
	    DTXTapp::TraceBand::rzero_max,
	    this, SLOT(edit(const MyEvent&)), ID_MISC );
	swidget->setFixedWidth(80);
	box->addWidget(swidget,row,col++);
	vwidget.push_back(swidget);
      }
      row++,col=0;

      box->addWidget(new QLabel("y:"),row,col++);
      {
	MyQLineEdit* swidget = new MyQLineEdit
	  ( model.xtapp.traceband.rzero.y,
	    DTXTapp::TraceBand::rzero_min,
	    DTXTapp::TraceBand::rzero_max,
	    this, SLOT(edit(const MyEvent&)), ID_MISC );
	swidget->setFixedWidth(80);
	box->addWidget(swidget,row,col++);
	vwidget.push_back(swidget);
      }
      row++,col=0;

      box->addWidget(new QLabel("z:"),row,col++);
      {
	MyQLineEdit* swidget = new MyQLineEdit
	  ( model.xtapp.traceband.rzero.z,
	    DTXTapp::TraceBand::rzero_min,
	    DTXTapp::TraceBand::rzero_max,
	    this, SLOT(edit(const MyEvent&)), ID_MISC );
	swidget->setFixedWidth(80);
	box->addWidget(swidget,row,col++);
	vwidget.push_back(swidget);
      }

      widget->setLayout(box);
      widget->setFixedWidth(250);
      layout->addWidget(widget);

      widget->setToolTip(DTXTapp::TraceBand::rzero_bal);
      widget->setCheckable(DTXTapp::TraceBand::rzero_manual);
      widget->setExpert   (DTXTapp::TraceBand::rzero_expert);
      widget->setExpert(true);
      vgroup.push_back(widget);

      group_rzero = widget;
    }

    // rmin,rmax, lineedit
    {
      MyQGroupBox* widget = new MyQGroupBox("rmin,rmax");
      QGridLayout* box = new QGridLayout;
      int row=0,col=0;

      box->addWidget(new QLabel("rmin:"),row,col++);
      {
	MyQLineEdit* swidget = new MyQLineEdit
	  ( model.xtapp.traceband.rmin,
	    DTXTapp::TraceBand::rmin_min,
	    DTXTapp::TraceBand::rmin_max,
	    this, SLOT(edit(const MyEvent&)), ID_MISC );
	swidget->setFixedWidth(80);
	box->addWidget(swidget,row,col++);
	vwidget.push_back(swidget);
      }
      row++,col=0;

      box->addWidget(new QLabel("rmax:"),row,col++);
      {
	MyQLineEdit* swidget = new MyQLineEdit
	  ( model.xtapp.traceband.rmax,
	    DTXTapp::TraceBand::rmin_min,
	    DTXTapp::TraceBand::rmin_max,
	    this, SLOT(edit(const MyEvent&)), ID_MISC );
	swidget->setFixedWidth(80);
	box->addWidget(swidget,row,col++);
	vwidget.push_back(swidget);
      }

      widget->setLayout(box);
      widget->setFixedWidth(250);
      layout->addWidget(widget);

      widget->setToolTip(DTXTapp::TraceBand::rmin_bal);
      widget->setCheckable(DTXTapp::TraceBand::rmin_manual);
      widget->setExpert   (DTXTapp::TraceBand::rmin_expert);
      widget->setExpert(true);
      vgroup.push_back(widget);

      group_range = widget;
    }

    // ndiv, spinbox
    {
      MyQSpinBoxGroup* widget = new MyQSpinBoxGroup
	("ndiv","ndiv:",
	 model.xtapp.traceband.ndiv,
	 DTXTapp::TraceBand::ndiv_min,
	 DTXTapp::TraceBand::ndiv_max,
	 this, SLOT(edit(const MyEvent&)), ID_MISC );
      widget->setFixedWidth(250);
      layout->addWidget(widget);
      vwidget.push_back(widget);

      widget->setExpert(true);
      vgroup.push_back(widget);

      widget->setToolTip(DTXTapp::TraceBand::ndiv_bal);
      widget->setCheckable(DTXTapp::TraceBand::ndiv_manual);
      widget->setExpert   (DTXTapp::TraceBand::ndiv_expert);
      group_ndiv  = widget;
    }

    /*DEBUG
    {
      MyQGroupBox* group = new MyQGroupBox("K-points");
      QGridLayout* grid = new QGridLayout;
      int row=0;

      {
	MyQSpinBoxGroup* widget = new MyQSpinBoxGroup
	  ("K point index to edit","K-point No.",
	   model.xtapp.traceband.index_shown, 0, 0,
	   this, SLOT(edit(const MyEvent&)), ID_KPOINT_INDEX );
	grid->addWidget(widget,row,0,1,4);
	vwidget.push_back(widget);
	spinbox_index = widget;
      }
      row++;

      grid->addWidget(new QLabel("nkpt:"),row,0);
      {
	MyQLineEdit* widget = new MyQLineEdit
	  (
	   model.xtapp.traceband.band_shown.nkpt,
	   this, SLOT(edit(const MyEvent&)), ID_KPOINT_VALUE );
	widget->setFixedWidth(60);
	grid->addWidget(widget,row,1);
	vwidget.push_back(widget);
      }
      row++;

      grid->addWidget(new QLabel("ak:"),row,0);
      for( int j=0; j<3; j++ ){
	MyQLineEdit* swidget = new MyQLineEdit
	  (
	   model.xtapp.traceband.band_shown.ak(j), 0.0, 1.0,
	   this, SLOT(edit(const MyEvent&)), ID_KPOINT_VALUE );
	//      swidget->setFixedWidth(80);
	swidget->setFixedWidth(80);
	grid->addWidget(swidget,row++,1);
	vwidget.push_back(swidget);
      }
      row++;

      grid->addWidget(new QLabel("nkfi:"),row,0);
      {
	MyQLineEdit* widget = new MyQLineEdit
	  ( model.xtapp.traceband.band_shown.nkfi, 0, 100,
	    this, SLOT(edit(const MyEvent&)), ID_KPOINT_VALUE );
	widget->setFixedWidth(60);
	grid->addWidget(widget,row,1);
	vwidget.push_back(widget);
      }
      row++;

      {
	MyQPushButton* widget = new MyQPushButton
	  ( "add K", this, SLOT(edit(const MyEvent&)), ID_KPOINT_ADD );
	widget->setFixedWidth(60);
	grid->addWidget(widget,row,1);
	vwidget.push_back(widget);
      }
      {
	MyQPushButton* widget = new MyQPushButton
	  ( "del K", this, SLOT(edit(const MyEvent&)), ID_KPOINT_DEL );
	widget->setFixedWidth(60);
	grid->addWidget(widget,row,2);
	vwidget.push_back(widget);
      }
      row++;

      group->setToolTip(DTXTapp::TraceBand::kpoint_bal);
      group->setCheckable(DTXTapp::TraceBand::kpoint_manual);
      group->setExpert   (DTXTapp::TraceBand::kpoint_expert);

      group->setLayout(grid);
      group->setFixedWidth(250);
      layout->addWidget(group);
      group->setExpert(true);
      vgroup.push_back(group);
    }
    */

    hlayout->addLayout(layout);
  }

  setLayout(hlayout);
  updateExpert(false);
}


void QTXTappTraceBand::edit( const MyEvent& ev )
{
  /*
  switch(ev.id){
  case ID_KPOINT_INDEX : {
    model.xtapp.traceband.update_shown();
  } break;
  case ID_KPOINT_VALUE : {
    model.xtapp.traceband.change_shown();
  } break;
  case ID_KPOINT_ADD : {
    model.xtapp.traceband.add();
  } break;
  case ID_KPOINT_DEL : {
    model.xtapp.traceband.del();
  } break;

  default : break;
  }
  */
  emit changed(MyEvent(id));
}

void QTXTappTraceBand::updateExpert( const bool expert )
{
  /* DEBUG
  model.xtapp.traceband.update_shown();
  spinbox_index->setRange( 1, model.xtapp.traceband.size_shown() );
  */
  MyQTab::updateExpert(expert);


  const QString& mode = 
    model.xtapp.traceband.vdistrib_mode
    [model.xtapp.traceband.idistrib_mode];

  if( mode == "'none'" ){
    group_sphere->setEnabled(false);
    group_plate->setEnabled(false);
    group_iaxis->setEnabled(false);
    group_rzero->setEnabled(false);
    group_range->setEnabled(false);
    group_ndiv ->setEnabled(false);
  }
  if( mode == "'sphere'" ){
    group_sphere->setEnabled(true);
    group_plate->setEnabled(false);
    group_iaxis->setEnabled(false);
    group_rzero->setEnabled(true);
    group_range->setEnabled(true);
    group_ndiv ->setEnabled(true);
  }
  if( mode == "'plate'" ){
    group_sphere->setEnabled(false);
    group_plate->setEnabled(true);
    group_iaxis->setEnabled(true);
    group_rzero->setEnabled(false);
    group_range->setEnabled(true);
    group_ndiv ->setEnabled(true);
  }
}

//------------------------------------------------------------

QTXTappInspectWfn::QTXTappInspectWfn( DTModel& _model, const int id ) : MyQTab(id), model(_model)
{
  QHBoxLayout* hlayout = new QHBoxLayout(this);
  hlayout->setSizeConstraint( QLayout::SetFixedSize );

  {
    QVBoxLayout* layout = new QVBoxLayout;

    // distrib_mode
    {
      MyQGroupBox* widget = new MyQGroupBox("distrib_mode");
      QHBoxLayout* box = new QHBoxLayout;

      box->addWidget(new QLabel("mode:"));
      {
	MyQComboBox* widget = new MyQComboBox
	  ( model.xtapp.inspectwfn.idistrib_mode, model.xtapp.inspectwfn.vdistrib_mode,
	    this, SLOT(edit(const MyEvent&)), ID_MISC );
	box->addWidget(widget);
	vwidget.push_back(widget);
      }

      widget->setLayout(box);
      widget->setFixedWidth(250);
      layout->addWidget(widget);

      widget->setToolTip(DTXTapp::InspectWfn::distrib_mode_bal);
      widget->setCheckable(DTXTapp::InspectWfn::distrib_mode_manual);
      widget->setExpert   (DTXTapp::InspectWfn::distrib_mode_expert);
      vgroup.push_back(widget);
    }

    // output_charge, radio button
    {
      MyQGroupBox* widget = new MyQGroupBox("output_charge");
      QHBoxLayout* box = new QHBoxLayout;

      {
	MyQRadioButton* swidget = new MyQRadioButton
	  ( "disable", model.xtapp.inspectwfn.output_charge, 0,
	    this, SLOT(edit(const MyEvent&)), ID_MISC );
	box->addWidget(swidget,Qt::AlignLeft);
	vwidget.push_back(swidget);
      }
      {
	MyQRadioButton* swidget = new MyQRadioButton
	  ( "enable", model.xtapp.inspectwfn.output_charge, 1,
	    this, SLOT(edit(const MyEvent&)), ID_MISC );
	box->addWidget(swidget,Qt::AlignLeft);
	vwidget.push_back(swidget);
      }
      widget->setLayout(box);
      widget->setFixedWidth(250);
      layout->addWidget(widget);

      widget->setToolTip(DTXTapp::InspectWfn::output_charge_bal);
      widget->setCheckable(DTXTapp::InspectWfn::output_charge_manual);
      widget->setExpert   (DTXTapp::InspectWfn::output_charge_expert);
      vgroup.push_back(widget);
    }

    // distrib_band_lower, spinbox
    {
      MyQSpinBoxGroup* widget = new MyQSpinBoxGroup
	("distrib_band_lower","lower:",
	 model.xtapp.inspectwfn.distrib_band_lower,
	 DTXTapp::InspectWfn::distrib_band_lower_min,
	 DTXTapp::InspectWfn::distrib_band_lower_max,
	 this, SLOT(edit(const MyEvent&)), ID_MISC );
      widget->setFixedWidth(250);
      layout->addWidget(widget);
      vwidget.push_back(widget);

      widget->setToolTip(DTXTapp::InspectWfn::distrib_band_lower_bal);
      widget->setCheckable(DTXTapp::InspectWfn::distrib_band_lower_manual);
      widget->setExpert   (DTXTapp::InspectWfn::distrib_band_lower_expert);
      vgroup.push_back(widget);
    }

    // distrib_band_upper, spinbox
    {
      MyQSpinBoxGroup* widget = new MyQSpinBoxGroup
	("distrib_band_upper","upper:",
	 model.xtapp.inspectwfn.distrib_band_upper,
	 DTXTapp::InspectWfn::distrib_band_upper_min,
	 DTXTapp::InspectWfn::distrib_band_upper_max,
	 this, SLOT(edit(const MyEvent&)), ID_MISC );

      widget->setFixedWidth(250);
      layout->addWidget(widget);
      vwidget.push_back(widget);

      widget->setToolTip(DTXTapp::InspectWfn::distrib_band_upper_bal);
      widget->setCheckable(DTXTapp::InspectWfn::distrib_band_upper_manual);
      widget->setExpert   (DTXTapp::InspectWfn::distrib_band_upper_expert);
      vgroup.push_back(widget);
    }

    // distrib_number_sphere, spinbox
    {
      MyQSpinBoxGroup* widget = new MyQSpinBoxGroup
	("distrib_number_sphere","sphere:",
	 model.xtapp.inspectwfn.distrib_number_sphere,
	 DTXTapp::InspectWfn::distrib_number_sphere_min,
	 DTXTapp::InspectWfn::distrib_number_sphere_max,
	 this, SLOT(edit(const MyEvent&)), ID_MISC );
      widget->setFixedWidth(250);
      layout->addWidget(widget);
      vwidget.push_back(widget);

      widget->setToolTip(DTXTapp::InspectWfn::distrib_number_sphere_bal);
      widget->setCheckable(DTXTapp::InspectWfn::distrib_number_sphere_manual);
      widget->setExpert   (DTXTapp::InspectWfn::distrib_number_sphere_expert);
      vgroup.push_back(widget);

      group_sphere = widget;
    }

    // distrib_number_plate, spinbox
    {
      MyQSpinBoxGroup* widget = new MyQSpinBoxGroup
	("distrib_number_plate","plate:",
	 model.xtapp.inspectwfn.distrib_number_plate,
	 DTXTapp::InspectWfn::distrib_number_plate_min,
	 DTXTapp::InspectWfn::distrib_number_plate_max,
	 this, SLOT(edit(const MyEvent&)), ID_MISC );
      widget->setFixedWidth(250);
      layout->addWidget(widget);
      vwidget.push_back(widget);

      widget->setToolTip(DTXTapp::InspectWfn::distrib_number_plate_bal);
      widget->setCheckable(DTXTapp::InspectWfn::distrib_number_plate_manual);
      widget->setExpert   (DTXTapp::InspectWfn::distrib_number_plate_expert);
      vgroup.push_back(widget);

      group_plate = widget;
    }

    hlayout->addLayout(layout);
  }

  {
    QVBoxLayout* layout = new QVBoxLayout;

    // pdos_target_atom, spinbox
    {
      MyQSpinBoxGroup* widget = new MyQSpinBoxGroup
	("pdos_target_atom","atom:",
	 model.xtapp.inspectwfn.pdos_target_atom, 1, 1000,
	 this, SLOT(edit(const MyEvent&)), ID_MISC );
      widget->setFixedWidth(250);
      layout->addWidget(widget);

      widget->setToolTip(DTXTapp::InspectWfn::pdos_target_atom_bal);
      widget->setCheckable(DTXTapp::InspectWfn::pdos_target_atom_manual);
      widget->setExpert   (DTXTapp::InspectWfn::pdos_target_atom_expert);
      widget->setExpert(true);

      vwidget.push_back(widget);
      vgroup.push_back(widget);
      group_pdos = widget;
    }

    // iaxis, radio button
    {
      MyQGroupBox* widget = new MyQGroupBox("iaxis");
      QHBoxLayout* box = new QHBoxLayout;

      {
	MyQRadioButton* swidget = new MyQRadioButton
	  ( "x", model.xtapp.inspectwfn.iaxis, 1,
	    this, SLOT(edit(const MyEvent&)), ID_MISC );
	box->addWidget(swidget,Qt::AlignLeft);
	vwidget.push_back(swidget);
      }
      {
	MyQRadioButton* swidget = new MyQRadioButton
	  ( "y", model.xtapp.inspectwfn.iaxis, 2,
	    this, SLOT(edit(const MyEvent&)), ID_MISC );
	box->addWidget(swidget,Qt::AlignLeft);
	vwidget.push_back(swidget);
      }
      {
	MyQRadioButton* swidget = new MyQRadioButton
	  ( "z", model.xtapp.inspectwfn.iaxis, 3,
	    this, SLOT(edit(const MyEvent&)), ID_MISC );
	box->addWidget(swidget,Qt::AlignLeft);
	vwidget.push_back(swidget);
      }
      widget->setLayout(box);
      widget->setFixedWidth(250);
      layout->addWidget(widget);

      widget->setToolTip(DTXTapp::InspectWfn::iaxis_bal);
      widget->setCheckable(DTXTapp::InspectWfn::iaxis_manual);
      widget->setExpert   (DTXTapp::InspectWfn::iaxis_expert);
      widget->setExpert(true);
      vgroup.push_back(widget);

      group_iaxis = widget;
    }

    // rzero, lineedit
    {
      MyQGroupBox* widget = new MyQGroupBox("rzero");
      QGridLayout* box = new QGridLayout;
      int row=0,col=0;

      box->addWidget(new QLabel("x:"),row,col++);
      {
	MyQLineEdit* swidget = new MyQLineEdit
	  ( model.xtapp.inspectwfn.rzero.x,
	    DTXTapp::InspectWfn::rzero_min,
	    DTXTapp::InspectWfn::rzero_max,
	    this, SLOT(edit(const MyEvent&)), ID_MISC );
	swidget->setFixedWidth(80);
	box->addWidget(swidget,row,col++);
	vwidget.push_back(swidget);
      }
      row++,col=0;

      box->addWidget(new QLabel("y:"),row,col++);
      {
	MyQLineEdit* swidget = new MyQLineEdit
	  ( model.xtapp.inspectwfn.rzero.y,
	    DTXTapp::InspectWfn::rzero_min,
	    DTXTapp::InspectWfn::rzero_max,
	    this, SLOT(edit(const MyEvent&)), ID_MISC );
	swidget->setFixedWidth(80);
	box->addWidget(swidget,row,col++);
	vwidget.push_back(swidget);
      }
      row++,col=0;

      box->addWidget(new QLabel("z:"),row,col++);
      {
	MyQLineEdit* swidget = new MyQLineEdit
	  ( model.xtapp.inspectwfn.rzero.z,
	    DTXTapp::InspectWfn::rzero_min,
	    DTXTapp::InspectWfn::rzero_max,
	    this, SLOT(edit(const MyEvent&)), ID_MISC );
	swidget->setFixedWidth(80);
	box->addWidget(swidget,row,col++);
	vwidget.push_back(swidget);
      }
      row++,col=0;

      widget->setLayout(box);
      widget->setFixedWidth(250);
      layout->addWidget(widget);

      widget->setToolTip(DTXTapp::InspectWfn::rzero_bal);
      widget->setCheckable(DTXTapp::InspectWfn::rzero_manual);
      widget->setExpert   (DTXTapp::InspectWfn::rzero_expert);
      widget->setExpert(true);
      vgroup.push_back(widget);

      group_rzero = widget;
    }

    // rmin,rmax, lineedit
    {
      MyQGroupBox* widget = new MyQGroupBox("rmin,rmax");
      QGridLayout* box = new QGridLayout;
      int row=0,col=0;

      box->addWidget(new QLabel("rmin:"),row,col++);
      {
	MyQLineEdit* swidget = new MyQLineEdit
	  ( model.xtapp.inspectwfn.rmin,
	    DTXTapp::InspectWfn::rmin_min,
	    DTXTapp::InspectWfn::rmin_max,
	    this, SLOT(edit(const MyEvent&)), ID_MISC );
	swidget->setFixedWidth(80);
	box->addWidget(swidget,row,col++);
	vwidget.push_back(swidget);
      }
      row++,col=0;

      box->addWidget(new QLabel("rmax:"),row,col++);
      {
	MyQLineEdit* swidget = new MyQLineEdit
	  ( model.xtapp.inspectwfn.rmax,
	    DTXTapp::InspectWfn::rmin_min,
	    DTXTapp::InspectWfn::rmin_max,
	    this, SLOT(edit(const MyEvent&)), ID_MISC );
	swidget->setFixedWidth(80);
	box->addWidget(swidget,row,col++);
	vwidget.push_back(swidget);
      }
      row++,col=0;

      widget->setLayout(box);
      widget->setFixedWidth(250);
      layout->addWidget(widget);

      widget->setToolTip(DTXTapp::InspectWfn::rmin_bal);
      widget->setCheckable(DTXTapp::InspectWfn::rmin_manual);
      widget->setExpert   (DTXTapp::InspectWfn::rmin_expert);
      widget->setExpert(true);
      vgroup.push_back(widget);

      group_range = widget;
    }

    // ndiv, spinbox
    {
      MyQSpinBoxGroup* widget = new MyQSpinBoxGroup
	("ndiv","ndiv:",
	 model.xtapp.inspectwfn.ndiv,
	 DTXTapp::InspectWfn::ndiv_min,
	 DTXTapp::InspectWfn::ndiv_max,
	 this, SLOT(edit(const MyEvent&)), ID_MISC );
      widget->setFixedWidth(250);
      layout->addWidget(widget);
      vwidget.push_back(widget);

      widget->setToolTip(DTXTapp::InspectWfn::ndiv_bal);
      widget->setCheckable(DTXTapp::InspectWfn::ndiv_manual);
      widget->setExpert   (DTXTapp::InspectWfn::ndiv_expert);
      widget->setExpert(true);
      vgroup.push_back(widget);

      group_ndiv = widget;
    }

    hlayout->addLayout(layout);
  }

  setLayout(hlayout);
  updateExpert(false);
}

void QTXTappInspectWfn::edit( const MyEvent& ev )
{
  emit changed(MyEvent(id));
}

void QTXTappInspectWfn::updateExpert( const bool expert )
{
  const QString& mode = 
    model.xtapp.inspectwfn.vdistrib_mode
    [model.xtapp.inspectwfn.idistrib_mode];

  if( mode == "'none'" ){
    group_sphere->setEnabled(false);
    group_plate->setEnabled(false);
    group_pdos ->setEnabled(false);
    group_iaxis->setEnabled(false);
    group_rzero->setEnabled(false);
    group_range->setEnabled(false);
    group_ndiv ->setEnabled(false);
  }
  if( mode == "'pdos'" ){
    group_sphere->setEnabled(false);
    group_plate->setEnabled(false);
    group_pdos ->setEnabled(true);
    group_iaxis->setEnabled(false);
    group_rzero->setEnabled(false);
    group_range->setEnabled(false);
    group_ndiv ->setEnabled(false);
  }
  if( mode == "'sphere'" ){
    group_sphere->setEnabled(true);
    group_plate->setEnabled(false);
    group_pdos ->setEnabled(false);
    group_iaxis->setEnabled(false);
    group_rzero->setEnabled(true);
    group_range->setEnabled(true);
    group_ndiv ->setEnabled(true);
  }
  if( mode == "'plate'" ){
    group_sphere->setEnabled(false);
    group_plate->setEnabled(true);
    group_pdos ->setEnabled(false);
    group_iaxis->setEnabled(true);
    group_rzero->setEnabled(false);
    group_range->setEnabled(true);
    group_ndiv ->setEnabled(true);
  }

  MyQTab::updateExpert(expert);
}

//------------------------------------------------------------

QTXTappStmInput::QTXTappStmInput( DTModel& _model, const int id ) : MyQTab(id), model(_model)
{
  QVBoxLayout* layout = new QVBoxLayout(this);
  layout->setSizeConstraint( QLayout::SetFixedSize );

  // stm_fermi_energy, edit slider
  {
    MyQEditSliderGroup* widget = new MyQEditSliderGroup
      ( "stm_fermi_energy", "energy:", "a.u.", "low", "high",
	model.xtapp.stminput.stm_fermi_energy,
	DTXTapp::StmInput::stm_fermi_energy_min,
	DTXTapp::StmInput::stm_fermi_energy_max,
	this, SLOT(edit(const MyEvent&)), ID_MISC );
    widget->setFixedWidth(250);
    layout->addWidget(widget);
    vwidget.push_back(widget);

    widget->setToolTip(DTXTapp::StmInput::stm_fermi_energy_bal);
    widget->setCheckable(DTXTapp::StmInput::stm_fermi_energy_manual);
    widget->setExpert   (DTXTapp::StmInput::stm_fermi_energy_expert);
    vgroup.push_back(widget);
  }

  // vs
  {
    MyQGroupBox* group = new MyQGroupBox("vs");
    QGridLayout* grid = new QGridLayout;
    int row=0;

    {
      MyQSpinBoxGroup* widget = new MyQSpinBoxGroup
	("vs index to edit","vs No.",
	 model.xtapp.stminput.index_shown, 0, 0,
	 this, SLOT(edit(const MyEvent&)), ID_VS_INDEX );
      vwidget.push_back(widget);
      grid->addWidget(widget,row,0,1,4);
      spinbox_index = widget;
    }
    row++;

    grid->addWidget(new QLabel("vs:"),row,0);
    {
      MyQLineEdit* widget = new MyQLineEdit
	(
	 model.xtapp.stminput.vs_shown, 0, 100,
	 this, SLOT(edit(const MyEvent&)), ID_VS_VALUE );
      widget->setFixedWidth(100);
      grid->addWidget(widget,row,1);
      vwidget.push_back(widget);
    }
    row++;

    {
      MyQPushButton* widget = new MyQPushButton
	( "add vs", this, SLOT(edit(const MyEvent&)), ID_VS_ADD );
      widget->setFixedWidth(60);
      grid->addWidget(widget,row,1);
      vwidget.push_back(widget);
    }
    {
      MyQPushButton* widget = new MyQPushButton
	( "del vs", this, SLOT(edit(const MyEvent&)), ID_VS_DEL );
      widget->setFixedWidth(60);
      grid->addWidget(widget,row,2);
      vwidget.push_back(widget);
    }
    row++;
    group->setLayout(grid);
    layout->addWidget(group);

    group->setToolTip(DTXTapp::StmInput::vs_bal);
    group->setCheckable(DTXTapp::StmInput::vs_manual);
    group->setExpert   (DTXTapp::StmInput::vs_expert);
    group->setExpert(true);
    vgroup.push_back(group);
  }

  setLayout(layout);
  updateExpert(false);
}

void QTXTappStmInput::edit( const MyEvent& ev )
{
  switch(ev.id){
  case ID_VS_INDEX : {
    model.xtapp.stminput.update_shown();
  } break;
  case ID_VS_VALUE : {
    model.xtapp.stminput.change_shown();
  } break;
  case ID_VS_ADD : {
    model.xtapp.stminput.add();
  } break;
  case ID_VS_DEL : {
    model.xtapp.stminput.del();
  } break;

  default : break;
  }
  emit changed(MyEvent(id));
}

void QTXTappStmInput::updateExpert( const bool expert )
{
  model.xtapp.stminput.update_shown();
  spinbox_index->setRange( 1, model.xtapp.stminput.size_shown() );
  MyQTab::updateExpert(expert);
}

//------------------------------------------------------------

QTXTappMolDyn::QTXTappMolDyn( DTModel& _model, const int id ) : MyQTab(id), model(_model)
{
  QHBoxLayout* hlayout = new QHBoxLayout(this);
  hlayout->setSizeConstraint( QLayout::SetFixedSize );

  {
    QVBoxLayout* layout = new QVBoxLayout;

    // md_mode
    {
      MyQGroupBox* widget = new MyQGroupBox("md_mode");
      QHBoxLayout* box = new QHBoxLayout;

      box->addWidget(new QLabel("mode:"));
      {
	MyQComboBox* widget = new MyQComboBox
	  ( model.xtapp.moldyn.imd_mode, model.xtapp.moldyn.vmd_mode,
	    this, SLOT(edit(const MyEvent&)), ID_MISC );
	box->addWidget(widget);
	vwidget.push_back(widget);
      }

      widget->setLayout(box);
      widget->setFixedWidth(250);
      layout->addWidget(widget);

      widget->setToolTip(DTXTapp::MolDyn::md_mode_bal);
      widget->setCheckable(DTXTapp::MolDyn::md_mode_manual);
      widget->setExpert   (DTXTapp::MolDyn::md_mode_expert);
      vgroup.push_back(widget);
    }


    // delta_time, edit slider
    {
      MyQEditSliderGroup* widget = new MyQEditSliderGroup
	( "delta_time", "energy:", "a.u.", "low", "high",
	  model.xtapp.moldyn.delta_time,
	  DTXTapp::MolDyn::delta_time_min,
	  DTXTapp::MolDyn::delta_time_max,
	  this, SLOT(edit(const MyEvent&)), ID_MISC );
      widget->setFixedWidth(250);
      layout->addWidget(widget);
      vwidget.push_back(widget);

      widget->setToolTip(DTXTapp::MolDyn::delta_time_bal);
      widget->setCheckable(DTXTapp::MolDyn::delta_time_manual);
      widget->setExpert   (DTXTapp::MolDyn::delta_time_expert);
      vgroup.push_back(widget);
    }

    // init_md_step, spinbox
    {
      MyQSpinBoxGroup* widget = new MyQSpinBoxGroup
	("init_md_step","cycle:",
	 model.xtapp.moldyn.init_md_step,
	 DTXTapp::MolDyn::init_md_step_min,
	 DTXTapp::MolDyn::init_md_step_max,
	 this, SLOT(edit(const MyEvent&)), ID_MISC );
      widget->setFixedWidth(250);
      layout->addWidget(widget);
      vwidget.push_back(widget);

      widget->setToolTip(DTXTapp::MolDyn::init_md_step_bal);
      widget->setCheckable(DTXTapp::MolDyn::init_md_step_manual);
      widget->setExpert   (DTXTapp::MolDyn::init_md_step_expert);
      vgroup.push_back(widget);
    }

    // end_md_step, spinbox
    {
      MyQSpinBoxGroup* widget = new MyQSpinBoxGroup
	("end_md_step","cycle:",
	 model.xtapp.moldyn.end_md_step,
	 DTXTapp::MolDyn::end_md_step_min,
	 DTXTapp::MolDyn::end_md_step_max,
	 this, SLOT(edit(const MyEvent&)), ID_MISC );
      widget->setFixedWidth(250);
      layout->addWidget(widget);
      vwidget.push_back(widget);

      widget->setToolTip(DTXTapp::MolDyn::end_md_step_bal);
      widget->setCheckable(DTXTapp::MolDyn::end_md_step_manual);
      widget->setExpert   (DTXTapp::MolDyn::end_md_step_expert);
      vgroup.push_back(widget);
    }

    // mode_xtrap_rho_wfn, spinbox
    {
      MyQSpinBoxGroup* widget = new MyQSpinBoxGroup
	("mode_xtrap_rho_wfn","cycle:",
	 model.xtapp.moldyn.mode_xtrap_rho_wfn,
	 DTXTapp::MolDyn::mode_xtrap_rho_wfn_min,
	 DTXTapp::MolDyn::mode_xtrap_rho_wfn_max,
	 this, SLOT(edit(const MyEvent&)), ID_MISC );
      widget->setFixedWidth(250);
      layout->addWidget(widget);
      vwidget.push_back(widget);

      widget->setToolTip(DTXTapp::MolDyn::mode_xtrap_rho_wfn_bal);
      widget->setCheckable(DTXTapp::MolDyn::mode_xtrap_rho_wfn_manual);
      widget->setExpert   (DTXTapp::MolDyn::mode_xtrap_rho_wfn_expert);
      vgroup.push_back(widget);
    }

    // message_cycle, spinbox
    {
      MyQSpinBoxGroup* widget = new MyQSpinBoxGroup
	("message_cycle","cycle:",
	 model.xtapp.moldyn.message_cycle,
	 DTXTapp::MolDyn::message_cycle_min,
	 DTXTapp::MolDyn::message_cycle_max,
	 this, SLOT(edit(const MyEvent&)), ID_MISC );
      widget->setFixedWidth(250);
      layout->addWidget(widget);
      vwidget.push_back(widget);

      widget->setToolTip(DTXTapp::MolDyn::message_cycle_bal);
      widget->setCheckable(DTXTapp::MolDyn::message_cycle_manual);
      widget->setExpert   (DTXTapp::MolDyn::message_cycle_expert);
      vgroup.push_back(widget);
    }

    hlayout->addLayout(layout);
  }


  {
    QVBoxLayout* layout = new QVBoxLayout;

    // system_volume, edit slider
    {
      MyQEditSliderGroup* widget = new MyQEditSliderGroup
	( "system_volume", "energy:", "a.u.", "low", "high",
	  model.xtapp.moldyn.system_volume,
	  DTXTapp::MolDyn::system_volume_min,
	  DTXTapp::MolDyn::system_volume_max,
	  this, SLOT(edit(const MyEvent&)), ID_MISC );
      widget->setFixedWidth(250);
      layout->addWidget(widget);
      vwidget.push_back(widget);

      widget->setToolTip(DTXTapp::MolDyn::system_volume_bal);
      widget->setCheckable(DTXTapp::MolDyn::system_volume_manual);
      widget->setExpert   (DTXTapp::MolDyn::system_volume_expert);
      vgroup.push_back(widget);
    }

    // system_kbt, edit slider
    {
      MyQEditSliderGroup* widget = new MyQEditSliderGroup
	( "system_kbt", "energy:", "a.u.", "low", "high",
	  model.xtapp.moldyn.system_kbt,
	  DTXTapp::MolDyn::system_kbt_min,
	  DTXTapp::MolDyn::system_kbt_max,
	  this, SLOT(edit(const MyEvent&)), ID_MISC );
      widget->setFixedWidth(250);
      layout->addWidget(widget);
      vwidget.push_back(widget);

      widget->setToolTip(DTXTapp::MolDyn::system_kbt_bal);
      widget->setCheckable(DTXTapp::MolDyn::system_kbt_manual);
      widget->setExpert   (DTXTapp::MolDyn::system_kbt_expert);
      vgroup.push_back(widget);
    }

    // system_pressure, edit slider
    {
      MyQEditSliderGroup* widget = new MyQEditSliderGroup
	( "system_pressure", "energy:", "a.u.", "low", "high",
	  model.xtapp.moldyn.system_pressure,
	  DTXTapp::MolDyn::system_pressure_min,
	  DTXTapp::MolDyn::system_pressure_max,
	  this, SLOT(edit(const MyEvent&)), ID_MISC );
      widget->setFixedWidth(250);
      layout->addWidget(widget);
      vwidget.push_back(widget);

      widget->setToolTip(DTXTapp::MolDyn::system_pressure_bal);
      widget->setCheckable(DTXTapp::MolDyn::system_pressure_manual);
      widget->setExpert   (DTXTapp::MolDyn::system_pressure_expert);
      vgroup.push_back(widget);
    }

    hlayout->addLayout(layout);
  }

  {
    QVBoxLayout* layout = new QVBoxLayout;


    // stern_omega_zeta, edit slider
    {
      MyQEditSliderGroup* widget = new MyQEditSliderGroup
	( "stern_omega_zeta", "energy:", "a.u.", "low", "high",
	  model.xtapp.moldyn.stern_omega_zeta,
	  DTXTapp::MolDyn::stern_omega_zeta_min,
	  DTXTapp::MolDyn::stern_omega_zeta_max,
	  this, SLOT(edit(const MyEvent&)), ID_MISC );
      widget->setFixedWidth(250);
      layout->addWidget(widget);
      vwidget.push_back(widget);

      widget->setToolTip(DTXTapp::MolDyn::stern_omega_zeta_bal);
      widget->setCheckable(DTXTapp::MolDyn::stern_omega_zeta_manual);
      widget->setExpert   (DTXTapp::MolDyn::stern_omega_zeta_expert);
      vgroup.push_back(widget);
    }

    // stern_omega_eta, edit slider
    {
      MyQEditSliderGroup* widget = new MyQEditSliderGroup
	( "stern_omega_eta", "energy:", "a.u.", "low", "high",
	  model.xtapp.moldyn.stern_omega_eta,
	  DTXTapp::MolDyn::stern_omega_eta_min,
	  DTXTapp::MolDyn::stern_omega_eta_max,
	  this, SLOT(edit(const MyEvent&)), ID_MISC );
      widget->setFixedWidth(250);
      layout->addWidget(widget);
      vwidget.push_back(widget);

      widget->setToolTip(DTXTapp::MolDyn::stern_omega_eta_bal);
      widget->setCheckable(DTXTapp::MolDyn::stern_omega_eta_manual);
      widget->setExpert   (DTXTapp::MolDyn::stern_omega_eta_expert);
      vgroup.push_back(widget);
    }

    // stern_zeta, edit slider
    {
      MyQEditSliderGroup* widget = new MyQEditSliderGroup
	( "stern_zeta", "energy:", "a.u.", "low", "high",
	  model.xtapp.moldyn.stern_zeta,
	  DTXTapp::MolDyn::stern_zeta_min,
	  DTXTapp::MolDyn::stern_zeta_max,
	  this, SLOT(edit(const MyEvent&)), ID_MISC );
      widget->setFixedWidth(250);
      layout->addWidget(widget);
      vwidget.push_back(widget);

      widget->setToolTip(DTXTapp::MolDyn::stern_zeta_bal);
      widget->setCheckable(DTXTapp::MolDyn::stern_zeta_manual);
      widget->setExpert   (DTXTapp::MolDyn::stern_zeta_expert);
      vgroup.push_back(widget);
    }

    // stern_eta, edit slider
    {
      MyQEditSliderGroup* widget = new MyQEditSliderGroup
	( "stern_eta", "energy:", "a.u.", "low", "high",
	  model.xtapp.moldyn.stern_eta,
	  DTXTapp::MolDyn::stern_eta_min,
	  DTXTapp::MolDyn::stern_eta_max,
	  this, SLOT(edit(const MyEvent&)), ID_MISC );
      widget->setFixedWidth(250);
      layout->addWidget(widget);
      vwidget.push_back(widget);

      widget->setToolTip(DTXTapp::MolDyn::stern_eta_bal);
      widget->setCheckable(DTXTapp::MolDyn::stern_eta_manual);
      widget->setExpert   (DTXTapp::MolDyn::stern_eta_expert);
      vgroup.push_back(widget);
    }

    // stern_sigma, edit slider
    {
      MyQEditSliderGroup* widget = new MyQEditSliderGroup
	( "stern_sigma", "energy:", "a.u.", "low", "high",
	  model.xtapp.moldyn.stern_sigma,
	  DTXTapp::MolDyn::stern_sigma_min,
	  DTXTapp::MolDyn::stern_sigma_max,
	  this, SLOT(edit(const MyEvent&)), ID_MISC );
      widget->setFixedWidth(250);
      layout->addWidget(widget);
      vwidget.push_back(widget);

      widget->setToolTip(DTXTapp::MolDyn::stern_sigma_bal);
      widget->setCheckable(DTXTapp::MolDyn::stern_sigma_manual);
      widget->setExpert   (DTXTapp::MolDyn::stern_sigma_expert);
      vgroup.push_back(widget);
    }

    // abinitio_cycle, spinbox
    {
      MyQSpinBoxGroup* widget = new MyQSpinBoxGroup
	("abinitio_cycle","cycle:",
	 model.xtapp.moldyn.abinitio_cycle,
	 DTXTapp::MolDyn::abinitio_cycle_min,
	 DTXTapp::MolDyn::abinitio_cycle_max,
	 this, SLOT(edit(const MyEvent&)), ID_MISC );
      widget->setFixedWidth(250);
      layout->addWidget(widget);
      vwidget.push_back(widget);

      widget->setToolTip(DTXTapp::MolDyn::abinitio_cycle_bal);
      widget->setCheckable(DTXTapp::MolDyn::abinitio_cycle_manual);
      widget->setExpert   (DTXTapp::MolDyn::abinitio_cycle_expert);
      vgroup.push_back(widget);
    }

    hlayout->addLayout(layout);
  }


  setLayout(hlayout);
  updateExpert(false);
}

void QTXTappMolDyn::edit( const MyEvent& ev )
{
  emit changed(MyEvent(id));
}

void QTXTappMolDyn::updateExpert( const bool expert )
{
  MyQTab::updateExpert(expert);
}


//------------------------------------------------------------

QTXTappFilemap::QTXTappFilemap( DTModel& _model, const int id ) : MyQTab(id), model(_model)
{
  QVBoxLayout* layout = new QVBoxLayout(this);
  layout->setSizeConstraint( QLayout::SetFixedSize );

  // basename, lineedit
  {
    MyQGroupBox* widget = new MyQGroupBox("basename");

    QHBoxLayout* box = new QHBoxLayout;

    box->addWidget(new QLabel("name:"));
    {
      MyQLineEdit* swidget = new MyQLineEdit
	(
	 model.xtapp.filemap.basename,
	 this, SLOT(edit(const MyEvent&)), ID_BASENAME );
      box->addWidget(swidget);
      vwidget.push_back(swidget);
    }

    widget->setLayout(box);
    widget->setFixedWidth(250);
    layout->addWidget(widget);

    widget->setToolTip  (DTXTapp::Filemap::basename_bal);
    widget->setCheckable(DTXTapp::Filemap::basename_manual);
    widget->setExpert   (DTXTapp::Filemap::basename_expert);
    vgroup.push_back(widget);
  }

  // pseudo charge files, table
  {
    MyQGroupBox* widget = new MyQGroupBox("files for each element");
    QVBoxLayout* box  = new QVBoxLayout;

    // pseudo, charge
    table = new QTableWidget( 0, 2, this );
    table->setSelectionMode( QAbstractItemView::ExtendedSelection );
    table->setSelectionBehavior( QAbstractItemView::SelectRows );

    connect(table,SIGNAL(itemChanged(QTableWidgetItem*)),this,SLOT(itemEdited(QTableWidgetItem*)) );

    int row=0;
    table->setHorizontalHeaderItem(row,new QTableWidgetItem("pseudo"));
    table->setColumnWidth(row++,110);
    table->setHorizontalHeaderItem(row,new QTableWidgetItem("charge"));
    table->setColumnWidth(row++,110);
    box->addWidget(table);

    widget->setLayout(box);
    widget->setFixedWidth(250);
    layout->addWidget(widget);
    vgroup.push_back(widget);
  }

  setLayout(layout);
  updateExpert(false);
}

void QTXTappFilemap::edit( const MyEvent& ev )
{
  switch(ev.id){
  case ID_BASENAME : {
  } break;

  default : break;
  }
  emit changed(MyEvent(id));
}

void QTXTappFilemap::updateExpert( const bool expert )
{
  MyQTab::updateExpert(expert);

  const vector<DTElement>& velement
    = model.lattice.getData().velement;

  table->blockSignals(true);
  table->clearContents();
  table->setRowCount(velement.size());

  for( int e=0; e<(int)velement.size(); e++ ){
    int row=0;
    table->setItem(e,row++,new QTableWidgetItem); // pseudo
    table->setItem(e,row++,new QTableWidgetItem); // charge
  }
  for( int e=0; e<(int)velement.size(); e++ ){
    int row=0;

    {
      QTableWidgetItem* item = table->item(e,row++);
      item->setText( tr("%1").arg(velement[e].file_pseudo) );
    }
    {
      QTableWidgetItem* item = table->item(e,row++);
      item->setText( tr("%1").arg(velement[e].file_charge) );
    }
  }

  table->blockSignals(false);
}

void QTXTappFilemap::itemEdited( QTableWidgetItem* item )
{
  vector<DTElement>& velement
    = model.lattice.getData().velement;

  const int e = item->row();

  table->blockSignals(true);
  switch( item->column() ){
  case 0 : { // pseudo
    char filename[64];
    if( 1 == sscanf( qPrintable(item->text()), "%s", filename ) ){
      item->setText( tr("%1").arg(filename) );
      velement[e].file_pseudo = QString(filename);
    }
    else{
      item->setText( tr("%1").arg(velement[e].file_pseudo) );
    }
  } break;
  case 1 : { // charge
    char filename[64];
    if( 1 == sscanf( qPrintable(item->text()), "%s", filename ) ){
      item->setText( tr("%1").arg(filename) );
      velement[e].file_charge = QString(filename);
    }
    else{
      item->setText( tr("%1").arg(velement[e].file_charge) );
    }
  } break;
  }
  table->blockSignals(false);
}

//------------------------------------------------------------

QTXTapp::QTXTapp( DTModel& _model, const int _id ) :
  model(_model), id(_id)
{
  QVBoxLayout* layout = new QVBoxLayout(this);
  layout->setSizeConstraint( QLayout::SetFixedSize );

  setFixedSize(380,500);
  setWindowTitle("xTAPP settings");

  {
    QTabWidget* group = new QTabWidget;
    {
      QTXTappTappInput1* widget = new QTXTappTappInput1( model, ID_TAPPINPUT );
      group->addTab(widget, "TappInput1");
      vwidget.push_back(widget);
      connect(widget, SIGNAL(changed(const MyEvent&)), this, SLOT(edit(const MyEvent&)) );
    }
    {
      QTXTappTappInput2* widget = new QTXTappTappInput2( model, ID_TAPPINPUT );
      group->addTab(widget, "TappInput2");
      vwidget.push_back(widget);
      connect(widget, SIGNAL(changed(const MyEvent&)), this, SLOT(edit(const MyEvent&)) );
    }
    {
      QTXTappSmplKpt* widget = new QTXTappSmplKpt( model, ID_SMPLKPT );
      group->addTab(widget, "SmplKpt");
      vwidget.push_back(widget);
      connect(widget, SIGNAL(changed(const MyEvent&)), this, SLOT(edit(const MyEvent&)) );
    }
    {
      QTXTappStructOpt* widget = new QTXTappStructOpt( model, ID_STRUCTOPT );
      group->addTab(widget, "StructOpt");
      vwidget.push_back(widget);
      connect(widget, SIGNAL(changed(const MyEvent&)), this, SLOT(edit(const MyEvent&)) );
    }
    {
      QTXTappStrOptConstr* widget = new QTXTappStrOptConstr( model, ID_STROPTCONSTR );
      group->addTab(widget, "StrOptConstr");
      vwidget.push_back(widget);
      connect(widget, SIGNAL(changed(const MyEvent&)), this, SLOT(edit(const MyEvent&)) );
    }
    {
      QTXTappTraceBand* widget = new QTXTappTraceBand( model, ID_TRACEBAND );
      group->addTab(widget, "TraceBand");
      vwidget.push_back(widget);
      connect(widget, SIGNAL(changed(const MyEvent&)), this, SLOT(edit(const MyEvent&)) );
    }
    {
      QTXTappInspectWfn* widget = new QTXTappInspectWfn( model, ID_INSPECTWFN );
      group->addTab(widget, "InspectWfn");
      vwidget.push_back(widget);
      connect(widget, SIGNAL(changed(const MyEvent&)), this, SLOT(edit(const MyEvent&)) );
    }
    {
      QTXTappStmInput* widget = new QTXTappStmInput( model, ID_STMINPUT );
      group->addTab(widget, "StmInput");
      vwidget.push_back(widget);
      connect(widget, SIGNAL(changed(const MyEvent&)), this, SLOT(edit(const MyEvent&)) );
    }
    {
      QTXTappMolDyn* widget = new QTXTappMolDyn( model, ID_MOLDYN );
      group->addTab(widget, "MolDyn");
      vwidget.push_back(widget);
      connect(widget, SIGNAL(changed(const MyEvent&)), this, SLOT(edit(const MyEvent&)) );
    }
    {
      QTXTappFilemap* widget = new QTXTappFilemap( model, ID_FILEMAP );
      group->addTab(widget, "Filemap");
      vwidget.push_back(widget);
      connect(widget, SIGNAL(changed(const MyEvent&)), this, SLOT(edit(const MyEvent&)) );
    }
    layout->addWidget(group);
  }

  QHBoxLayout* box = new QHBoxLayout;
  {
    MyQPushButton* widget = new MyQPushButton
      ( "close", this, SLOT(edit(const MyEvent&)), ID_CLOSE );
    box->addWidget( widget );
  }
  {
    MyQPushButton* widget = new MyQPushButton
      ( "undo", this, SLOT(edit(const MyEvent&)), ID_UNDO );
    box->addWidget( widget );
  }
  {
    expert = false;
    MyQToggleButton* widget = new MyQToggleButton
      ( "expert", expert, this, SLOT(edit(const MyEvent&)), ID_EXPERT );
    box->addWidget( widget );
  }

  layout->addLayout(box);

  setLayout(layout);
}

void QTXTapp::edit( const MyEvent& ev )
{
  switch(ev.id){
  case ID_TAPPINPUT :
  case ID_SMPLKPT   :
  case ID_STRUCTOPT :
  case ID_STROPTCONSTR :
  case ID_TRACEBAND :
  case ID_INSPECTWFN :
  case ID_STMINPUT :
  case ID_MOLDYN :{
    emit changed();
  } break;

  case ID_CLOSE : {
    hide();
  } break;
  case ID_UNDO : {
    model.undo();
  } break;
  case ID_EXPERT : {
    update();
  } break;
  default: break;
  }
}

void QTXTapp::update( void )
{
  for( int i=0; i<(int)vwidget.size(); i++ ){
    vwidget[i]->updateExpert(expert);
  }
}
