/*
 Copyright (c) 2014 Shinji Tsuneyuki
 This file is distributed under the terms of the GNU General Public License version 3.
 */

/*!
 \file qtxtapp.h
 \brief xTAPP̐ݒGUI\̃NX
*/

#ifndef __QTXTAPP_H_INCLUDED
#define __QTXTAPP_H_INCLUDED

#include "qtwidgets.h"
#include <QtGui/QTableWidget>

class DTModel;

class QTXTappTappInput1 : public MyQTab
{
  Q_OBJECT

private:
  DTModel& model;

  enum { ID_MISC };

public:
  QTXTappTappInput1( DTModel& _model, const int id );
signals:
  void changed(const MyEvent&);
public slots:
  void updateExpert( const bool expert );
private slots:
  void edit( const MyEvent& ev );
};

class QTXTappTappInput2 : public MyQTab
{
  Q_OBJECT

private:
  DTModel& model;

  enum { ID_MISC };

public:
  QTXTappTappInput2( DTModel& _model, const int id );
signals:
  void changed(const MyEvent&);
public slots:
  void updateExpert( const bool expert );
private slots:
  void edit( const MyEvent& ev );
};
/*
class QTXTappSymmetry : public MyQTab
{
  Q_OBJECT

private:
  DTModel& model;

  enum { ID_MISC };

public:
  QTXTappSymmetry( DTModel& _model, const int id );
signals:
  void changed(const MyEvent&);
public slots:
  void updateExpert( const bool expert );
private slots:
  void edit( const MyEvent& ev );
};
*/
/*
class QTXTappAtoms : public MyQTab
{
  Q_OBJECT

private:
  DTModel& model;

  enum { ID_MISC };

public:
  QTXTappAtoms( DTModel& _model, const int id );
signals:
  void changed(const MyEvent&);
public slots:
  void updateExpert( const bool expert );
private slots:
  void edit( const MyEvent& ev );
};
*/

class QTXTappSmplKpt : public MyQTab
{
  Q_OBJECT

private:
  DTModel& model;
  MyQSpinBoxGroup* spinbox_mmm_index;
  MyQSpinBoxGroup* spinbox_rmesh_number_shell;
  MyQSpinBoxGroup* spinbox_rmesh_range;

  enum { ID_MISC, ID_OUTLINE, ID_DETAIL_INDEX, ID_DETAIL_VALUE,
	 ID_DETAIL_ADD, ID_DETAIL_DEL };

public:
  QTXTappSmplKpt( DTModel& _model, const int id );
signals:
  void changed(const MyEvent&);
public slots:
  void updateExpert( const bool expert );
private slots:
  void edit( const MyEvent& ev );
};


class QTXTappStructOpt : public MyQTab
{
  Q_OBJECT

private:
  DTModel& model;

  enum { ID_MISC };

public:
  QTXTappStructOpt( DTModel& _model, const int id );
signals:
  void changed(const MyEvent&);
public slots:
  void updateExpert( const bool expert );
private slots:
  void edit( const MyEvent& ev );
};


class QTXTappStrOptConstr : public MyQTab
{
  Q_OBJECT

private:
  DTModel& model;

  MyQGroupBox* group_tim;
  MyQGroupBox* group_set;
  MyQSpinBoxGroup* spinbox_tim_index;
  MyQSpinBoxGroup* spinbox_set_index;
  MyQLabel* label_tim_size;
  MyQLabel* label_set_size;

  enum { ID_MISC,
	 ID_TIM_INDEX, ID_TIM_VALUE, ID_TIM_ADD, ID_TIM_DEL,
	 ID_SET_INDEX, ID_SET_VALUE, ID_SET_ADD, ID_SET_DEL };

public:
  QTXTappStrOptConstr( DTModel& _model, const int id );
signals:
  void changed(const MyEvent&);
public slots:
  void updateExpert( const bool expert );
private slots:
  void edit( const MyEvent& ev );
};

class QTXTappTraceBand : public MyQTab
{
  Q_OBJECT

private:
  DTModel& model;
  MyQGroupBox* group_sphere;
  MyQGroupBox* group_plate;
  MyQGroupBox* group_iaxis;
  MyQGroupBox* group_rzero;
  MyQGroupBox* group_range;
  MyQGroupBox* group_ndiv;

  MyQLabel*   label_size;
  MyQSpinBoxGroup* spinbox_index;
  enum { ID_MISC };
  //DEBUG
  // ID_KPOINT_INDEX, ID_KPOINT_VALUE, ID_KPOINT_ADD, ID_KPOINT_DEL };

public:
  QTXTappTraceBand( DTModel& _model, const int id );
signals:
  void changed(const MyEvent&);
public slots:
  void updateExpert( const bool expert );
private slots:
  void edit( const MyEvent& ev );
};

class QTXTappInspectWfn : public MyQTab
{
  Q_OBJECT

private:
  DTModel& model;
  MyQGroupBox* group_sphere;
  MyQGroupBox* group_plate;
  MyQGroupBox* group_pdos;
  MyQGroupBox* group_iaxis;
  MyQGroupBox* group_rzero;
  MyQGroupBox* group_range;
  MyQGroupBox* group_ndiv;

  enum { ID_MISC };

public:
  QTXTappInspectWfn( DTModel& _model, const int id );
signals:
  void changed(const MyEvent&);
public slots:
  void updateExpert( const bool expert );
private slots:
  void edit( const MyEvent& ev );
};

class QTXTappStmInput : public MyQTab
{
  Q_OBJECT

private:
  DTModel& model;
  MyQLabel*   label_size;
  MyQSpinBoxGroup* spinbox_index;
  enum { ID_MISC, ID_VS_INDEX, ID_VS_VALUE, ID_VS_ADD, ID_VS_DEL };

public:
  QTXTappStmInput( DTModel& _model, const int id );
signals:
  void changed(const MyEvent&);
public slots:
  void updateExpert( const bool expert );
private slots:
  void edit( const MyEvent& ev );
};


class QTXTappMolDyn : public MyQTab
{
  Q_OBJECT

private:
  DTModel& model;
  enum { ID_MISC };

public:
  QTXTappMolDyn( DTModel& _model, const int id );
signals:
  void changed(const MyEvent&);
public slots:
  void updateExpert( const bool expert );
private slots:
  void edit( const MyEvent& ev );
};


class QTXTappFilemap : public MyQTab
{
  Q_OBJECT

private:
  DTModel& model;
  enum { ID_BASENAME, ID_PSEUDO };

  QTableWidget* table;

public:
  QTXTappFilemap( DTModel& _model, const int id );
signals:
  void changed(const MyEvent&);
public slots:
  void updateExpert( const bool expert );
  void itemEdited( QTableWidgetItem* item );
private slots:
  void edit( const MyEvent& ev );
};

class QTXTapp : public QWidget
{
  Q_OBJECT

private:
  DTModel& model;
  const int id;

  enum { ID_TAPPINPUT, ID_SYMMETRY, //ID_ATOMS,
	 ID_SMPLKPT, ID_STRUCTOPT,
	 ID_STROPTCONSTR, ID_TRACEBAND, ID_INSPECTWFN,
	 ID_STMINPUT, ID_MOLDYN, ID_FILEMAP,
	 ID_CLOSE, ID_UNDO, ID_EXPERT };

  vector<MyQTab*> vwidget;
  bool expert;

public:
  QTXTapp( DTModel& _model, const int id );
signals:
  void changed( void );
public slots:
  void update( void );
private slots:
  void edit( const MyEvent& ev );
};

#endif // __QTXTAPP_H_INCLUDED
