/*
 Copyright (c) 2014 Shinji Tsuneyuki
 This file is distributed under the terms of the GNU General Public License version 3.
 */

#ifndef __SPACEGROUP_H_INCLUDED
#define __SPACEGROUP_H_INCLUDED

#include <QtCore/QString>

struct SpaceGroup {
  int    number;
  QString nameHM; // for example, "Fd-3m"
  QString shape; // for example, "cubic"
  QString center; // for example, "face"
  QString paxis; // for example, "C"

  SpaceGroup( void ){}
  SpaceGroup( const int number,
	      const QString& nameHM, 
	      const QString& shape,
	      const QString& center,
	      const QString& paxis ){
    this->number = number;
    this->nameHM = nameHM;
    this->shape  = shape;
    this->center = center;
    this->paxis  = paxis;
  }
};

// data obtained from http://www.sci.hokudai.ac.jp/mineral/
struct SpaceGroupTable
{
  vector<SpaceGroup> vspacegroup;
  SpaceGroupTable( void ){
     vspacegroup.push_back( SpaceGroup(   1,  "P1", "triclinic", "simple", "none" ) );
     vspacegroup.push_back( SpaceGroup(   2,  "P-1", "triclinic", "simple", "none" ) );
     vspacegroup.push_back( SpaceGroup(   3,  "P2=P121", "monoclinic", "simple", "none" ) );
     vspacegroup.push_back( SpaceGroup(   3,  "P2=P112", "monoclinic", "simple", "none" ) );
     vspacegroup.push_back( SpaceGroup(   3,  "P2=P211", "monoclinic", "simple", "none" ) );
     vspacegroup.push_back( SpaceGroup(   4,  "P21=P1211", "monoclinic", "simple", "none" ) );
     vspacegroup.push_back( SpaceGroup(   4,  "P21=P1121", "monoclinic", "simple", "none" ) );
     vspacegroup.push_back( SpaceGroup(   4,  "P21=P2111", "monoclinic", "simple", "none" ) );
     vspacegroup.push_back( SpaceGroup(   5,  "C2=C121", "monoclinic", "base", "C" ) );
     vspacegroup.push_back( SpaceGroup(   5,  "C2=A121", "monoclinic", "base", "C" ) );
     vspacegroup.push_back( SpaceGroup(   5,  "C2=I121", "monoclinic", "base", "C" ) );
     vspacegroup.push_back( SpaceGroup(   5,  "C2=A112", "monoclinic", "base", "C" ) );
     vspacegroup.push_back( SpaceGroup(   5,  "C2=B112=B2", "monoclinic", "base", "C" ) );
     vspacegroup.push_back( SpaceGroup(   5,  "C2=I112", "monoclinic", "base", "C" ) );
     vspacegroup.push_back( SpaceGroup(   5,  "C2=B211", "monoclinic", "base", "C" ) );
     vspacegroup.push_back( SpaceGroup(   5,  "C2=C211", "monoclinic", "base", "C" ) );
     vspacegroup.push_back( SpaceGroup(   5,  "C2=I211", "monoclinic", "base", "C" ) );
     vspacegroup.push_back( SpaceGroup(   6,  "Pm=P1m1", "monoclinic", "simple", "none" ) );
     vspacegroup.push_back( SpaceGroup(   6,  "Pm=P11m", "monoclinic", "simple", "none" ) );
     vspacegroup.push_back( SpaceGroup(   6,  "Pm=Pm11", "monoclinic", "simple", "none" ) );
     vspacegroup.push_back( SpaceGroup(   7,  "Pc=P1c1", "monoclinic", "simple", "none" ) );
     vspacegroup.push_back( SpaceGroup(   7,  "Pc=P1n1", "monoclinic", "simple", "none" ) );
     vspacegroup.push_back( SpaceGroup(   7,  "Pc=P1a1", "monoclinic", "simple", "none" ) );
     vspacegroup.push_back( SpaceGroup(   7,  "Pc=P11a", "monoclinic", "simple", "none" ) );
     vspacegroup.push_back( SpaceGroup(   7,  "Pc=P11n", "monoclinic", "simple", "none" ) );
     vspacegroup.push_back( SpaceGroup(   7,  "Pc=P11b=Pb", "monoclinic", "simple", "none" ) );
     vspacegroup.push_back( SpaceGroup(   7,  "Pc=Pb11", "monoclinic", "simple", "none" ) );
     vspacegroup.push_back( SpaceGroup(   7,  "Pc=Pn11", "monoclinic", "simple", "none" ) );
     vspacegroup.push_back( SpaceGroup(   7,  "Pc=Pc11", "monoclinic", "simple", "none" ) );
     vspacegroup.push_back( SpaceGroup(   8,  "Cm=C1m1", "monoclinic", "base", "C" ) );
     vspacegroup.push_back( SpaceGroup(   8,  "Cm=A1m1", "monoclinic", "base", "C" ) );
     vspacegroup.push_back( SpaceGroup(   8,  "Cm=I1m1", "monoclinic", "base", "C" ) );
     vspacegroup.push_back( SpaceGroup(   8,  "Cm=A11m", "monoclinic", "base", "C" ) );
     vspacegroup.push_back( SpaceGroup(   8,  "Cm=B11m=Bm", "monoclinic", "base", "C" ) );
     vspacegroup.push_back( SpaceGroup(   8,  "Cm=I11m", "monoclinic", "base", "C" ) );
     vspacegroup.push_back( SpaceGroup(   8,  "Cm=Bm11", "monoclinic", "base", "C" ) );
     vspacegroup.push_back( SpaceGroup(   8,  "Cm=Cm11", "monoclinic", "base", "C" ) );
     vspacegroup.push_back( SpaceGroup(   8,  "Cm=Im11", "monoclinic", "base", "C" ) );
     vspacegroup.push_back( SpaceGroup(   9,  "Cc=C1c1", "monoclinic", "base", "C" ) );
     vspacegroup.push_back( SpaceGroup(   9,  "Cc=A1n1", "monoclinic", "base", "C" ) );
     vspacegroup.push_back( SpaceGroup(   9,  "Cc=I1a1", "monoclinic", "base", "C" ) );
     vspacegroup.push_back( SpaceGroup(   9,  "Cc=A1a1", "monoclinic", "base", "C" ) );
     vspacegroup.push_back( SpaceGroup(   9,  "Cc=C1n1", "monoclinic", "base", "C" ) );
     vspacegroup.push_back( SpaceGroup(   9,  "Cc=I1c1", "monoclinic", "base", "C" ) );
     vspacegroup.push_back( SpaceGroup(   9,  "Cc=A11a", "monoclinic", "base", "C" ) );
     vspacegroup.push_back( SpaceGroup(   9,  "Cc=B11n", "monoclinic", "base", "C" ) );
     vspacegroup.push_back( SpaceGroup(   9,  "Cc=I11b", "monoclinic", "base", "C" ) );
     vspacegroup.push_back( SpaceGroup(   9,  "Cc=B11b=Bb", "monoclinic", "base", "C" ) );
     vspacegroup.push_back( SpaceGroup(   9,  "Cc=A11n", "monoclinic", "base", "C" ) );
     vspacegroup.push_back( SpaceGroup(   9,  "Cc=I11a", "monoclinic", "base", "C" ) );
     vspacegroup.push_back( SpaceGroup(   9,  "Cc=Bb11", "monoclinic", "base", "C" ) );
     vspacegroup.push_back( SpaceGroup(   9,  "Cc=Cn11", "monoclinic", "base", "C" ) );
     vspacegroup.push_back( SpaceGroup(   9,  "Cc=Ic11", "monoclinic", "base", "C" ) );
     vspacegroup.push_back( SpaceGroup(   9,  "Cc=Cc11", "monoclinic", "base", "C" ) );
     vspacegroup.push_back( SpaceGroup(   9,  "Cc=Bn11", "monoclinic", "base", "C" ) );
     vspacegroup.push_back( SpaceGroup(   9,  "Cc=Ib11", "monoclinic", "base", "C" ) );
     vspacegroup.push_back( SpaceGroup(  10,  "P2/m=P12/m1", "monoclinic", "simple", "none" ) );
     vspacegroup.push_back( SpaceGroup(  10,  "P2/m=P112/m", "monoclinic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  10,  "P2/m=P2/m11", "monoclinic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  11,  "P21/m=P121/m1", "monoclinic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  11,  "P21/m=P1121/m", "monoclinic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  11,  "P21/m=P21/m11", "monoclinic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  12,  "C2/m=C12/m1", "monoclinic", "base", "C" ) );
      vspacegroup.push_back( SpaceGroup(  12,  "C2/m=A12/m1", "monoclinic", "base", "C" ) );
      vspacegroup.push_back( SpaceGroup(  12,  "C2/m=I12/m1", "monoclinic", "base", "C" ) );
      vspacegroup.push_back( SpaceGroup(  12,  "C2/m=A112/m", "monoclinic", "base", "C" ) );
      vspacegroup.push_back( SpaceGroup(  12,  "C2/m=B112/m=B2/m", "monoclinic", "base", "C" ) );
      vspacegroup.push_back( SpaceGroup(  12,  "C2/m=I112/m", "monoclinic", "base", "C" ) );
      vspacegroup.push_back( SpaceGroup(  12,  "C2/m=B2/m11", "monoclinic", "base", "C" ) );
      vspacegroup.push_back( SpaceGroup(  12,  "C2/m=C2/m11", "monoclinic", "base", "C" ) );
      vspacegroup.push_back( SpaceGroup(  12,  "C2/m=I2/m11", "monoclinic", "base", "C" ) );
      vspacegroup.push_back( SpaceGroup(  13,  "P2/c=P12/c1", "monoclinic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  13,  "P2/c=P12/n1", "monoclinic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  13,  "P2/c=P12/a1", "monoclinic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  13,  "P2/c=P112/a", "monoclinic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  13,  "P2/c=P112/n", "monoclinic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  13,  "P2/c=P112/b=P2/b", "monoclinic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  13,  "P2/c=P2/b11", "monoclinic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  13,  "P2/c=P2/n11", "monoclinic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  13,  "P2/c=P2/c11", "monoclinic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  14,  "P21/c=P121/c1", "monoclinic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  14,  "P21/c=P121/n1", "monoclinic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  14,  "P21/c=P121/a1", "monoclinic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  14,  "P21/c=P1121/a", "monoclinic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  14,  "P21/c=P1121/n", "monoclinic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  14,  "P21/c=P1121/b=P21/b", "monoclinic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  14,  "P21/c=P21/b11", "monoclinic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  14,  "P21/c=P21/n11", "monoclinic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  14,  "P21/c=P21/c11", "monoclinic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  15,  "C2/c=C12/c1", "monoclinic", "base", "C" ) );
      vspacegroup.push_back( SpaceGroup(  15,  "C2/c=A12/n1", "monoclinic", "base", "C" ) );
      vspacegroup.push_back( SpaceGroup(  15,  "C2/c=I12/a1", "monoclinic", "base", "C" ) );
      vspacegroup.push_back( SpaceGroup(  15,  "C2/c=A12/a1", "monoclinic", "base", "C" ) );
      vspacegroup.push_back( SpaceGroup(  15,  "C2/c=C12/n1", "monoclinic", "base", "C" ) );
      vspacegroup.push_back( SpaceGroup(  15,  "C2/c=I12/c1", "monoclinic", "base", "C" ) );
      vspacegroup.push_back( SpaceGroup(  15,  "C2/c=A112/a", "monoclinic", "base", "C" ) );
      vspacegroup.push_back( SpaceGroup(  15,  "C2/c=B112/n", "monoclinic", "base", "C" ) );
      vspacegroup.push_back( SpaceGroup(  15,  "C2/c=I112/b", "monoclinic", "base", "C" ) );
      vspacegroup.push_back( SpaceGroup(  15,  "C2/c=B112/b=B2/b", "monoclinic", "base", "C" ) );
      vspacegroup.push_back( SpaceGroup(  15,  "C2/c=A112/n", "monoclinic", "base", "C" ) );
      vspacegroup.push_back( SpaceGroup(  15,  "C2/c=I112/a", "monoclinic", "base", "C" ) );
      vspacegroup.push_back( SpaceGroup(  15,  "C2/c=B2/b11", "monoclinic", "base", "C" ) );
      vspacegroup.push_back( SpaceGroup(  15,  "C2/c=C2/n11", "monoclinic", "base", "C" ) );
      vspacegroup.push_back( SpaceGroup(  15,  "C2/c=I2/c11", "monoclinic", "base", "C" ) );
      vspacegroup.push_back( SpaceGroup(  15,  "C2/c=C2/c11", "monoclinic", "base", "C" ) );
      vspacegroup.push_back( SpaceGroup(  15,  "C2/c=B2/n11", "monoclinic", "base", "C" ) );
      vspacegroup.push_back( SpaceGroup(  15,  "C2/c=I2/b11", "monoclinic", "base", "C" ) );
      vspacegroup.push_back( SpaceGroup(  16,  "P222", "orthorhombic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  17,  "P2221", "orthorhombic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  17,  "P2122", "orthorhombic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  17,  "P2212", "orthorhombic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  18,  "P21212", "orthorhombic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  18,  "P22121", "orthorhombic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  18,  "P21221", "orthorhombic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  19,  "P212121", "orthorhombic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  20,  "C2221", "orthorhombic", "base", "C" ) );
      vspacegroup.push_back( SpaceGroup(  20,  "A2122", "orthorhombic", "base", "A" ) );
      vspacegroup.push_back( SpaceGroup(  20,  "B2212", "orthorhombic", "base", "B" ) );
      vspacegroup.push_back( SpaceGroup(  21,  "C222", "orthorhombic", "base", "C" ) );
      vspacegroup.push_back( SpaceGroup(  21,  "A222", "orthorhombic", "base", "A" ) );
      vspacegroup.push_back( SpaceGroup(  21,  "B222", "orthorhombic", "base", "B" ) );
      vspacegroup.push_back( SpaceGroup(  22,  "F222", "orthorhombic", "face", "none" ) );
      vspacegroup.push_back( SpaceGroup(  23,  "I222", "orthorhombic", "body", "none" ) );
      vspacegroup.push_back( SpaceGroup(  24,  "I212121", "orthorhombic", "body", "none" ) );
      vspacegroup.push_back( SpaceGroup(  25,  "Pmm2", "orthorhombic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  25,  "P2mm", "orthorhombic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  25,  "Pm2m", "orthorhombic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  26,  "Pmc21", "orthorhombic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  26,  "Pcm21", "orthorhombic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  26,  "P21ma", "orthorhombic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  26,  "P21am", "orthorhombic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  26,  "Pb21m", "orthorhombic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  26,  "Pm21b", "orthorhombic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  27,  "Pcc2", "orthorhombic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  27,  "P2aa", "orthorhombic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  27,  "Pb2b", "orthorhombic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  28,  "Pma2", "orthorhombic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  28,  "Pbm2", "orthorhombic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  28,  "P2mb", "orthorhombic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  28,  "P2cm", "orthorhombic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  28,  "Pc2m", "orthorhombic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  28,  "Pm2a", "orthorhombic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  29,  "Pca21", "orthorhombic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  29,  "Pbc21", "orthorhombic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  29,  "P21ab", "orthorhombic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  29,  "P21ca", "orthorhombic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  29,  "Pc21b", "orthorhombic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  29,  "Pb21a", "orthorhombic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  30,  "Pnc2", "orthorhombic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  30,  "Pcn2", "orthorhombic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  30,  "P2na", "orthorhombic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  30,  "P2an", "orthorhombic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  30,  "Pb2n", "orthorhombic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  30,  "Pn2b", "orthorhombic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  31,  "Pmn21", "orthorhombic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  31,  "Pnm21", "orthorhombic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  31,  "P21mn", "orthorhombic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  31,  "P21nm", "orthorhombic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  31,  "Pn21m", "orthorhombic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  31,  "Pm21n", "orthorhombic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  32,  "Pba2", "orthorhombic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  32,  "P2cb", "orthorhombic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  32,  "Pc2a", "orthorhombic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  33,  "Pna21", "orthorhombic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  33,  "Pbn21", "orthorhombic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  33,  "P21nb", "orthorhombic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  33,  "P21cn", "orthorhombic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  33,  "Pc21n", "orthorhombic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  33,  "Pn21a", "orthorhombic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  34,  "Pnn2", "orthorhombic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  34,  "P2nn", "orthorhombic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  34,  "Pn2n", "orthorhombic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  35,  "Cmm2", "orthorhombic", "base", "C" ) );
      vspacegroup.push_back( SpaceGroup(  35,  "A2mm", "orthorhombic", "base", "A" ) );
      vspacegroup.push_back( SpaceGroup(  35,  "Bm2m", "orthorhombic", "base", "B" ) );
      vspacegroup.push_back( SpaceGroup(  36,  "Cmc21", "orthorhombic", "base", "C" ) );
      vspacegroup.push_back( SpaceGroup(  36,  "Ccm21", "orthorhombic", "base", "C" ) );
      vspacegroup.push_back( SpaceGroup(  36,  "A21ma", "orthorhombic", "base", "A" ) );
      vspacegroup.push_back( SpaceGroup(  36,  "A21am", "orthorhombic", "base", "A" ) );
      vspacegroup.push_back( SpaceGroup(  36,  "Bb21m", "orthorhombic", "base", "B" ) );
      vspacegroup.push_back( SpaceGroup(  36,  "Bm21b", "orthorhombic", "base", "B" ) );
      vspacegroup.push_back( SpaceGroup(  37,  "Ccc2", "orthorhombic", "base", "C" ) );
      vspacegroup.push_back( SpaceGroup(  37,  "A2aa", "orthorhombic", "base", "A" ) );
      vspacegroup.push_back( SpaceGroup(  37,  "Bb2b", "orthorhombic", "base", "B" ) );
      vspacegroup.push_back( SpaceGroup(  38,  "Amm2", "orthorhombic", "base", "A" ) );
      vspacegroup.push_back( SpaceGroup(  38,  "Bmm2", "orthorhombic", "base", "B" ) );
      vspacegroup.push_back( SpaceGroup(  38,  "B2mm", "orthorhombic", "base", "B" ) );
      vspacegroup.push_back( SpaceGroup(  38,  "C2mm", "orthorhombic", "base", "C" ) );
      vspacegroup.push_back( SpaceGroup(  38,  "Cm2m", "orthorhombic", "base", "C" ) );
      vspacegroup.push_back( SpaceGroup(  38,  "Am2m", "orthorhombic", "base", "A" ) );
      vspacegroup.push_back( SpaceGroup(  39,  "Abm2", "orthorhombic", "base", "A" ) );
      vspacegroup.push_back( SpaceGroup(  39,  "Bma2", "orthorhombic", "base", "B" ) );
      vspacegroup.push_back( SpaceGroup(  39,  "B2cm", "orthorhombic", "base", "B" ) );
      vspacegroup.push_back( SpaceGroup(  39,  "C2mb", "orthorhombic", "base", "C" ) );
      vspacegroup.push_back( SpaceGroup(  39,  "Cm2a", "orthorhombic", "base", "C" ) );
      vspacegroup.push_back( SpaceGroup(  39,  "Ac2m", "orthorhombic", "base", "A" ) );
      vspacegroup.push_back( SpaceGroup(  40,  "Ama2", "orthorhombic", "base", "A" ) );
      vspacegroup.push_back( SpaceGroup(  40,  "Bbm2", "orthorhombic", "base", "B" ) );
      vspacegroup.push_back( SpaceGroup(  40,  "B2mb", "orthorhombic", "base", "B" ) );
      vspacegroup.push_back( SpaceGroup(  40,  "C2cm", "orthorhombic", "base", "C" ) );
      vspacegroup.push_back( SpaceGroup(  40,  "Cc2m", "orthorhombic", "base", "C" ) );
      vspacegroup.push_back( SpaceGroup(  40,  "Am2a", "orthorhombic", "base", "A" ) );
      vspacegroup.push_back( SpaceGroup(  41,  "Aba2", "orthorhombic", "base", "A" ) );
      vspacegroup.push_back( SpaceGroup(  41,  "Bba2", "orthorhombic", "base", "B" ) );
      vspacegroup.push_back( SpaceGroup(  41,  "B2cb", "orthorhombic", "base", "B" ) );
      vspacegroup.push_back( SpaceGroup(  41,  "C2cb", "orthorhombic", "base", "C" ) );
      vspacegroup.push_back( SpaceGroup(  41,  "Cc2a", "orthorhombic", "base", "C" ) );
      vspacegroup.push_back( SpaceGroup(  41,  "Ac2a", "orthorhombic", "base", "A" ) );
      vspacegroup.push_back( SpaceGroup(  42,  "Fmm2", "orthorhombic", "face", "none" ) );
      vspacegroup.push_back( SpaceGroup(  42,  "F2mm", "orthorhombic", "face", "none" ) );
      vspacegroup.push_back( SpaceGroup(  42,  "Fm2m", "orthorhombic", "face", "none" ) );
      vspacegroup.push_back( SpaceGroup(  43,  "Fdd2", "orthorhombic", "face", "none" ) );
      vspacegroup.push_back( SpaceGroup(  43,  "F2dd", "orthorhombic", "face", "none" ) );
      vspacegroup.push_back( SpaceGroup(  43,  "Fd2d", "orthorhombic", "face", "none" ) );
      vspacegroup.push_back( SpaceGroup(  44,  "Imm2", "orthorhombic", "body", "none" ) );
      vspacegroup.push_back( SpaceGroup(  44,  "I2mm", "orthorhombic", "body", "none" ) );
      vspacegroup.push_back( SpaceGroup(  44,  "Im2m", "orthorhombic", "body", "none" ) );
      vspacegroup.push_back( SpaceGroup(  45,  "Iba2", "orthorhombic", "body", "none" ) );
      vspacegroup.push_back( SpaceGroup(  45,  "I2cb", "orthorhombic", "body", "none" ) );
      vspacegroup.push_back( SpaceGroup(  45,  "Ic2a", "orthorhombic", "body", "none" ) );
      vspacegroup.push_back( SpaceGroup(  46,  "Ima2", "orthorhombic", "body", "none" ) );
      vspacegroup.push_back( SpaceGroup(  46,  "Ibm2", "orthorhombic", "body", "none" ) );
      vspacegroup.push_back( SpaceGroup(  46,  "I2mb", "orthorhombic", "body", "none" ) );
      vspacegroup.push_back( SpaceGroup(  46,  "I2cm", "orthorhombic", "body", "none" ) );
      vspacegroup.push_back( SpaceGroup(  46,  "Ic2m", "orthorhombic", "body", "none" ) );
      vspacegroup.push_back( SpaceGroup(  46,  "Im2a", "orthorhombic", "body", "none" ) );
      vspacegroup.push_back( SpaceGroup(  47,  "Pmmm", "orthorhombic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  48,  "Pnnn", "orthorhombic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  49,  "Pccm", "orthorhombic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  49,  "Pmaa", "orthorhombic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  49,  "Pbmb", "orthorhombic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  50,  "Pban", "orthorhombic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  50,  "Pncb", "orthorhombic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  50,  "Pcna", "orthorhombic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  51,  "Pmma", "orthorhombic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  51,  "Pmmb", "orthorhombic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  51,  "Pbmm", "orthorhombic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  51,  "Pcmm", "orthorhombic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  51,  "Pmcm", "orthorhombic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  51,  "Pmam", "orthorhombic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  52,  "Pnna", "orthorhombic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  52,  "Pnnb", "orthorhombic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  52,  "Pbnn", "orthorhombic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  52,  "Pcnn", "orthorhombic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  52,  "Pncn", "orthorhombic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  52,  "Pnan", "orthorhombic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  53,  "Pmna", "orthorhombic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  53,  "Pnmb", "orthorhombic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  53,  "Pbmn", "orthorhombic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  53,  "Pcnm", "orthorhombic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  53,  "Pncm", "orthorhombic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  53,  "Pman", "orthorhombic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  54,  "Pcca", "orthorhombic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  54,  "Pccb", "orthorhombic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  54,  "Pbaa", "orthorhombic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  54,  "Pcaa", "orthorhombic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  54,  "Pbcb", "orthorhombic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  54,  "Pbab", "orthorhombic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  55,  "Pbam", "orthorhombic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  55,  "Pmcb", "orthorhombic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  55,  "Pcma", "orthorhombic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  56,  "Pccn", "orthorhombic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  56,  "Pnaa", "orthorhombic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  56,  "Pbnb", "orthorhombic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  57,  "Pbcm", "orthorhombic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  57,  "Pcam", "orthorhombic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  57,  "Pmca", "orthorhombic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  57,  "Pmab", "orthorhombic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  57,  "Pbma", "orthorhombic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  57,  "Pcmb", "orthorhombic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  58,  "Pnnm", "orthorhombic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  58,  "Pmnn", "orthorhombic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  58,  "Pnmn", "orthorhombic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  59,  "Pmmn", "orthorhombic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  59,  "Pnmm", "orthorhombic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  59,  "Pmnm", "orthorhombic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  60,  "Pbcn", "orthorhombic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  60,  "Pcan", "orthorhombic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  60,  "Pnca", "orthorhombic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  60,  "Pnab", "orthorhombic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  60,  "Pbna", "orthorhombic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  60,  "Pcnb", "orthorhombic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  61,  "Pbca", "orthorhombic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  61,  "Pcab", "orthorhombic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  62,  "Pnma", "orthorhombic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  62,  "Pmnb", "orthorhombic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  62,  "Pbnm", "orthorhombic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  62,  "Pcmn", "orthorhombic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  62,  "Pmcn", "orthorhombic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  62,  "Pnam", "orthorhombic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  63,  "Cmcm", "orthorhombic", "base", "C" ) );
      vspacegroup.push_back( SpaceGroup(  63,  "Ccmm", "orthorhombic", "base", "C" ) );
      vspacegroup.push_back( SpaceGroup(  63,  "Amma", "orthorhombic", "base", "A" ) );
      vspacegroup.push_back( SpaceGroup(  63,  "Amam", "orthorhombic", "base", "A" ) );
      vspacegroup.push_back( SpaceGroup(  63,  "Bbmm", "orthorhombic", "base", "B" ) );
      vspacegroup.push_back( SpaceGroup(  63,  "Bmmb", "orthorhombic", "base", "B" ) );
      vspacegroup.push_back( SpaceGroup(  64,  "Cmca", "orthorhombic", "base", "C" ) );
      vspacegroup.push_back( SpaceGroup(  64,  "Ccmb", "orthorhombic", "base", "C" ) );
      vspacegroup.push_back( SpaceGroup(  64,  "Abma", "orthorhombic", "base", "A" ) );
      vspacegroup.push_back( SpaceGroup(  64,  "Acam", "orthorhombic", "base", "A" ) );
      vspacegroup.push_back( SpaceGroup(  64,  "Bbcm", "orthorhombic", "base", "B" ) );
      vspacegroup.push_back( SpaceGroup(  64,  "Bmab", "orthorhombic", "base", "B" ) );
      vspacegroup.push_back( SpaceGroup(  65,  "Cmmm", "orthorhombic", "base", "C" ) );
      vspacegroup.push_back( SpaceGroup(  65,  "Ammm", "orthorhombic", "base", "A" ) );
      vspacegroup.push_back( SpaceGroup(  65,  "Bmmm", "orthorhombic", "base", "B" ) );
      vspacegroup.push_back( SpaceGroup(  66,  "Cccm", "orthorhombic", "base", "C" ) );
      vspacegroup.push_back( SpaceGroup(  66,  "Amaa", "orthorhombic", "base", "A" ) );
      vspacegroup.push_back( SpaceGroup(  66,  "Bbmb", "orthorhombic", "base", "B" ) );
      vspacegroup.push_back( SpaceGroup(  67,  "Cmma", "orthorhombic", "base", "C" ) );
      vspacegroup.push_back( SpaceGroup(  67,  "Cmmb", "orthorhombic", "base", "C" ) );
      vspacegroup.push_back( SpaceGroup(  67,  "Abmm", "orthorhombic", "base", "A" ) );
      vspacegroup.push_back( SpaceGroup(  67,  "Acmm", "orthorhombic", "base", "A" ) );
      vspacegroup.push_back( SpaceGroup(  67,  "Bmcm", "orthorhombic", "base", "B" ) );
      vspacegroup.push_back( SpaceGroup(  67,  "Bmam", "orthorhombic", "base", "B" ) );
      vspacegroup.push_back( SpaceGroup(  68,  "Ccca", "orthorhombic", "base", "C" ) );
      vspacegroup.push_back( SpaceGroup(  68,  "Cccb", "orthorhombic", "base", "C" ) );
      vspacegroup.push_back( SpaceGroup(  68,  "Abaa", "orthorhombic", "base", "A" ) );
      vspacegroup.push_back( SpaceGroup(  68,  "Acaa", "orthorhombic", "base", "A" ) );
      vspacegroup.push_back( SpaceGroup(  68,  "Bbcb", "orthorhombic", "base", "B" ) );
      vspacegroup.push_back( SpaceGroup(  68,  "Bbab", "orthorhombic", "base", "B" ) );
      vspacegroup.push_back( SpaceGroup(  69,  "Fmmm", "orthorhombic", "face", "none" ) );
      vspacegroup.push_back( SpaceGroup(  70,  "Fddd", "orthorhombic", "face", "none" ) );
      vspacegroup.push_back( SpaceGroup(  71,  "Immm", "orthorhombic", "body", "none" ) );
      vspacegroup.push_back( SpaceGroup(  72,  "Ibam", "orthorhombic", "body", "none" ) );
      vspacegroup.push_back( SpaceGroup(  72,  "Imcb", "orthorhombic", "body", "none" ) );
      vspacegroup.push_back( SpaceGroup(  72,  "Icma", "orthorhombic", "body", "none" ) );
      vspacegroup.push_back( SpaceGroup(  73,  "Ibca", "orthorhombic", "body", "none" ) );
      vspacegroup.push_back( SpaceGroup(  73,  "Icab", "orthorhombic", "body", "none" ) );
      vspacegroup.push_back( SpaceGroup(  74,  "Imma", "orthorhombic", "body", "none" ) );
      vspacegroup.push_back( SpaceGroup(  74,  "Immb", "orthorhombic", "body", "none" ) );
      vspacegroup.push_back( SpaceGroup(  74,  "Ibmm", "orthorhombic", "body", "none" ) );
      vspacegroup.push_back( SpaceGroup(  74,  "Icmm", "orthorhombic", "body", "none" ) );
      vspacegroup.push_back( SpaceGroup(  74,  "Imcm", "orthorhombic", "body", "none" ) );
      vspacegroup.push_back( SpaceGroup(  74,  "Imam", "orthorhombic", "body", "none" ) );
      vspacegroup.push_back( SpaceGroup(  75,  "P4", "tetragonal", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  76,  "P41", "tetragonal", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  77,  "P42", "tetragonal", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  78,  "P43", "tetragonal", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  79,  "I4", "tetragonal", "body", "none" ) );
      vspacegroup.push_back( SpaceGroup(  80,  "I41", "tetragonal", "body", "none" ) );
      vspacegroup.push_back( SpaceGroup(  81,  "P-4", "tetragonal", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  82,  "I-4", "tetragonal", "body", "none" ) );
      vspacegroup.push_back( SpaceGroup(  83,  "P4/m", "tetragonal", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  84,  "P42/m", "tetragonal", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  85,  "P4/n", "tetragonal", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  86,  "P42/n", "tetragonal", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  87,  "I4/m", "tetragonal", "body", "none" ) );
      vspacegroup.push_back( SpaceGroup(  88,  "I41/a", "tetragonal", "body", "none" ) );
      vspacegroup.push_back( SpaceGroup(  89,  "P422", "tetragonal", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  90,  "P4212", "tetragonal", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  91,  "P4122", "tetragonal", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  92,  "P41212", "tetragonal", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  93,  "P4222", "tetragonal", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  94,  "P42212", "tetragonal", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  95,  "P4322", "tetragonal", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  96,  "P43212", "tetragonal", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup(  97,  "I422", "tetragonal", "body", "none" ) );
      vspacegroup.push_back( SpaceGroup(  98,  "I4122", "tetragonal", "body", "none" ) );
      vspacegroup.push_back( SpaceGroup(  99,  "P4mm", "tetragonal", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup( 100,  "P4bm", "tetragonal", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup( 101,  "P42cm", "tetragonal", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup( 102,  "P42nm", "tetragonal", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup( 103,  "P4cc", "tetragonal", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup( 104,  "P4nc", "tetragonal", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup( 105,  "P42mc", "tetragonal", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup( 106,  "P42bc", "tetragonal", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup( 107,  "I4mm", "tetragonal", "body", "none" ) );
      vspacegroup.push_back( SpaceGroup( 108,  "I4cm", "tetragonal", "body", "none" ) );
      vspacegroup.push_back( SpaceGroup( 109,  "I41md", "tetragonal", "body", "none" ) );
      vspacegroup.push_back( SpaceGroup( 110,  "I41cd", "tetragonal", "body", "none" ) );
      vspacegroup.push_back( SpaceGroup( 111,  "P-42m", "tetragonal", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup( 112,  "P-42c", "tetragonal", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup( 113,  "P-421m", "tetragonal", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup( 114,  "P-421c", "tetragonal", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup( 115,  "P-4m2", "tetragonal", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup( 116,  "P-4c2", "tetragonal", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup( 117,  "P-4b2", "tetragonal", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup( 118,  "P-4n2", "tetragonal", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup( 119,  "I-4m2", "tetragonal", "body", "none" ) );
      vspacegroup.push_back( SpaceGroup( 120,  "I-4c2", "tetragonal", "body", "none" ) );
      vspacegroup.push_back( SpaceGroup( 121,  "I-42m", "tetragonal", "body", "none" ) );
      vspacegroup.push_back( SpaceGroup( 122,  "I-42d", "tetragonal", "body", "none" ) );
      vspacegroup.push_back( SpaceGroup( 123,  "P4/mmm", "tetragonal", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup( 124,  "P4/mcc", "tetragonal", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup( 125,  "P4/nbm", "tetragonal", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup( 126,  "P4/nnc", "tetragonal", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup( 127,  "P4/mbm", "tetragonal", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup( 128,  "P4/mnc", "tetragonal", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup( 129,  "P4/nmm", "tetragonal", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup( 130,  "P4/ncc", "tetragonal", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup( 131,  "P42/mmc", "tetragonal", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup( 132,  "P42/mcm", "tetragonal", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup( 133,  "P42/nbc", "tetragonal", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup( 134,  "P42/nnm", "tetragonal", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup( 135,  "P42/mbc", "tetragonal", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup( 136,  "P42/mnm", "tetragonal", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup( 137,  "P42/nmc", "tetragonal", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup( 138,  "P42/ncm", "tetragonal", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup( 139,  "I4/mmm", "tetragonal", "body", "none" ) );
      vspacegroup.push_back( SpaceGroup( 140,  "I4/mcm", "tetragonal", "body", "none" ) );
      vspacegroup.push_back( SpaceGroup( 141,  "I41/amd", "tetragonal", "body", "none" ) );
      vspacegroup.push_back( SpaceGroup( 142,  "I41/acd", "tetragonal", "body", "none" ) );
      vspacegroup.push_back( SpaceGroup( 143,  "P3", "trigonal", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup( 144,  "P31", "trigonal", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup( 145,  "P32", "trigonal", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup( 146,  "R3", "trigonal", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup( 147,  "P-3", "trigonal", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup( 148,  "R-3", "trigonal", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup( 149,  "P312", "trigonal", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup( 150,  "P321", "trigonal", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup( 151,  "P3112", "trigonal", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup( 152,  "P3121", "trigonal", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup( 153,  "P3212", "trigonal", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup( 154,  "P3221", "trigonal", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup( 155,  "R32", "trigonal", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup( 156,  "P3m1", "trigonal", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup( 157,  "P31m", "trigonal", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup( 158,  "P3c1", "trigonal", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup( 159,  "P31c", "trigonal", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup( 160,  "R3m", "trigonal", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup( 161,  "R3c", "trigonal", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup( 162,  "P-31m", "trigonal", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup( 163,  "P-31c", "trigonal", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup( 164,  "P-3m1", "trigonal", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup( 165,  "P-3c1", "trigonal", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup( 166,  "R-3m", "trigonal", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup( 167,  "R-3c", "trigonal", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup( 168,  "P6", "hexagonal", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup( 169,  "P61", "hexagonal", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup( 170,  "P65", "hexagonal", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup( 171,  "P62", "hexagonal", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup( 172,  "P64", "hexagonal", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup( 173,  "P63", "hexagonal", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup( 174,  "P-6", "hexagonal", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup( 175,  "P6/m", "hexagonal", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup( 176,  "P63/m", "hexagonal", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup( 177,  "P622", "hexagonal", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup( 178,  "P6122", "hexagonal", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup( 179,  "P6522", "hexagonal", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup( 180,  "P6222", "hexagonal", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup( 181,  "P6422", "hexagonal", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup( 182,  "P6322", "hexagonal", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup( 183,  "P6mm", "hexagonal", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup( 184,  "P6cc", "hexagonal", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup( 185,  "P63cm", "hexagonal", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup( 186,  "P63mc", "hexagonal", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup( 187,  "P-6m2", "hexagonal", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup( 188,  "P-6c2", "hexagonal", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup( 189,  "P-62m", "hexagonal", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup( 190,  "P-62c", "hexagonal", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup( 191,  "P6/mmm", "hexagonal", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup( 192,  "P6/mcc", "hexagonal", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup( 193,  "P63/mcm", "hexagonal", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup( 194,  "P63/mmc", "hexagonal", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup( 195,  "P23", "cubic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup( 196,  "F23", "cubic", "face", "none" ) );
      vspacegroup.push_back( SpaceGroup( 197,  "I23", "cubic", "body", "none" ) );
      vspacegroup.push_back( SpaceGroup( 198,  "P213", "cubic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup( 199,  "I213", "cubic", "body", "none" ) );
      vspacegroup.push_back( SpaceGroup( 200,  "Pm3", "cubic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup( 201,  "Pn3", "cubic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup( 202,  "Fm3", "cubic", "face", "none" ) );
      vspacegroup.push_back( SpaceGroup( 203,  "Fd3", "cubic", "face", "none" ) );
      vspacegroup.push_back( SpaceGroup( 204,  "Im3", "cubic", "body", "none" ) );
      vspacegroup.push_back( SpaceGroup( 205,  "Pa3", "cubic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup( 206,  "Ia3", "cubic", "body", "none" ) );
      vspacegroup.push_back( SpaceGroup( 207,  "P432", "cubic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup( 208,  "P4232", "cubic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup( 209,  "F432", "cubic", "face", "none" ) );
      vspacegroup.push_back( SpaceGroup( 210,  "F4132", "cubic", "face", "none" ) );
      vspacegroup.push_back( SpaceGroup( 211,  "I432", "cubic", "body", "none" ) );
      vspacegroup.push_back( SpaceGroup( 212,  "P4332", "cubic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup( 213,  "P4132", "cubic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup( 214,  "I4132", "cubic", "body", "none" ) );
      vspacegroup.push_back( SpaceGroup( 215,  "P-43m", "cubic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup( 216,  "F-43m", "cubic", "face", "none" ) );
      vspacegroup.push_back( SpaceGroup( 217,  "I-43m", "cubic", "body", "none" ) );
      vspacegroup.push_back( SpaceGroup( 218,  "P-43n", "cubic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup( 219,  "F-43c", "cubic", "face", "none" ) );
      vspacegroup.push_back( SpaceGroup( 220,  "I-43d", "cubic", "body", "none" ) );
      vspacegroup.push_back( SpaceGroup( 221,  "Pm-3m", "cubic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup( 222,  "Pn-3n", "cubic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup( 223,  "Pm-3n", "cubic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup( 224,  "Pn-3m", "cubic", "simple", "none" ) );
      vspacegroup.push_back( SpaceGroup( 225,  "Fm-3m", "cubic", "face", "none" ) );
      vspacegroup.push_back( SpaceGroup( 226,  "Fm-3c", "cubic", "face", "none" ) );
      vspacegroup.push_back( SpaceGroup( 227,  "Fd-3m", "cubic", "face", "none" ) );
      vspacegroup.push_back( SpaceGroup( 228,  "Fd-3c", "cubic", "face", "none" ) );
      vspacegroup.push_back( SpaceGroup( 229,  "Im-3m", "cubic", "body", "none" ) );
      vspacegroup.push_back( SpaceGroup( 230,  "Ia-3d", "cubic", "body", "none" ) );
  }

  bool find( SpaceGroup& spacegroup, const QString& nameHM ){
    for( int g=0; g<(int)vspacegroup.size(); g++ ){
      if( vspacegroup[g].nameHM == nameHM ){
	spacegroup = vspacegroup[g];
	return true;
      }
    }  
    return false;
  }
  bool find( SpaceGroup& spacegroup, const int number ){
    for( int g=0; g<(int)vspacegroup.size(); g++ ){
      if( vspacegroup[g].number == number ){
	spacegroup = vspacegroup[g];
	return true;
      }
    }  
    return false;
  }
};




#endif // __SPACEGROUP_H_INCLUDED
