/*
 Copyright (c) 2014 Shinji Tsuneyuki
 This file is distributed under the terms of the GNU General Public License version 3.
 */

/*!
 \file vector2d.h
 \brief 񎟌tB[hNX
*/

#ifndef __VECTOR2D_H_INCLUDED
#define __VECTOR2D_H_INCLUDED

#include <vector>
using namespace std;


// 2iq_f[^NX
// 1 STL vector ^Ŏ
template <typename T> class vector2d
{
protected:
  vector<T> data;
  int nx, ny;

public:
  // RXgN^
  vector2d( void ){
    nx = ny = 0;
  }
  // RXgN^ TCYw
  vector2d( const int _nx, const int _ny ) {
    resize( _nx, _ny );
  }

  // TCYύX
  void resize( const int _nx, const int _ny ) {
    nx = _nx, ny = _ny;
    data.resize(nx*ny);
  }

  // [
  void zero( void ){
    for( int i=0; i<size(); i++ ){
      data[i] = T(0);
    }
  }

  // 
  void clear( void ){
    data.clear(); // just set the size of array to 0.
    vector<T>().swap( data ); // really free the memory.
    nx = ny = 0;
  }

  // TCY X
  int sizeX( void ) const {
    return nx;
  }
  // TCY Y
  int sizeY( void ) const {
    return ny;
  }
  // TCY S
  int size( void ) const {
    return sizeX() * sizeY();
  }
  bool empty( void ) const {
    return data.empty();
  }

  // ݃ANZXZq
  inline T& operator () ( const int ix, const int iy ){
    return data[ix*ny + iy];
  }
  // ǂݍ݃ANZXZq
  inline const T& operator () ( const int ix, const int iy ) const {
    return data[ix*ny + iy];
  }

  // ݃ANZXZq
  inline T& operator () ( const int i ){
    return data[i];
  }
  // ǂݍ݃ANZXZq
  inline const T& operator () ( const int i ) const {
    return data[i];
  }

  inline operator const T* ( void ) const {
    return &data[0];
  }
  inline operator T* ( void ){
    return &data[0];
  }
};

#endif // __VECTOR2D_H_INCLUDED
