/*
 Copyright (c) 2014 Shinji Tsuneyuki
 This file is distributed under the terms of the GNU General Public License version 3.
 */

#ifndef __MAINWINDOW_H_INCLUDED
#define __MAINWINDOW_H_INCLUDED

#include <QtOpenGL/QGLWidget>
#include <QtCore/QString>

#include "dtmodel.h"
#include "glview.h"
#include "glview2d.h"
#include "qtctrl.h"

class MyEvent;

class MainWindow : public QMainWindow
{
  Q_OBJECT

  DTModel model;
  GLView  view;
  GLView2d  view2d;
  QTCtrl  ctrl;

  QString path;

public:
  MainWindow( void );
  ~MainWindow( void );

private:
  enum { ID_FILE,
	 ID_FILE_NEW,
	 ID_FILE_LOAD_MOLECULE,
	 ID_FILE_LOAD_XTAPP,
	 ID_FILE_LOAD_FIELD,
	 ID_FILE_LOAD_BAND,
	 ID_FILE_LOAD_DOS,
	 ID_FILE_SAVE_MOLECULE,
	 ID_FILE_SAVE_XTAPP,
	 ID_FILE_QUIT,
	 ID_LATTICE,
	 ID_ATOMS,
	 ID_XTAPP,
	 ID_TCPP,
	 ID_GRAPHICS,
	 ID_UNDO,
	 ID_EXECUTE_XTAPP,
	 ID_VIEW2D };

private:
  void idle( void );

private slots:
  void edit( const MyEvent& ev );
public slots:
  void update( void );

public:
  bool load( const QString& fname );
};

#endif // __MAINWINDOW_H_INCLUDED
